/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.output;

import com.sun.xml.bind.v2.runtime.output.UTF8XmlOutput;
import java.io.IOException;

public final class Encoded {
    public byte[] buf;
    public int len;
    private static final byte[][] entities = new byte[128][];
    private static final byte[][] attributeEntities = new byte[128][];

    public Encoded() {
    }

    public Encoded(String text) {
        this.set(text);
    }

    public void ensureSize(int size2) {
        if (this.buf == null || this.buf.length < size2) {
            this.buf = new byte[size2];
        }
    }

    public final void set(String text) {
        int length2 = text.length();
        this.ensureSize(length2 * 3 + 1);
        int ptr = 0;
        for (int i2 = 0; i2 < length2; ++i2) {
            char chr2 = text.charAt(i2);
            if (chr2 > '\u007f') {
                if (chr2 > '\u07ff') {
                    if ('\ud800' <= chr2 && chr2 <= '\udfff') {
                        int uc = ((chr2 & 0x3FF) << 10 | text.charAt(++i2) & 0x3FF) + 65536;
                        this.buf[ptr++] = (byte)(0xF0 | uc >> 18);
                        this.buf[ptr++] = (byte)(0x80 | uc >> 12 & 0x3F);
                        this.buf[ptr++] = (byte)(0x80 | uc >> 6 & 0x3F);
                        this.buf[ptr++] = (byte)(128 + (uc & 0x3F));
                        continue;
                    }
                    this.buf[ptr++] = (byte)(224 + (chr2 >> 12));
                    this.buf[ptr++] = (byte)(128 + (chr2 >> 6 & 0x3F));
                } else {
                    this.buf[ptr++] = (byte)(192 + (chr2 >> 6));
                }
                this.buf[ptr++] = (byte)(128 + (chr2 & 0x3F));
                continue;
            }
            this.buf[ptr++] = (byte)chr2;
        }
        this.len = ptr;
    }

    public final void setEscape(String text, boolean isAttribute) {
        int length2 = text.length();
        this.ensureSize(length2 * 6 + 1);
        int ptr = 0;
        for (int i2 = 0; i2 < length2; ++i2) {
            char chr2 = text.charAt(i2);
            int ptr1 = ptr;
            if (chr2 > '\u007f') {
                if (chr2 > '\u07ff') {
                    if ('\ud800' <= chr2 && chr2 <= '\udfff') {
                        int uc = ((chr2 & 0x3FF) << 10 | text.charAt(++i2) & 0x3FF) + 65536;
                        this.buf[ptr++] = (byte)(0xF0 | uc >> 18);
                        this.buf[ptr++] = (byte)(0x80 | uc >> 12 & 0x3F);
                        this.buf[ptr++] = (byte)(0x80 | uc >> 6 & 0x3F);
                        this.buf[ptr++] = (byte)(128 + (uc & 0x3F));
                        continue;
                    }
                    this.buf[ptr1++] = (byte)(224 + (chr2 >> 12));
                    this.buf[ptr1++] = (byte)(128 + (chr2 >> 6 & 0x3F));
                } else {
                    this.buf[ptr1++] = (byte)(192 + (chr2 >> 6));
                }
                this.buf[ptr1++] = (byte)(128 + (chr2 & 0x3F));
            } else {
                byte[] ent = attributeEntities[chr2];
                if (ent != null) {
                    if (isAttribute || entities[chr2] != null) {
                        ptr1 = this.writeEntity(ent, ptr1);
                    } else {
                        this.buf[ptr1++] = (byte)chr2;
                    }
                } else {
                    this.buf[ptr1++] = (byte)chr2;
                }
            }
            ptr = ptr1;
        }
        this.len = ptr;
    }

    private int writeEntity(byte[] entity, int ptr) {
        System.arraycopy(entity, 0, this.buf, ptr, entity.length);
        return ptr + entity.length;
    }

    public final void write(UTF8XmlOutput out) throws IOException {
        out.write(this.buf, 0, this.len);
    }

    public void append(char b2) {
        this.buf[this.len++] = (byte)b2;
    }

    public void compact() {
        byte[] b2 = new byte[this.len];
        System.arraycopy(this.buf, 0, b2, 0, this.len);
        this.buf = b2;
    }

    private static void add(char c, String s2, boolean attOnly) {
        byte[] image2 = UTF8XmlOutput.toBytes(s2);
        Encoded.attributeEntities[c] = image2;
        if (!attOnly) {
            Encoded.entities[c] = image2;
        }
    }

    static {
        Encoded.add('&', "&amp;", false);
        Encoded.add('<', "&lt;", false);
        Encoded.add('>', "&gt;", false);
        Encoded.add('\"', "&quot;", true);
        Encoded.add('\t', "&#x9;", true);
        Encoded.add('\r', "&#xD;", false);
        Encoded.add('\n', "&#xA;", true);
    }
}

