/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.reflect;

import com.sun.xml.bind.WhiteSpaceProcessor;
import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.v2.runtime.Transducer;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.bind.v2.runtime.reflect.DefaultTransducedAccessor;
import com.sun.xml.bind.v2.runtime.reflect.ListIterator;
import com.sun.xml.bind.v2.runtime.reflect.Lister;
import javax.xml.bind.JAXBException;
import org.xml.sax.SAXException;

public final class ListTransducedAccessorImpl<BeanT, ListT, ItemT, PackT>
extends DefaultTransducedAccessor<BeanT> {
    private final Transducer<ItemT> xducer;
    private final Lister<BeanT, ListT, ItemT, PackT> lister;
    private final Accessor<BeanT, ListT> acc;

    public ListTransducedAccessorImpl(Transducer<ItemT> xducer, Accessor<BeanT, ListT> acc, Lister<BeanT, ListT, ItemT, PackT> lister) {
        this.xducer = xducer;
        this.lister = lister;
        this.acc = acc;
    }

    @Override
    public boolean useNamespace() {
        return this.xducer.useNamespace();
    }

    @Override
    public void declareNamespace(BeanT bean, XMLSerializer w) throws AccessorException, SAXException {
        ListT list2 = this.acc.get(bean);
        if (list2 != null) {
            ListIterator<ItemT> itr = this.lister.iterator(list2, w);
            while (itr.hasNext()) {
                try {
                    ItemT item = itr.next();
                    if (item == null) continue;
                    this.xducer.declareNamespace(item, w);
                }
                catch (JAXBException e) {
                    w.reportError(null, e);
                }
            }
        }
    }

    @Override
    public String print(BeanT o) throws AccessorException, SAXException {
        ListT list2 = this.acc.get(o);
        if (list2 == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        XMLSerializer w = XMLSerializer.getInstance();
        ListIterator<ItemT> itr = this.lister.iterator(list2, w);
        while (itr.hasNext()) {
            try {
                ItemT item = itr.next();
                if (item == null) continue;
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(this.xducer.print(item));
            }
            catch (JAXBException e) {
                w.reportError(null, e);
            }
        }
        return buf.toString();
    }

    private void processValue(BeanT bean, CharSequence s2) throws AccessorException, SAXException {
        PackT pack2 = this.lister.startPacking(bean, this.acc);
        int idx = 0;
        int len = s2.length();
        while (true) {
            int p2;
            for (p2 = idx; p2 < len && !WhiteSpaceProcessor.isWhiteSpace(s2.charAt(p2)); ++p2) {
            }
            CharSequence token = s2.subSequence(idx, p2);
            if (!token.equals("")) {
                this.lister.addToPack(pack2, this.xducer.parse(token));
            }
            if (p2 == len) break;
            while (p2 < len && WhiteSpaceProcessor.isWhiteSpace(s2.charAt(p2))) {
                ++p2;
            }
            if (p2 == len) break;
            idx = p2;
        }
        this.lister.endPacking(pack2, bean, this.acc);
    }

    @Override
    public void parse(BeanT bean, CharSequence lexical) throws AccessorException, SAXException {
        this.processValue(bean, lexical);
    }

    @Override
    public boolean hasValue(BeanT bean) throws AccessorException {
        return this.acc.get(bean) != null;
    }
}

