/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.util;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.WeakHashMap;

public class EditDistance {
    private static final WeakHashMap<AbstractMap.SimpleEntry<String, String>, Integer> CACHE = new WeakHashMap();
    private int[] cost;
    private int[] back;
    private final String a;
    private final String b;

    public static int editDistance(String a, String b2) {
        AbstractMap.SimpleEntry<String, String> entry = new AbstractMap.SimpleEntry<String, String>(a, b2);
        Integer result2 = null;
        if (CACHE.containsKey(entry)) {
            result2 = CACHE.get(entry);
        }
        if (result2 == null) {
            result2 = new EditDistance(a, b2).calc();
            CACHE.put(entry, result2);
        }
        return result2;
    }

    public static String findNearest(String key2, String[] group2) {
        return EditDistance.findNearest(key2, Arrays.asList(group2));
    }

    public static String findNearest(String key2, Collection<String> group2) {
        int c = Integer.MAX_VALUE;
        String r = null;
        for (String s2 : group2) {
            int ed = EditDistance.editDistance(key2, s2);
            if (c <= ed) continue;
            c = ed;
            r = s2;
        }
        return r;
    }

    private EditDistance(String a, String b2) {
        this.a = a;
        this.b = b2;
        this.cost = new int[a.length() + 1];
        this.back = new int[a.length() + 1];
        for (int i2 = 0; i2 <= a.length(); ++i2) {
            this.cost[i2] = i2;
        }
    }

    private void flip() {
        int[] t = this.cost;
        this.cost = this.back;
        this.back = t;
    }

    private int min(int a, int b2, int c) {
        return Math.min(a, Math.min(b2, c));
    }

    private int calc() {
        for (int j = 0; j < this.b.length(); ++j) {
            this.flip();
            this.cost[0] = j + 1;
            for (int i2 = 0; i2 < this.a.length(); ++i2) {
                int match2 = this.a.charAt(i2) == this.b.charAt(j) ? 0 : 1;
                this.cost[i2 + 1] = this.min(this.back[i2] + match2, this.cost[i2] + 1, this.back[i2 + 1] + 1);
            }
        }
        return this.cost[this.a.length()];
    }
}

