/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.converter;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelConverterContextImpl
implements ModelConverterContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelConverterContextImpl.class);
    private final List<ModelConverter> converters;
    private final Map<String, Model> modelByName;
    private final HashMap<Type, Model> modelByType;
    private final Set<Type> processedTypes;
    private JsonView jsonView;

    public ModelConverterContextImpl(List<ModelConverter> converters) {
        this.converters = converters;
        this.modelByName = new TreeMap<String, Model>();
        this.modelByType = new HashMap();
        this.processedTypes = new HashSet<Type>();
    }

    public ModelConverterContextImpl(ModelConverter converter) {
        this(new ArrayList<ModelConverter>());
        this.converters.add(converter);
    }

    @Override
    public Iterator<ModelConverter> getConverters() {
        return this.converters.iterator();
    }

    @Override
    public void defineModel(String name2, Model model) {
        this.defineModel(name2, model, null, null);
    }

    @Override
    public void defineModel(String name2, Model model, Type type2, String prevName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("defineModel %s %s", name2, model));
        }
        this.modelByName.put(name2, model);
        if (StringUtils.isNotBlank(prevName)) {
            this.modelByName.remove(prevName);
        }
        if (type2 != null) {
            this.modelByType.put(type2, model);
        }
    }

    public Map<String, Model> getDefinedModels() {
        return Collections.unmodifiableMap(this.modelByName);
    }

    @Override
    public Property resolveProperty(Type type2, Annotation[] annotations2) {
        Iterator<ModelConverter> converters;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("resolveProperty %s", type2));
        }
        if ((converters = this.getConverters()).hasNext()) {
            ModelConverter converter = converters.next();
            return converter.resolveProperty(type2, this, annotations2, converters);
        }
        return null;
    }

    @Override
    public Model resolve(Type type2) {
        if (this.processedTypes.contains(type2)) {
            return this.modelByType.get(type2);
        }
        this.processedTypes.add(type2);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("resolve %s", type2));
        }
        Iterator<ModelConverter> converters = this.getConverters();
        Model resolved = null;
        if (converters.hasNext()) {
            ModelConverter converter = converters.next();
            LOGGER.debug("trying extension " + converter);
            resolved = converter.resolve(type2, this, converters);
        }
        if (resolved != null) {
            ModelImpl impl2;
            this.modelByType.put(type2, resolved);
            Model resolvedImpl = resolved;
            if (resolvedImpl instanceof ComposedModel) {
                resolvedImpl = ((ComposedModel)resolved).getChild();
            }
            if (resolvedImpl instanceof ModelImpl && (impl2 = (ModelImpl)resolvedImpl).getName() != null) {
                this.modelByName.put(impl2.getName(), resolved);
            }
        }
        return resolved;
    }

    @Override
    public JsonView getJsonView() {
        return this.jsonView;
    }

    @Override
    public void setJsonView(JsonView jsonView) {
        this.jsonView = jsonView;
    }
}

