/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.converter;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContextImpl;
import io.swagger.jackson.ModelResolver;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import io.swagger.util.Json;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelConverters {
    private static final ModelConverters SINGLETON = new ModelConverters();
    static Logger LOGGER = LoggerFactory.getLogger(ModelConverters.class);
    private final List<ModelConverter> converters;
    private final Set<String> skippedPackages = new HashSet<String>();
    private final Set<String> skippedClasses = new HashSet<String>();

    public ModelConverters() {
        this.converters = new CopyOnWriteArrayList<ModelConverter>();
        this.converters.add(new ModelResolver(Json.mapper()));
    }

    public static ModelConverters getInstance() {
        return SINGLETON;
    }

    public void addConverter(ModelConverter converter) {
        this.converters.add(0, converter);
    }

    public void removeConverter(ModelConverter converter) {
        this.converters.remove(converter);
    }

    public void addPackageToSkip(String pkg) {
        this.skippedPackages.add(pkg);
    }

    public void addClassToSkip(String cls) {
        LOGGER.warn("skipping class " + cls);
        this.skippedClasses.add(cls);
    }

    public Property readAsProperty(Type type2) {
        return this.readAsProperty(type2, null);
    }

    public Property readAsProperty(Type type2, JsonView jsonView) {
        ModelConverterContextImpl context = new ModelConverterContextImpl(this.converters);
        context.setJsonView(jsonView);
        return context.resolveProperty(type2, null);
    }

    public Map<String, Model> read(Type type2) {
        return this.read(type2, null);
    }

    public Map<String, Model> read(Type type2, JsonView jsonView) {
        HashMap<String, Model> modelMap = new HashMap<String, Model>();
        if (this.shouldProcess(type2)) {
            ModelConverterContextImpl context = new ModelConverterContextImpl(this.converters);
            context.setJsonView(jsonView);
            Model resolve = context.resolve(type2);
            for (Map.Entry<String, Model> entry : context.getDefinedModels().entrySet()) {
                if (!entry.getValue().equals(resolve)) continue;
                modelMap.put(entry.getKey(), entry.getValue());
            }
        }
        return modelMap;
    }

    public Map<String, Model> readAll(Type type2) {
        return this.readAll(type2, null);
    }

    public Map<String, Model> readAll(Type type2, JsonView annotation2) {
        if (this.shouldProcess(type2)) {
            ModelConverterContextImpl context = new ModelConverterContextImpl(this.converters);
            context.setJsonView(annotation2);
            LOGGER.debug("ModelConverters readAll with JsonView annotation from " + type2);
            context.resolve(type2);
            return context.getDefinedModels();
        }
        return new HashMap<String, Model>();
    }

    private boolean shouldProcess(Type type2) {
        Class<?> cls = TypeFactory.defaultInstance().constructType(type2).getRawClass();
        if (cls.isPrimitive()) {
            return false;
        }
        String className = cls.getName();
        for (String packageName : this.skippedPackages) {
            if (!className.startsWith(packageName)) continue;
            return false;
        }
        for (String classToSkip : this.skippedClasses) {
            if (!className.equals(classToSkip)) continue;
            return false;
        }
        return true;
    }

    static {
        ModelConverters.SINGLETON.skippedPackages.add("java.lang");
        ServiceLoader<ModelConverter> loader = ServiceLoader.load(ModelConverter.class);
        for (ModelConverter ext2 : loader) {
            if (ext2 == null) {
                LOGGER.error("failed to load extension " + ext2);
                continue;
            }
            SINGLETON.addConverter(ext2);
            LOGGER.debug("adding ModelConverter: " + ext2);
        }
    }
}

