/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.core.filter;

import io.swagger.core.filter.AbstractSpecFilter;
import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.model.ApiDescription;
import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecFilter {
    Logger LOGGER = LoggerFactory.getLogger(SpecFilter.class);

    public Swagger filter(Swagger swagger, SwaggerSpecFilter filter, Map<String, List<String>> params2, Map<String, String> cookies, Map<String, List<String>> headers) {
        Swagger clone2 = new Swagger();
        clone2.info(swagger.getInfo()).tags((List<Tag>)(swagger.getTags() == null ? null : new ArrayList<Tag>(swagger.getTags()))).host(swagger.getHost()).basePath(swagger.getBasePath()).schemes(swagger.getSchemes()).consumes(swagger.getConsumes()).produces(swagger.getProduces()).externalDocs(swagger.getExternalDocs()).vendorExtensions(swagger.getVendorExtensions());
        HashSet<String> filteredTags = new HashSet<String>();
        HashSet allowedTags = new HashSet();
        for (String resourcePath : swagger.getPaths().keySet()) {
            Path path2 = swagger.getPaths().get(resourcePath);
            HashMap<String, Operation> ops = new HashMap<String, Operation>();
            ops.put("get", path2.getGet());
            ops.put("head", path2.getHead());
            ops.put("put", path2.getPut());
            ops.put("post", path2.getPost());
            ops.put("delete", path2.getDelete());
            ops.put("patch", path2.getPatch());
            ops.put("options", path2.getOptions());
            Path clonedPath = new Path();
            for (String key2 : ops.keySet()) {
                HashSet<String> tags;
                Operation op = (Operation)ops.get(key2);
                if (op == null) continue;
                ApiDescription desc = new ApiDescription(resourcePath, key2);
                if (filter.isOperationAllowed(op, desc, params2, cookies, headers)) {
                    clonedPath.set(key2, this.filterOperation(filter, op, desc, params2, cookies, headers));
                    tags = allowedTags;
                } else {
                    tags = filteredTags;
                }
                if (op.getTags() == null) continue;
                tags.addAll(op.getTags());
            }
            if (clonedPath.isEmpty()) continue;
            clone2.path(resourcePath, clonedPath);
        }
        List<Tag> tags = clone2.getTags();
        filteredTags.removeAll(allowedTags);
        if (tags != null && !filteredTags.isEmpty()) {
            Iterator<Tag> it = tags.iterator();
            while (it.hasNext()) {
                if (!filteredTags.contains(it.next().getName())) continue;
                it.remove();
            }
            if (clone2.getTags().isEmpty()) {
                clone2.setTags(null);
            }
        }
        Map<String, Model> definitions = this.filterDefinitions(filter, swagger.getDefinitions(), params2, cookies, headers);
        clone2.setSecurityDefinitions(swagger.getSecurityDefinitions());
        clone2.setSecurity(swagger.getSecurity());
        clone2.setDefinitions(definitions);
        if (filter instanceof AbstractSpecFilter && ((AbstractSpecFilter)filter).isRemovingUnreferencedDefinitions()) {
            clone2 = this.removeBrokenReferenceDefinitions(clone2);
        }
        return clone2;
    }

    private Swagger removeBrokenReferenceDefinitions(Swagger swagger) {
        if (swagger.getDefinitions() == null || swagger.getDefinitions().isEmpty()) {
            return swagger;
        }
        TreeSet<String> referencedDefinitions = new TreeSet<String>();
        if (swagger.getResponses() != null) {
            for (Response response : swagger.getResponses().values()) {
                Set<String> modelRef = this.getModelRef(response.getResponseSchema());
                if (modelRef == null) continue;
                referencedDefinitions.addAll(modelRef);
            }
        }
        if (swagger.getParameters() != null) {
            for (Parameter p2 : swagger.getParameters().values()) {
                Iterator<Operation> bp;
                Set<String> modelRef;
                if (!(p2 instanceof BodyParameter) || (modelRef = this.getModelRef(((BodyParameter)((Object)(bp = (BodyParameter)p2))).getSchema())) == null) continue;
                referencedDefinitions.addAll(modelRef);
            }
        }
        if (swagger.getPaths() != null) {
            for (Path path2 : swagger.getPaths().values()) {
                if (path2.getParameters() != null) {
                    for (Parameter p3 : path2.getParameters()) {
                        BodyParameter bp;
                        Set<String> modelRef;
                        if (!(p3 instanceof BodyParameter) || (modelRef = this.getModelRef((bp = (BodyParameter)p3).getSchema())) == null) continue;
                        referencedDefinitions.addAll(modelRef);
                    }
                }
                if (path2.getOperations() == null) continue;
                for (Operation op : path2.getOperations()) {
                    if (op.getResponses() != null) {
                        for (Response response : op.getResponses().values()) {
                            Set<String> modelRef = this.getModelRef(response.getResponseSchema());
                            if (modelRef == null) continue;
                            referencedDefinitions.addAll(modelRef);
                        }
                    }
                    if (op.getParameters() == null) continue;
                    for (Parameter p4 : op.getParameters()) {
                        BodyParameter bp;
                        Set<String> modelRef;
                        if (!(p4 instanceof BodyParameter) || (modelRef = this.getModelRef((bp = (BodyParameter)p4).getSchema())) == null) continue;
                        referencedDefinitions.addAll(modelRef);
                    }
                }
            }
        }
        if (swagger.getDefinitions() != null) {
            TreeSet<String> nestedReferencedDefinitions = new TreeSet<String>();
            for (String ref : referencedDefinitions) {
                this.locateReferencedDefinitions(ref, nestedReferencedDefinitions, swagger);
            }
            referencedDefinitions.addAll(nestedReferencedDefinitions);
            swagger.getDefinitions().keySet().retainAll(referencedDefinitions);
        }
        return swagger;
    }

    private void locateReferencedDefinitions(Map<String, Property> props, Set<String> nestedReferencedDefinitions, Swagger swagger) {
        if (props == null) {
            return;
        }
        for (String keyProp : props.keySet()) {
            Property p2 = props.get(keyProp);
            String ref = this.getPropertyRef(p2);
            if (ref == null) continue;
            this.locateReferencedDefinitions(ref, nestedReferencedDefinitions, swagger);
        }
    }

    private void locateReferencedDefinitions(String ref, Set<String> nestedReferencedDefinitions, Swagger swagger) {
        if (!nestedReferencedDefinitions.contains(ref)) {
            nestedReferencedDefinitions.add(ref);
            Model model = swagger.getDefinitions().get(ref);
            if (model != null) {
                this.locateReferencedDefinitions(model.getProperties(), nestedReferencedDefinitions, swagger);
            }
        }
    }

    public Map<String, Model> filterDefinitions(SwaggerSpecFilter filter, Map<String, Model> definitions, Map<String, List<String>> params2, Map<String, String> cookies, Map<String, List<String>> headers) {
        if (definitions == null) {
            return null;
        }
        LinkedHashMap<String, Model> clonedDefinitions = new LinkedHashMap<String, Model>();
        for (String key2 : definitions.keySet()) {
            Model clonedModel;
            Model definition = definitions.get(key2);
            if (filter instanceof AbstractSpecFilter) {
                boolean shouldIncludeDefinition = true;
                try {
                    shouldIncludeDefinition = ((AbstractSpecFilter)filter).isDefinitionAllowed(definition, params2, cookies, headers);
                }
                catch (Exception e) {
                    this.LOGGER.error("Exception in filter implementation of `isDefinitionAllowed`; ignoring filter", e);
                }
                if (!shouldIncludeDefinition) continue;
            }
            LinkedHashMap<String, Property> clonedProperties = new LinkedHashMap<String, Property>();
            if (definition.getProperties() != null) {
                for (String propName : definition.getProperties().keySet()) {
                    boolean shouldInclude;
                    Property property = definition.getProperties().get(propName);
                    if (property == null || !(shouldInclude = filter.isPropertyAllowed(definition, property, propName, params2, cookies, headers))) continue;
                    clonedProperties.put(propName, property);
                }
            }
            if ((clonedModel = (Model)definition.clone()).getProperties() != null) {
                clonedModel.getProperties().clear();
            }
            if (definition.getVendorExtensions() != null && clonedModel.getVendorExtensions() != null) {
                clonedModel.getVendorExtensions().putAll(definition.getVendorExtensions());
            }
            clonedModel.setProperties(clonedProperties);
            clonedDefinitions.put(key2, clonedModel);
        }
        return clonedDefinitions;
    }

    public Operation filterOperation(SwaggerSpecFilter filter, Operation op, ApiDescription api, Map<String, List<String>> params2, Map<String, String> cookies, Map<String, List<String>> headers) {
        Operation clonedOperation = new Operation().summary(op.getSummary()).description(op.getDescription()).operationId(op.getOperationId()).schemes(op.getSchemes()).consumes(op.getConsumes()).produces(op.getProduces()).tags(op.getTags()).externalDocs(op.getExternalDocs()).vendorExtensions(op.getVendorExtensions()).deprecated(op.isDeprecated());
        ArrayList<Parameter> clonedParams = new ArrayList<Parameter>();
        if (op.getParameters() != null) {
            for (Parameter param : op.getParameters()) {
                if (!filter.isParamAllowed(param, op, api, params2, cookies, headers)) continue;
                clonedParams.add(param);
            }
        }
        clonedOperation.setParameters(clonedParams);
        clonedOperation.setSecurity(op.getSecurity());
        clonedOperation.setResponses(op.getResponses());
        return clonedOperation;
    }

    private String getPropertyRef(Property property) {
        if (property instanceof ArrayProperty && ((ArrayProperty)property).getItems() != null) {
            return this.getPropertyRef(((ArrayProperty)property).getItems());
        }
        if (property instanceof MapProperty && ((MapProperty)property).getAdditionalProperties() != null) {
            return this.getPropertyRef(((MapProperty)property).getAdditionalProperties());
        }
        if (property instanceof RefProperty) {
            return ((RefProperty)property).getSimpleRef();
        }
        return null;
    }

    private Set<String> getModelRef(Model model) {
        if (model instanceof ArrayModel && ((ArrayModel)model).getItems() != null) {
            String propertyRef = this.getPropertyRef(((ArrayModel)model).getItems());
            if (propertyRef != null) {
                return new HashSet<String>(Arrays.asList(propertyRef));
            }
        } else {
            if (model instanceof ComposedModel && ((ComposedModel)model).getAllOf() != null) {
                LinkedHashSet<String> refs = new LinkedHashSet<String>();
                ComposedModel cModel = (ComposedModel)model;
                for (Model ref : cModel.getAllOf()) {
                    if (!(ref instanceof RefModel)) continue;
                    refs.add(((RefModel)ref).getSimpleRef());
                }
                return refs;
            }
            if (model instanceof RefModel) {
                return new HashSet<String>(Arrays.asList(((RefModel)model).getSimpleRef()));
            }
        }
        return null;
    }
}

