/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jackson;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.annotations.ApiModel;
import io.swagger.util.PrimitiveType;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class TypeNameResolver {
    public static final TypeNameResolver std = new TypeNameResolver();

    protected TypeNameResolver() {
    }

    public String nameForType(JavaType type2, Options ... options2) {
        return this.nameForType(type2, options2.length == 0 ? Collections.emptySet() : EnumSet.copyOf(Arrays.asList(options2)));
    }

    public String nameForType(JavaType type2, Set<Options> options2) {
        if (type2.hasGenericTypes()) {
            return this.nameForGenericType(type2, options2);
        }
        String name2 = this.findStdName(type2);
        return name2 == null ? this.nameForClass(type2, options2) : name2;
    }

    protected String nameForClass(JavaType type2, Set<Options> options2) {
        return this.nameForClass(type2.getRawClass(), options2);
    }

    protected String nameForClass(Class<?> cls, Set<Options> options2) {
        if (options2.contains((Object)Options.SKIP_API_MODEL)) {
            return cls.getSimpleName();
        }
        ApiModel model = cls.getAnnotation(ApiModel.class);
        String modelName = model == null ? null : StringUtils.trimToNull(model.value());
        return modelName == null ? cls.getSimpleName() : modelName;
    }

    protected String nameForGenericType(JavaType type2, Set<Options> options2) {
        StringBuilder generic = new StringBuilder(this.nameForClass(type2, options2));
        int count2 = type2.containedTypeCount();
        for (int i2 = 0; i2 < count2; ++i2) {
            JavaType arg2 = type2.containedType(i2);
            String argName = PrimitiveType.fromType(arg2) != null ? this.nameForClass(arg2, options2) : this.nameForType(arg2, options2);
            generic.append(WordUtils.capitalize(argName));
        }
        return generic.toString();
    }

    protected String findStdName(JavaType type2) {
        return PrimitiveType.getCommonName(type2);
    }

    public static enum Options {
        SKIP_API_MODEL;

    }
}

