/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonPropertyOrder(value={"get", "head", "post", "put", "delete", "options", "patch"})
public class Path {
    private Map<String, Object> vendorExtensions = new LinkedHashMap<String, Object>();
    private Operation get;
    private Operation put;
    private Operation post;
    private Operation head;
    private Operation delete;
    private Operation patch;
    private Operation options;
    private List<Parameter> parameters;

    public Path set(String method2, Operation op) {
        if ("get".equals(method2)) {
            return this.get(op);
        }
        if ("put".equals(method2)) {
            return this.put(op);
        }
        if ("head".equals(method2)) {
            return this.head(op);
        }
        if ("post".equals(method2)) {
            return this.post(op);
        }
        if ("delete".equals(method2)) {
            return this.delete(op);
        }
        if ("patch".equals(method2)) {
            return this.patch(op);
        }
        if ("options".equals(method2)) {
            return this.options(op);
        }
        return null;
    }

    public Path get(Operation get2) {
        this.get = get2;
        return this;
    }

    public Path head(Operation head) {
        this.head = head;
        return this;
    }

    public Path put(Operation put2) {
        this.put = put2;
        return this;
    }

    public Path post(Operation post) {
        this.post = post;
        return this;
    }

    public Path delete(Operation delete2) {
        this.delete = delete2;
        return this;
    }

    public Path patch(Operation patch) {
        this.patch = patch;
        return this;
    }

    public Path options(Operation options2) {
        this.options = options2;
        return this;
    }

    public Operation getGet() {
        return this.get;
    }

    public void setGet(Operation get2) {
        this.get = get2;
    }

    public Operation getHead() {
        return this.head;
    }

    public void setHead(Operation head) {
        this.head = head;
    }

    public Operation getPut() {
        return this.put;
    }

    public void setPut(Operation put2) {
        this.put = put2;
    }

    public Operation getPost() {
        return this.post;
    }

    public void setPost(Operation post) {
        this.post = post;
    }

    public Operation getDelete() {
        return this.delete;
    }

    public void setDelete(Operation delete2) {
        this.delete = delete2;
    }

    public Operation getPatch() {
        return this.patch;
    }

    public void setPatch(Operation patch) {
        this.patch = patch;
    }

    public Operation getOptions() {
        return this.options;
    }

    public void setOptions(Operation options2) {
        this.options = options2;
    }

    @JsonIgnore
    public List<Operation> getOperations() {
        ArrayList<Operation> allOperations = new ArrayList<Operation>();
        if (this.get != null) {
            allOperations.add(this.get);
        }
        if (this.put != null) {
            allOperations.add(this.put);
        }
        if (this.head != null) {
            allOperations.add(this.head);
        }
        if (this.post != null) {
            allOperations.add(this.post);
        }
        if (this.delete != null) {
            allOperations.add(this.delete);
        }
        if (this.patch != null) {
            allOperations.add(this.patch);
        }
        if (this.options != null) {
            allOperations.add(this.options);
        }
        return allOperations;
    }

    @JsonIgnore
    public Map<HttpMethod, Operation> getOperationMap() {
        LinkedHashMap<HttpMethod, Operation> result2 = new LinkedHashMap<HttpMethod, Operation>();
        if (this.get != null) {
            result2.put(HttpMethod.GET, this.get);
        }
        if (this.put != null) {
            result2.put(HttpMethod.PUT, this.put);
        }
        if (this.post != null) {
            result2.put(HttpMethod.POST, this.post);
        }
        if (this.delete != null) {
            result2.put(HttpMethod.DELETE, this.delete);
        }
        if (this.patch != null) {
            result2.put(HttpMethod.PATCH, this.patch);
        }
        if (this.head != null) {
            result2.put(HttpMethod.HEAD, this.head);
        }
        if (this.options != null) {
            result2.put(HttpMethod.OPTIONS, this.options);
        }
        return result2;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters2) {
        this.parameters = parameters2;
    }

    public void addParameter(Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        this.parameters.add(parameter);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.get == null && this.put == null && this.head == null && this.post == null && this.delete == null && this.patch == null && this.options == null;
    }

    @JsonAnyGetter
    public Map<String, Object> getVendorExtensions() {
        return this.vendorExtensions;
    }

    @JsonAnySetter
    public void setVendorExtension(String name2, Object value2) {
        if (name2.startsWith("x-")) {
            this.vendorExtensions.put(name2, value2);
        }
    }

    public void setVendorExtensions(Map<String, Object> vendorExtensions) {
        this.vendorExtensions = vendorExtensions;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.delete == null ? 0 : this.delete.hashCode());
        result2 = 31 * result2 + (this.get == null ? 0 : this.get.hashCode());
        result2 = 31 * result2 + (this.head == null ? 0 : this.head.hashCode());
        result2 = 31 * result2 + (this.options == null ? 0 : this.options.hashCode());
        result2 = 31 * result2 + (this.parameters == null ? 0 : this.parameters.hashCode());
        result2 = 31 * result2 + (this.patch == null ? 0 : this.patch.hashCode());
        result2 = 31 * result2 + (this.post == null ? 0 : this.post.hashCode());
        result2 = 31 * result2 + (this.put == null ? 0 : this.put.hashCode());
        result2 = 31 * result2 + (this.vendorExtensions == null ? 0 : this.vendorExtensions.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        if (this.delete == null ? other.delete != null : !this.delete.equals(other.delete)) {
            return false;
        }
        if (this.get == null ? other.get != null : !this.get.equals(other.get)) {
            return false;
        }
        if (this.head == null ? other.head != null : !this.head.equals(other.head)) {
            return false;
        }
        if (this.options == null ? other.options != null : !this.options.equals(other.options)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        if (this.patch == null ? other.patch != null : !this.patch.equals(other.patch)) {
            return false;
        }
        if (this.post == null ? other.post != null : !this.post.equals(other.post)) {
            return false;
        }
        if (this.put == null ? other.put != null : !this.put.equals(other.put)) {
            return false;
        }
        return !(this.vendorExtensions == null ? other.vendorExtensions != null : !this.vendorExtensions.equals(other.vendorExtensions));
    }
}

