/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.properties;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.models.properties.AbstractProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.refs.GenericRef;
import io.swagger.models.refs.RefFormat;
import io.swagger.models.refs.RefType;

public class RefProperty
extends AbstractProperty
implements Property {
    public static final String TYPE = "ref";
    private GenericRef genericRef;

    public RefProperty() {
        this.setType(TYPE);
    }

    public RefProperty(String ref) {
        this(ref, null);
    }

    public RefProperty(String ref, RefFormat refFormat) {
        this();
        this.genericRef = new GenericRef(RefType.DEFINITION, ref, refFormat);
    }

    public static boolean isType(String type2, String format) {
        return TYPE.equals(type2);
    }

    public RefProperty asDefault(String ref) {
        this.set$ref(RefType.DEFINITION.getInternalPrefix() + ref);
        return this;
    }

    @Override
    public RefProperty description(String description) {
        this.setDescription(description);
        return this;
    }

    @Override
    @JsonIgnore
    public String getType() {
        return this.type;
    }

    @Override
    @JsonIgnore
    public void setType(String type2) {
        this.type = type2;
    }

    public String get$ref() {
        return this.genericRef.getRef();
    }

    public void set$ref(String ref) {
        this.genericRef = new GenericRef(RefType.DEFINITION, ref);
    }

    @JsonIgnore
    public RefFormat getRefFormat() {
        if (this.genericRef != null) {
            return this.genericRef.getFormat();
        }
        return null;
    }

    @JsonIgnore
    public String getSimpleRef() {
        if (this.genericRef != null) {
            return this.genericRef.getSimpleRef();
        }
        return null;
    }

    public String getOriginalRef() {
        if (this.genericRef != null) {
            return this.genericRef.getOriginalRef();
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.genericRef == null ? 0 : this.genericRef.hashCode());
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RefProperty)) {
            return false;
        }
        RefProperty other = (RefProperty)obj;
        return !(this.genericRef == null ? other.genericRef != null : !this.genericRef.equals(other.genericRef));
    }
}

