/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import io.swagger.util.Json;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class BaseReaderUtils {
    private BaseReaderUtils() {
    }

    public static Map<String, Object> parseExtensions(Extension[] extensions) {
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        for (Extension extension : extensions) {
            String name2 = extension.name();
            String key2 = name2.length() > 0 ? StringUtils.prependIfMissing(name2, (CharSequence)"x-", new CharSequence[0]) : name2;
            for (ExtensionProperty property : extension.properties()) {
                String propertyName = property.name();
                String propertyValue = property.value();
                JsonNode processedValue = null;
                boolean propertyAsJson = property.parseValue();
                if (!StringUtils.isNotBlank(propertyName) || !StringUtils.isNotBlank(propertyValue)) continue;
                if (key2.isEmpty()) {
                    if (propertyAsJson) {
                        try {
                            processedValue = Json.mapper().readTree(propertyValue);
                            map2.put(StringUtils.prependIfMissing(propertyName, (CharSequence)"x-", new CharSequence[0]), processedValue);
                        }
                        catch (Exception e) {
                            map2.put(StringUtils.prependIfMissing(propertyName, (CharSequence)"x-", new CharSequence[0]), propertyValue);
                        }
                        continue;
                    }
                    map2.put(StringUtils.prependIfMissing(propertyName, (CharSequence)"x-", new CharSequence[0]), propertyValue);
                    continue;
                }
                Object value2 = map2.get(key2);
                if (value2 == null || !(value2 instanceof Map)) {
                    value2 = new HashMap();
                    map2.put(key2, value2);
                }
                Map mapValue = (Map)value2;
                if (propertyAsJson) {
                    try {
                        processedValue = Json.mapper().readTree(propertyValue);
                        mapValue.put(propertyName, processedValue);
                    }
                    catch (Exception e) {
                        mapValue.put(propertyName, propertyValue);
                    }
                    continue;
                }
                mapValue.put(propertyName, propertyValue);
            }
        }
        return map2;
    }
}

