/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.util.Json;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ModelDeserializer
extends JsonDeserializer<Model> {
    @Override
    public Model deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode sub3 = node.get("$ref");
        JsonNode allOf = node.get("allOf");
        if (sub3 != null) {
            return Json.mapper().convertValue((Object)sub3, RefModel.class);
        }
        if (allOf != null) {
            ComposedModel model = null;
            model = Json.mapper().convertValue((Object)node, ComposedModel.class);
            List<Model> allComponents = model.getAllOf();
            if (allComponents.size() >= 1) {
                model.setParent(allComponents.get(0));
                if (allComponents.size() >= 2) {
                    model.setChild(allComponents.get(allComponents.size() - 1));
                    ArrayList<RefModel> interfaces2 = new ArrayList<RefModel>();
                    int size2 = allComponents.size();
                    for (Model m3 : allComponents.subList(1, size2 - 1)) {
                        if (!(m3 instanceof RefModel)) continue;
                        RefModel ref = (RefModel)m3;
                        interfaces2.add(ref);
                    }
                    model.setInterfaces(interfaces2);
                } else {
                    model.setChild(new ModelImpl());
                }
            }
            return model;
        }
        sub3 = node.get("type");
        Model model = null;
        model = sub3 != null && "array".equals(((TextNode)sub3).textValue()) ? (Model)Json.mapper().convertValue((Object)node, ArrayModel.class) : (Model)Json.mapper().convertValue((Object)node, ModelImpl.class);
        return model;
    }
}

