/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import io.swagger.converter.ModelConverters;
import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.AllowableValues;
import io.swagger.util.AllowableValuesUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterProcessor {
    static Logger LOGGER = LoggerFactory.getLogger(ParameterProcessor.class);

    public static Parameter applyAnnotations(Swagger swagger, Parameter parameter, Type type2, List<Annotation> annotations2) {
        AnnotationsHelper helper = new AnnotationsHelper(annotations2, type2);
        if (helper.isContext()) {
            return null;
        }
        ParamWrapper<?> param = helper.getApiParam();
        if (param.isHidden()) {
            return null;
        }
        String defaultValue = helper.getDefaultValue();
        if (parameter instanceof AbstractSerializableParameter) {
            AbstractSerializableParameter p2 = (AbstractSerializableParameter)parameter;
            if (param.isRequired()) {
                p2.setRequired(true);
            }
            if (param.getReadOnly()) {
                p2.readOnly(param.getReadOnly());
            }
            if (param.getAllowEmptyValue()) {
                p2.allowEmptyValue(param.getAllowEmptyValue());
            }
            if (StringUtils.isNotEmpty(param.getName())) {
                p2.setName(param.getName());
            }
            if (StringUtils.isNotEmpty(param.getDescription())) {
                p2.setDescription(param.getDescription());
            }
            if (StringUtils.isNotEmpty(param.getExample())) {
                p2.setExample(param.getExample());
            }
            if (StringUtils.isNotEmpty(param.getAccess())) {
                p2.setAccess(param.getAccess());
            }
            if (StringUtils.isNoneEmpty(param.getCollectionFormat())) {
                p2.setCollectionFormat(param.getCollectionFormat());
            }
            if (StringUtils.isNotEmpty(param.getDataType())) {
                if ("java.io.File".equalsIgnoreCase(param.getDataType())) {
                    p2.setProperty(new FileProperty());
                } else if ("long".equalsIgnoreCase(param.getDataType())) {
                    p2.setProperty(new LongProperty());
                } else {
                    p2.setType(param.getDataType());
                }
            }
            if (helper.getMin() != null) {
                p2.setMinimum(helper.getMin());
                if (helper.isMinExclusive()) {
                    p2.setExclusiveMinimum(true);
                }
            }
            if (helper.getMax() != null) {
                p2.setMaximum(helper.getMax());
                if (helper.isMaxExclusive()) {
                    p2.setExclusiveMaximum(true);
                }
            }
            if (helper.getMinItems() != null) {
                p2.setMinItems(helper.getMinItems());
            }
            if (helper.getMaxItems() != null) {
                p2.setMaxItems(helper.getMaxItems());
            }
            if (helper.getMinLength() != null) {
                p2.setMinLength(helper.getMinLength());
            }
            if (helper.getMaxLength() != null) {
                p2.setMaxLength(helper.getMaxLength());
            }
            if (helper.getPattern() != null) {
                p2.setPattern(helper.getPattern());
            }
            if (helper.isRequired() != null) {
                p2.setRequired(true);
            }
            if (helper.getType() != null) {
                p2.setType(helper.getType());
            }
            if (helper.getFormat() != null) {
                p2.setFormat(helper.getFormat());
            }
            AllowableValues allowableValues = AllowableValuesUtils.create(param.getAllowableValues());
            if (p2.getItems() != null || param.isAllowMultiple()) {
                EnumMap<PropertyBuilder.PropertyId, Object> args2;
                if (p2.getItems() == null) {
                    args2 = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class);
                    args2.put(PropertyBuilder.PropertyId.DEFAULT, p2.getDefaultValue());
                    p2.setDefaultValue(null);
                    args2.put(PropertyBuilder.PropertyId.ENUM, p2.getEnum());
                    p2.setEnum(null);
                    args2.put(PropertyBuilder.PropertyId.MINIMUM, p2.getMinimum());
                    p2.setMinimum(null);
                    args2.put(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM, (Object)p2.isExclusiveMinimum());
                    p2.setExclusiveMinimum(null);
                    args2.put(PropertyBuilder.PropertyId.MAXIMUM, (Object)p2.getMaximum());
                    p2.setMaximum(null);
                    args2.put(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM, (Object)p2.isExclusiveMaximum());
                    args2.put(PropertyBuilder.PropertyId.MIN_LENGTH, (Object)p2.getMinLength());
                    p2.setMinLength(null);
                    args2.put(PropertyBuilder.PropertyId.MAX_LENGTH, (Object)p2.getMaxLength());
                    p2.setMaxLength(null);
                    args2.put(PropertyBuilder.PropertyId.PATTERN, (Object)p2.getPattern());
                    p2.setPattern(null);
                    args2.put(PropertyBuilder.PropertyId.EXAMPLE, p2.getExample());
                    p2.setExclusiveMaximum(null);
                    Property items = PropertyBuilder.build(p2.getType(), p2.getFormat(), args2);
                    ((AbstractSerializableParameter)((AbstractSerializableParameter)p2.type("array")).format(null)).items(items);
                }
                args2 = new EnumMap(PropertyBuilder.PropertyId.class);
                if (StringUtils.isNotEmpty(defaultValue)) {
                    args2.put(PropertyBuilder.PropertyId.DEFAULT, defaultValue);
                }
                if (helper.getMin() != null) {
                    args2.put(PropertyBuilder.PropertyId.MINIMUM, helper.getMin());
                    if (helper.isMinExclusive()) {
                        args2.put(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM, Boolean.valueOf(true));
                    }
                }
                if (helper.getMax() != null) {
                    args2.put(PropertyBuilder.PropertyId.MAXIMUM, helper.getMax());
                    if (helper.isMaxExclusive()) {
                        args2.put(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM, Boolean.valueOf(true));
                    }
                }
                if (helper.getMinLength() != null) {
                    args2.put(PropertyBuilder.PropertyId.MIN_LENGTH, helper.getMinLength());
                }
                if (helper.getMaxLength() != null) {
                    args2.put(PropertyBuilder.PropertyId.MAX_LENGTH, helper.getMaxLength());
                }
                if (helper.getPattern() != null) {
                    args2.put(PropertyBuilder.PropertyId.PATTERN, helper.getPattern());
                }
                if (allowableValues != null) {
                    args2.putAll(allowableValues.asPropertyArguments());
                }
                PropertyBuilder.merge(p2.getItems(), args2);
            } else {
                if (StringUtils.isNotEmpty(defaultValue)) {
                    p2.setDefaultValue(defaultValue);
                }
                if (allowableValues != null) {
                    ParameterProcessor.processAllowedValues(allowableValues, p2);
                }
            }
        } else {
            Property property;
            BodyParameter bp = new BodyParameter();
            if (helper.getApiParam() != null) {
                String value2;
                String mediaType;
                Example example;
                ParamWrapper<ApiParam> apiParam;
                ParamWrapper<?> pw = helper.getApiParam();
                if (pw instanceof ApiParamWrapper) {
                    apiParam = (ApiParamWrapper)pw;
                    example = ((ApiParamWrapper)apiParam).getExamples();
                    if (example != null && example.value() != null) {
                        for (ExampleProperty ex : example.value()) {
                            mediaType = ex.mediaType();
                            value2 = ex.value();
                            if (mediaType.isEmpty() || value2.isEmpty()) continue;
                            bp.example(mediaType.trim(), value2.trim());
                        }
                    }
                } else if (pw instanceof ApiImplicitParamWrapper && (example = ((ApiImplicitParamWrapper)(apiParam = (ApiImplicitParamWrapper)pw)).getExamples()) != null && example.value() != null) {
                    for (ExampleProperty ex : example.value()) {
                        mediaType = ex.mediaType();
                        value2 = ex.value();
                        if (mediaType.isEmpty() || value2.isEmpty()) continue;
                        bp.example(mediaType.trim(), value2.trim());
                    }
                }
            }
            bp.setRequired(param.isRequired());
            bp.setName(StringUtils.isNotEmpty(param.getName()) ? param.getName() : "body");
            if (StringUtils.isNotEmpty(param.getDescription())) {
                bp.setDescription(param.getDescription());
            }
            if (StringUtils.isNotEmpty(param.getAccess())) {
                bp.setAccess(param.getAccess());
            }
            if ((property = ModelConverters.getInstance().readAsProperty(type2)) != null) {
                EnumMap<PropertyBuilder.PropertyId, Object> args3 = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class);
                if (StringUtils.isNotEmpty(defaultValue)) {
                    args3.put(PropertyBuilder.PropertyId.DEFAULT, defaultValue);
                }
                bp.setSchema(PropertyBuilder.toModel(PropertyBuilder.merge(property, args3)));
                for (Map.Entry<String, Model> entry : ModelConverters.getInstance().readAll(type2).entrySet()) {
                    swagger.addDefinition(entry.getKey(), entry.getValue());
                }
            }
            parameter = bp;
        }
        return parameter;
    }

    private static void processAllowedValues(AllowableValues allowableValues, AbstractSerializableParameter<?> p2) {
        if (allowableValues == null) {
            return;
        }
        Map<PropertyBuilder.PropertyId, Object> args2 = allowableValues.asPropertyArguments();
        if (args2.containsKey((Object)PropertyBuilder.PropertyId.ENUM)) {
            p2.setEnum((List)args2.get((Object)PropertyBuilder.PropertyId.ENUM));
        } else {
            if (args2.containsKey((Object)PropertyBuilder.PropertyId.MINIMUM)) {
                p2.setMinimum((BigDecimal)args2.get((Object)PropertyBuilder.PropertyId.MINIMUM));
            }
            if (args2.containsKey((Object)PropertyBuilder.PropertyId.MAXIMUM)) {
                p2.setMaximum((BigDecimal)args2.get((Object)PropertyBuilder.PropertyId.MAXIMUM));
            }
            if (args2.containsKey((Object)PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM)) {
                p2.setExclusiveMinimum((Boolean)args2.get((Object)PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM) != false ? Boolean.valueOf(true) : null);
            }
            if (args2.containsKey((Object)PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM)) {
                p2.setExclusiveMaximum((Boolean)args2.get((Object)PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM) != false ? Boolean.valueOf(true) : null);
            }
        }
    }

    private static void processJsr303Annotations(AnnotationsHelper helper, AbstractSerializableParameter<?> p2) {
        if (helper == null) {
            return;
        }
        if (helper.getMin() != null) {
            p2.setMinimum(helper.getMin());
        }
        if (helper.getMax() != null) {
            p2.setMaximum(helper.getMax());
        }
    }

    private static final class ApiImplicitParamWrapper
    implements ParamWrapper<ApiImplicitParam> {
        private final ApiImplicitParam apiParam;

        private ApiImplicitParamWrapper(ApiImplicitParam apiParam) {
            this.apiParam = apiParam;
        }

        @Override
        public String getName() {
            return this.apiParam.name();
        }

        @Override
        public String getDescription() {
            return this.apiParam.value();
        }

        @Override
        public String getDefaultValue() {
            return this.apiParam.defaultValue();
        }

        @Override
        public String getAllowableValues() {
            return this.apiParam.allowableValues();
        }

        @Override
        public boolean isRequired() {
            return this.apiParam.required();
        }

        @Override
        public String getAccess() {
            return this.apiParam.access();
        }

        @Override
        public boolean isAllowMultiple() {
            return this.apiParam.allowMultiple();
        }

        @Override
        public String getDataType() {
            return this.apiParam.dataType();
        }

        @Override
        public String getParamType() {
            return this.apiParam.paramType();
        }

        @Override
        public ApiImplicitParam getAnnotation() {
            return this.apiParam;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public String getExample() {
            return this.apiParam.example();
        }

        public Example getExamples() {
            return this.apiParam.examples();
        }

        @Override
        public String getType() {
            return this.apiParam.type();
        }

        @Override
        public String getFormat() {
            return this.apiParam.format();
        }

        @Override
        public boolean getReadOnly() {
            return this.apiParam.readOnly();
        }

        @Override
        public boolean getAllowEmptyValue() {
            return this.apiParam.allowEmptyValue();
        }

        @Override
        public String getCollectionFormat() {
            return this.apiParam.collectionFormat();
        }
    }

    private static final class ApiParamWrapper
    implements ParamWrapper<ApiParam> {
        private final ApiParam apiParam;

        private ApiParamWrapper(ApiParam apiParam) {
            this.apiParam = apiParam;
        }

        @Override
        public String getName() {
            return this.apiParam.name();
        }

        @Override
        public String getDescription() {
            return this.apiParam.value();
        }

        @Override
        public String getDefaultValue() {
            return this.apiParam.defaultValue();
        }

        @Override
        public String getAllowableValues() {
            return this.apiParam.allowableValues();
        }

        @Override
        public boolean isRequired() {
            return this.apiParam.required();
        }

        @Override
        public String getAccess() {
            return this.apiParam.access();
        }

        @Override
        public boolean isAllowMultiple() {
            return this.apiParam.allowMultiple();
        }

        @Override
        public String getDataType() {
            return null;
        }

        @Override
        public String getParamType() {
            return null;
        }

        @Override
        public ApiParam getAnnotation() {
            return this.apiParam;
        }

        @Override
        public boolean isHidden() {
            return this.apiParam.hidden();
        }

        @Override
        public String getExample() {
            return this.apiParam.example();
        }

        public Example getExamples() {
            return this.apiParam.examples();
        }

        @Override
        public String getType() {
            return this.apiParam.type();
        }

        @Override
        public String getFormat() {
            return this.apiParam.format();
        }

        @Override
        public boolean getReadOnly() {
            return this.apiParam.readOnly();
        }

        @Override
        public boolean getAllowEmptyValue() {
            return this.apiParam.allowEmptyValue();
        }

        @Override
        public String getCollectionFormat() {
            return this.apiParam.collectionFormat();
        }
    }

    private static class AnnotationsHelper {
        private static final ApiParam DEFAULT_API_PARAM = AnnotationsHelper.getDefaultApiParam(null);
        private boolean context;
        private ParamWrapper<?> apiParam = new ApiParamWrapper(DEFAULT_API_PARAM);
        private String type;
        private String format;
        private String defaultValue;
        private Integer minItems;
        private Integer maxItems;
        private Boolean required;
        private BigDecimal min;
        private boolean minExclusive = false;
        private BigDecimal max;
        private boolean maxExclusive = false;
        private Integer minLength;
        private Integer maxLength;
        private String pattern;
        private Boolean allowEmptyValue;
        private String collectionFormat;

        public AnnotationsHelper(List<Annotation> annotations2, Type _type) {
            String rsDefault = null;
            Size size2 = null;
            for (Annotation item : annotations2) {
                if ("javax.ws.rs.core.Context".equals(item.annotationType().getName())) {
                    this.context = true;
                    continue;
                }
                if (item instanceof ApiParam) {
                    this.apiParam = new ApiParamWrapper((ApiParam)item);
                    continue;
                }
                if (item instanceof ApiImplicitParam) {
                    this.apiParam = new ApiImplicitParamWrapper((ApiImplicitParam)item);
                    continue;
                }
                if ("javax.ws.rs.DefaultValue".equals(item.annotationType().getName())) {
                    try {
                        rsDefault = (String)item.annotationType().getMethod("value", new Class[0]).invoke((Object)item, new Object[0]);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Invocation of value method failed", ex);
                    }
                    continue;
                }
                if (item instanceof Size) {
                    size2 = (Size)item;
                    continue;
                }
                if (item instanceof NotNull) {
                    this.required = true;
                    continue;
                }
                if (item instanceof Min) {
                    this.min = new BigDecimal(((Min)item).value());
                    continue;
                }
                if (item instanceof Max) {
                    this.max = new BigDecimal(((Max)item).value());
                    continue;
                }
                if (item instanceof DecimalMin) {
                    DecimalMin decimalMinAnnotation = (DecimalMin)item;
                    this.min = new BigDecimal(decimalMinAnnotation.value());
                    this.minExclusive = !decimalMinAnnotation.inclusive();
                    continue;
                }
                if (item instanceof DecimalMax) {
                    DecimalMax decimalMaxAnnotation = (DecimalMax)item;
                    this.max = new BigDecimal(decimalMaxAnnotation.value());
                    this.maxExclusive = !decimalMaxAnnotation.inclusive();
                    continue;
                }
                if (!(item instanceof Pattern)) continue;
                this.pattern = ((Pattern)item).regexp();
            }
            if (size2 != null) {
                boolean defaultToArray;
                Property property = ModelConverters.getInstance().readAsProperty(_type);
                boolean bl = defaultToArray = this.apiParam != null && this.apiParam.isAllowMultiple();
                if (!defaultToArray && property instanceof AbstractNumericProperty) {
                    this.min = new BigDecimal(size2.min());
                    this.max = new BigDecimal(size2.max());
                } else if (!defaultToArray && property instanceof StringProperty) {
                    this.minLength = size2.min();
                    this.maxLength = size2.max();
                } else {
                    this.minItems = size2.min();
                    this.maxItems = size2.max();
                }
            }
            this.defaultValue = StringUtils.isNotEmpty(this.apiParam.getDefaultValue()) ? this.apiParam.getDefaultValue() : rsDefault;
            this.type = StringUtils.isNotEmpty(this.apiParam.getType()) ? this.apiParam.getType() : null;
            this.format = StringUtils.isNotEmpty(this.apiParam.getFormat()) ? this.apiParam.getFormat() : null;
            this.allowEmptyValue = this.apiParam.isAllowMultiple() ? Boolean.valueOf(true) : null;
            this.collectionFormat = StringUtils.isNoneEmpty(this.apiParam.getCollectionFormat()) ? this.apiParam.getCollectionFormat() : null;
        }

        private boolean isAssignableToNumber(Class<?> clazz) {
            return Number.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz);
        }

        private static ApiParam getDefaultApiParam(@ApiParam String annotationHolder) {
            for (Method method2 : AnnotationsHelper.class.getDeclaredMethods()) {
                if (!"getDefaultApiParam".equals(method2.getName())) continue;
                return (ApiParam)method2.getParameterAnnotations()[0][0];
            }
            throw new IllegalStateException("Failed to locate default @ApiParam");
        }

        public boolean isContext() {
            return this.context;
        }

        public ParamWrapper<?> getApiParam() {
            return this.apiParam;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public Integer getMinItems() {
            return this.minItems;
        }

        public Integer getMaxItems() {
            return this.maxItems;
        }

        public Boolean isRequired() {
            return this.required;
        }

        public BigDecimal getMax() {
            return this.max;
        }

        public boolean isMaxExclusive() {
            return this.maxExclusive;
        }

        public BigDecimal getMin() {
            return this.min;
        }

        public String getType() {
            return this.type;
        }

        public String getFormat() {
            return this.format;
        }

        public boolean isMinExclusive() {
            return this.minExclusive;
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public String getPattern() {
            return this.pattern;
        }

        public Boolean getAllowEmptyValue() {
            return this.allowEmptyValue;
        }

        public String getCollectionFormat() {
            return this.collectionFormat;
        }
    }

    public static interface ParamWrapper<T extends Annotation> {
        public String getName();

        public String getDescription();

        public String getDefaultValue();

        public String getAllowableValues();

        public boolean isRequired();

        public String getAccess();

        public boolean isAllowMultiple();

        public String getDataType();

        public String getParamType();

        public T getAnnotation();

        public boolean isHidden();

        public String getExample();

        public String getType();

        public String getFormat();

        public boolean getReadOnly();

        public boolean getAllowEmptyValue();

        public String getCollectionFormat();
    }
}

