/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.collect.Sets;
import io.swagger.util.PrimitiveType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionUtils.class);

    public static Type typeFromString(String type2) {
        PrimitiveType primitive = PrimitiveType.fromName(type2);
        if (primitive != null) {
            return primitive.getKeyClass();
        }
        if (StringUtils.isBlank(type2)) {
            return null;
        }
        try {
            return ReflectionUtils.loadClassByName(type2);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Failed to resolve '%s' into class", type2), e);
            return null;
        }
    }

    public static Class<?> loadClassByName(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
    }

    public static boolean isOverriddenMethod(Method methodToFind, Class<?> cls) {
        HashSet<Class<?>> superClasses = Sets.newHashSet(cls.getInterfaces());
        if (cls.getSuperclass() != null) {
            superClasses.add(cls.getSuperclass());
        }
        for (Class clazz : superClasses) {
            if (clazz == null || clazz.equals(Object.class)) continue;
            for (Method method2 : clazz.getMethods()) {
                if (!method2.getName().equals(methodToFind.getName()) || !method2.getReturnType().isAssignableFrom(methodToFind.getReturnType()) || !Arrays.equals(method2.getParameterTypes(), methodToFind.getParameterTypes()) || Arrays.equals(method2.getGenericParameterTypes(), methodToFind.getGenericParameterTypes())) continue;
                return true;
            }
            if (!ReflectionUtils.isOverriddenMethod(methodToFind, clazz)) continue;
            return true;
        }
        return false;
    }

    public static Method getOverriddenMethod(Method method2) {
        Class<?> declaringClass = method2.getDeclaringClass();
        Class<?> superClass = declaringClass.getSuperclass();
        Method result2 = null;
        if (superClass != null && !superClass.equals(Object.class)) {
            result2 = ReflectionUtils.findMethod(method2, superClass);
        }
        if (result2 == null) {
            for (Class<?> anInterface : declaringClass.getInterfaces()) {
                result2 = ReflectionUtils.findMethod(method2, anInterface);
                if (result2 == null) continue;
                return result2;
            }
        }
        return result2;
    }

    public static Method findMethod(Method methodToFind, Class<?> cls) {
        if (cls == null) {
            return null;
        }
        String methodToSearch = methodToFind.getName();
        Class<?>[] soughtForParameterType = methodToFind.getParameterTypes();
        Type[] soughtForGenericParameterType = methodToFind.getGenericParameterTypes();
        for (Method method2 : cls.getMethods()) {
            if (!method2.getName().equals(methodToSearch) || !method2.getReturnType().isAssignableFrom(methodToFind.getReturnType())) continue;
            Class<?>[] srcParameterTypes = method2.getParameterTypes();
            Type[] srcGenericParameterTypes = method2.getGenericParameterTypes();
            if (soughtForParameterType.length != srcParameterTypes.length || soughtForGenericParameterType.length != srcGenericParameterTypes.length || !ReflectionUtils.hasIdenticalParameters(srcParameterTypes, soughtForParameterType, srcGenericParameterTypes, soughtForGenericParameterType)) continue;
            return method2;
        }
        return null;
    }

    private static boolean hasIdenticalParameters(Class<?>[] srcParameterTypes, Class<?>[] soughtForParameterType, Type[] srcGenericParameterTypes, Type[] soughtForGenericParameterType) {
        for (int j = 0; j < soughtForParameterType.length; ++j) {
            Class<?> parameterType = soughtForParameterType[j];
            if (srcParameterTypes[j].equals(parameterType) || !srcGenericParameterTypes[j].equals(soughtForGenericParameterType[j]) && srcParameterTypes[j].isAssignableFrom(parameterType)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInject(List<Annotation> annotations2) {
        for (Annotation annotation2 : annotations2) {
            if (!"javax.inject.Inject".equals(annotation2.annotationType().getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isConstructorCompatible(Constructor<?> constructor2) {
        if (!Modifier.isPublic(constructor2.getModifiers())) {
            int access = 7;
            return constructor2.getParameterTypes().length == 0 && (constructor2.getDeclaringClass().getModifiers() & 7) == constructor2.getModifiers();
        }
        return true;
    }

    public static List<Field> getDeclaredFields(Class<?> cls) {
        if (cls == null || Object.class.equals(cls)) {
            return Collections.emptyList();
        }
        ArrayList<Field> fields2 = new ArrayList<Field>();
        HashSet<String> fieldNames = new HashSet<String>();
        for (Field field2 : cls.getDeclaredFields()) {
            fields2.add(field2);
            fieldNames.add(field2.getName());
        }
        for (Field field3 : ReflectionUtils.getDeclaredFields(cls.getSuperclass())) {
            if (fieldNames.contains(field3.getName())) continue;
            fields2.add(field3);
        }
        return fields2;
    }

    public static <A extends Annotation> A getAnnotation(Method method2, Class<A> annotationClass) {
        A annotation2 = method2.getAnnotation(annotationClass);
        if (annotation2 == null) {
            for (Annotation metaAnnotation : method2.getAnnotations()) {
                annotation2 = metaAnnotation.annotationType().getAnnotation(annotationClass);
                if (annotation2 == null) continue;
                return annotation2;
            }
            Method superclassMethod = ReflectionUtils.getOverriddenMethod(method2);
            if (superclassMethod != null) {
                annotation2 = ReflectionUtils.getAnnotation(superclassMethod, annotationClass);
            }
        }
        return annotation2;
    }

    public static <A extends Annotation> A getAnnotation(Class<?> cls, Class<A> annotationClass) {
        A annotation2 = cls.getAnnotation(annotationClass);
        if (annotation2 == null) {
            for (Annotation metaAnnotation : cls.getAnnotations()) {
                annotation2 = metaAnnotation.annotationType().getAnnotation(annotationClass);
                if (annotation2 == null) continue;
                return annotation2;
            }
            Class<?> superClass = cls.getSuperclass();
            if (superClass != null && !superClass.equals(Object.class)) {
                annotation2 = ReflectionUtils.getAnnotation(superClass, annotationClass);
            }
        }
        if (annotation2 == null) {
            for (Class<?> anInterface : cls.getInterfaces()) {
                for (Annotation metaAnnotation : anInterface.getAnnotations()) {
                    annotation2 = metaAnnotation.annotationType().getAnnotation(annotationClass);
                    if (annotation2 == null) continue;
                    return annotation2;
                }
                annotation2 = ReflectionUtils.getAnnotation(anInterface, annotationClass);
                if (annotation2 == null) continue;
                return annotation2;
            }
        }
        return annotation2;
    }

    public static Annotation[][] getParameterAnnotations(Method method2) {
        Annotation[][] methodAnnotations = method2.getParameterAnnotations();
        Method overriddenmethod = ReflectionUtils.getOverriddenMethod(method2);
        if (overriddenmethod != null) {
            Annotation[][] overriddenAnnotations = overriddenmethod.getParameterAnnotations();
            for (int i2 = 0; i2 < methodAnnotations.length; ++i2) {
                int j;
                ArrayList<Class<? extends Annotation>> types = new ArrayList<Class<? extends Annotation>>();
                for (j = 0; j < methodAnnotations[i2].length; ++j) {
                    types.add(methodAnnotations[i2][j].annotationType());
                }
                for (j = 0; j < overriddenAnnotations[i2].length; ++j) {
                    if (types.contains(overriddenAnnotations[i2][j].annotationType())) continue;
                    methodAnnotations[i2] = ArrayUtils.add(methodAnnotations[i2], overriddenAnnotations[i2][j]);
                }
            }
        }
        return methodAnnotations;
    }

    public static boolean isVoid(Type type2) {
        Class<?> cls = TypeFactory.defaultInstance().constructType(type2).getRawClass();
        return Void.class.isAssignableFrom(cls) || Void.TYPE.isAssignableFrom(cls);
    }
}

