/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import com.sun.mail.util.BEncoderStream;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.PropUtil;
import com.sun.mail.util.QDecoderStream;
import com.sun.mail.util.QEncoderStream;
import com.sun.mail.util.QPDecoderStream;
import com.sun.mail.util.QPEncoderStream;
import com.sun.mail.util.UUDecoderStream;
import com.sun.mail.util.UUEncoderStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.EncodingAware;
import javax.mail.MessagingException;
import javax.mail.internet.AsciiOutputStream;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;

public class MimeUtility {
    public static final int ALL = -1;
    private static final Map<String, Boolean> nonAsciiCharsetMap;
    private static final boolean decodeStrict;
    private static final boolean encodeEolStrict;
    private static final boolean ignoreUnknownEncoding;
    private static final boolean allowUtf8;
    private static final boolean foldEncodedWords;
    private static final boolean foldText;
    private static String defaultJavaCharset;
    private static String defaultMIMECharset;
    private static Map<String, String> mime2java;
    private static Map<String, String> java2mime;
    static final int ALL_ASCII = 1;
    static final int MOSTLY_ASCII = 2;
    static final int MOSTLY_NONASCII = 3;

    private MimeUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getEncoding(DataSource ds) {
        ContentType cType = null;
        InputStream is = null;
        String encoding2 = null;
        if (ds instanceof EncodingAware && (encoding2 = ((EncodingAware)((Object)ds)).getEncoding()) != null) {
            return encoding2;
        }
        try {
            cType = new ContentType(ds.getContentType());
            is = ds.getInputStream();
            boolean isText = cType.match("text/*");
            int i2 = MimeUtility.checkAscii(is, -1, !isText);
            switch (i2) {
                case 1: {
                    encoding2 = "7bit";
                    return encoding2;
                }
                case 2: {
                    if (isText && MimeUtility.nonAsciiCharset(cType)) {
                        encoding2 = "base64";
                        return encoding2;
                    } else {
                        encoding2 = "quoted-printable";
                        return encoding2;
                    }
                }
                default: {
                    encoding2 = "base64";
                    return encoding2;
                }
            }
        }
        catch (Exception ex) {
            String string2 = "base64";
            return string2;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean nonAsciiCharset(ContentType ct) {
        Boolean bool2;
        String charset = ct.getParameter("charset");
        if (charset == null) {
            return false;
        }
        charset = charset.toLowerCase(Locale.ENGLISH);
        Map<String, Boolean> map2 = nonAsciiCharsetMap;
        synchronized (map2) {
            bool2 = nonAsciiCharsetMap.get(charset);
        }
        if (bool2 == null) {
            try {
                byte[] b2 = "\r\n".getBytes(charset);
                bool2 = b2.length != 2 || b2[0] != 13 || b2[1] != 10;
            }
            catch (UnsupportedEncodingException uex) {
                bool2 = Boolean.FALSE;
            }
            catch (RuntimeException ex) {
                bool2 = Boolean.TRUE;
            }
            map2 = nonAsciiCharsetMap;
            synchronized (map2) {
                nonAsciiCharsetMap.put(charset, bool2);
            }
        }
        return bool2;
    }

    public static String getEncoding(DataHandler dh) {
        ContentType cType = null;
        String encoding2 = null;
        if (dh.getName() != null) {
            return MimeUtility.getEncoding(dh.getDataSource());
        }
        try {
            cType = new ContentType(dh.getContentType());
        }
        catch (Exception ex) {
            return "base64";
        }
        if (cType.match("text/*")) {
            AsciiOutputStream aos = new AsciiOutputStream(false, false);
            try {
                dh.writeTo(aos);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            switch (aos.getAscii()) {
                case 1: {
                    encoding2 = "7bit";
                    break;
                }
                case 2: {
                    encoding2 = "quoted-printable";
                    break;
                }
                default: {
                    encoding2 = "base64";
                    break;
                }
            }
        } else {
            AsciiOutputStream aos = new AsciiOutputStream(true, encodeEolStrict);
            try {
                dh.writeTo(aos);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            encoding2 = aos.getAscii() == 1 ? "7bit" : "base64";
        }
        return encoding2;
    }

    public static InputStream decode(InputStream is, String encoding2) throws MessagingException {
        if (encoding2.equalsIgnoreCase("base64")) {
            return new BASE64DecoderStream(is);
        }
        if (encoding2.equalsIgnoreCase("quoted-printable")) {
            return new QPDecoderStream(is);
        }
        if (encoding2.equalsIgnoreCase("uuencode") || encoding2.equalsIgnoreCase("x-uuencode") || encoding2.equalsIgnoreCase("x-uue")) {
            return new UUDecoderStream(is);
        }
        if (encoding2.equalsIgnoreCase("binary") || encoding2.equalsIgnoreCase("7bit") || encoding2.equalsIgnoreCase("8bit")) {
            return is;
        }
        if (!ignoreUnknownEncoding) {
            throw new MessagingException("Unknown encoding: " + encoding2);
        }
        return is;
    }

    public static OutputStream encode(OutputStream os, String encoding2) throws MessagingException {
        if (encoding2 == null) {
            return os;
        }
        if (encoding2.equalsIgnoreCase("base64")) {
            return new BASE64EncoderStream(os);
        }
        if (encoding2.equalsIgnoreCase("quoted-printable")) {
            return new QPEncoderStream(os);
        }
        if (encoding2.equalsIgnoreCase("uuencode") || encoding2.equalsIgnoreCase("x-uuencode") || encoding2.equalsIgnoreCase("x-uue")) {
            return new UUEncoderStream(os);
        }
        if (encoding2.equalsIgnoreCase("binary") || encoding2.equalsIgnoreCase("7bit") || encoding2.equalsIgnoreCase("8bit")) {
            return os;
        }
        throw new MessagingException("Unknown encoding: " + encoding2);
    }

    public static OutputStream encode(OutputStream os, String encoding2, String filename2) throws MessagingException {
        if (encoding2 == null) {
            return os;
        }
        if (encoding2.equalsIgnoreCase("base64")) {
            return new BASE64EncoderStream(os);
        }
        if (encoding2.equalsIgnoreCase("quoted-printable")) {
            return new QPEncoderStream(os);
        }
        if (encoding2.equalsIgnoreCase("uuencode") || encoding2.equalsIgnoreCase("x-uuencode") || encoding2.equalsIgnoreCase("x-uue")) {
            return new UUEncoderStream(os, filename2);
        }
        if (encoding2.equalsIgnoreCase("binary") || encoding2.equalsIgnoreCase("7bit") || encoding2.equalsIgnoreCase("8bit")) {
            return os;
        }
        throw new MessagingException("Unknown encoding: " + encoding2);
    }

    public static String encodeText(String text) throws UnsupportedEncodingException {
        return MimeUtility.encodeText(text, null, null);
    }

    public static String encodeText(String text, String charset, String encoding2) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(text, charset, encoding2, false);
    }

    public static String decodeText(String etext) throws UnsupportedEncodingException {
        String lwsp = " \t\n\r";
        if (etext.indexOf("=?") == -1) {
            return etext;
        }
        StringTokenizer st = new StringTokenizer(etext, lwsp, true);
        StringBuilder sb = new StringBuilder();
        StringBuilder wsb = new StringBuilder();
        boolean prevWasEncoded = false;
        while (st.hasMoreTokens()) {
            String word;
            String s2 = st.nextToken();
            char c = s2.charAt(0);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                wsb.append(c);
                continue;
            }
            try {
                word = MimeUtility.decodeWord(s2);
                if (!prevWasEncoded && wsb.length() > 0) {
                    sb.append((CharSequence)wsb);
                }
                prevWasEncoded = true;
            }
            catch (ParseException pex) {
                word = s2;
                if (!decodeStrict) {
                    String dword = MimeUtility.decodeInnerWords(word);
                    if (dword != word) {
                        if (!(prevWasEncoded && word.startsWith("=?") || wsb.length() <= 0)) {
                            sb.append((CharSequence)wsb);
                        }
                        prevWasEncoded = word.endsWith("?=");
                        word = dword;
                    } else {
                        if (wsb.length() > 0) {
                            sb.append((CharSequence)wsb);
                        }
                        prevWasEncoded = false;
                    }
                }
                if (wsb.length() > 0) {
                    sb.append((CharSequence)wsb);
                }
                prevWasEncoded = false;
            }
            sb.append(word);
            wsb.setLength(0);
        }
        sb.append((CharSequence)wsb);
        return sb.toString();
    }

    public static String encodeWord(String word) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(word, null, null);
    }

    public static String encodeWord(String word, String charset, String encoding2) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(word, charset, encoding2, true);
    }

    private static String encodeWord(String string2, String charset, String encoding2, boolean encodingWord) throws UnsupportedEncodingException {
        boolean b64;
        String jcharset;
        int ascii = MimeUtility.checkAscii(string2);
        if (ascii == 1) {
            return string2;
        }
        if (charset == null) {
            jcharset = MimeUtility.getDefaultJavaCharset();
            charset = MimeUtility.getDefaultMIMECharset();
        } else {
            jcharset = MimeUtility.javaCharset(charset);
        }
        if (encoding2 == null) {
            encoding2 = ascii != 3 ? "Q" : "B";
        }
        if (encoding2.equalsIgnoreCase("B")) {
            b64 = true;
        } else if (encoding2.equalsIgnoreCase("Q")) {
            b64 = false;
        } else {
            throw new UnsupportedEncodingException("Unknown transfer encoding: " + encoding2);
        }
        StringBuilder outb = new StringBuilder();
        MimeUtility.doEncode(string2, b64, jcharset, 68 - charset.length(), "=?" + charset + "?" + encoding2 + "?", true, encodingWord, outb);
        return outb.toString();
    }

    private static void doEncode(String string2, boolean b64, String jcharset, int avail, String prefix, boolean first2, boolean encodingWord, StringBuilder buf) throws UnsupportedEncodingException {
        int size2;
        byte[] bytes2 = string2.getBytes(jcharset);
        int len = b64 ? BEncoderStream.encodedLength(bytes2) : QEncoderStream.encodedLength(bytes2, encodingWord);
        if (len > avail && (size2 = string2.length()) > 1) {
            int split2 = size2 / 2;
            if (Character.isHighSurrogate(string2.charAt(split2 - 1))) {
                --split2;
            }
            if (split2 > 0) {
                MimeUtility.doEncode(string2.substring(0, split2), b64, jcharset, avail, prefix, first2, encodingWord, buf);
            }
            MimeUtility.doEncode(string2.substring(split2, size2), b64, jcharset, avail, prefix, false, encodingWord, buf);
        } else {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            FilterOutputStream eos = b64 ? new BEncoderStream(os) : new QEncoderStream((OutputStream)os, encodingWord);
            try {
                ((OutputStream)eos).write(bytes2);
                ((OutputStream)eos).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byte[] encodedBytes = os.toByteArray();
            if (!first2) {
                if (foldEncodedWords) {
                    buf.append("\r\n ");
                } else {
                    buf.append(" ");
                }
            }
            buf.append(prefix);
            for (int i2 = 0; i2 < encodedBytes.length; ++i2) {
                buf.append((char)encodedBytes[i2]);
            }
            buf.append("?=");
        }
    }

    public static String decodeWord(String eword) throws ParseException, UnsupportedEncodingException {
        if (!eword.startsWith("=?")) {
            throw new ParseException("encoded word does not start with \"=?\": " + eword);
        }
        int start2 = 2;
        int pos2 = eword.indexOf(63, start2);
        if (pos2 == -1) {
            throw new ParseException("encoded word does not include charset: " + eword);
        }
        String charset = eword.substring(start2, pos2);
        int lpos = charset.indexOf(42);
        if (lpos >= 0) {
            charset = charset.substring(0, lpos);
        }
        charset = MimeUtility.javaCharset(charset);
        start2 = pos2 + 1;
        if ((pos2 = eword.indexOf(63, start2)) == -1) {
            throw new ParseException("encoded word does not include encoding: " + eword);
        }
        String encoding2 = eword.substring(start2, pos2);
        start2 = pos2 + 1;
        if ((pos2 = eword.indexOf("?=", start2)) == -1) {
            throw new ParseException("encoded word does not end with \"?=\": " + eword);
        }
        String word = eword.substring(start2, pos2);
        try {
            String decodedWord;
            if (word.length() > 0) {
                FilterInputStream is;
                ByteArrayInputStream bis = new ByteArrayInputStream(ASCIIUtility.getBytes(word));
                if (encoding2.equalsIgnoreCase("B")) {
                    is = new BASE64DecoderStream(bis);
                } else if (encoding2.equalsIgnoreCase("Q")) {
                    is = new QDecoderStream(bis);
                } else {
                    throw new UnsupportedEncodingException("unknown encoding: " + encoding2);
                }
                int count2 = bis.available();
                byte[] bytes2 = new byte[count2];
                count2 = ((InputStream)is).read(bytes2, 0, count2);
                decodedWord = count2 <= 0 ? "" : new String(bytes2, 0, count2, charset);
            } else {
                decodedWord = "";
            }
            if (pos2 + 2 < eword.length()) {
                String rest2 = eword.substring(pos2 + 2);
                if (!decodeStrict) {
                    rest2 = MimeUtility.decodeInnerWords(rest2);
                }
                decodedWord = decodedWord + rest2;
            }
            return decodedWord;
        }
        catch (UnsupportedEncodingException uex) {
            throw uex;
        }
        catch (IOException ioex) {
            throw new ParseException(ioex.toString());
        }
        catch (IllegalArgumentException iex) {
            throw new UnsupportedEncodingException(charset);
        }
    }

    private static String decodeInnerWords(String word) throws UnsupportedEncodingException {
        int i2;
        int start2 = 0;
        StringBuilder buf = new StringBuilder();
        while ((i2 = word.indexOf("=?", start2)) >= 0) {
            buf.append(word.substring(start2, i2));
            int end2 = word.indexOf(63, i2 + 2);
            if (end2 < 0 || (end2 = word.indexOf(63, end2 + 1)) < 0 || (end2 = word.indexOf("?=", end2 + 1)) < 0) break;
            String s2 = word.substring(i2, end2 + 2);
            try {
                s2 = MimeUtility.decodeWord(s2);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            buf.append(s2);
            start2 = end2 + 2;
        }
        if (start2 == 0) {
            return word;
        }
        if (start2 < word.length()) {
            buf.append(word.substring(start2));
        }
        return buf.toString();
    }

    public static String quote(String word, String specials) {
        int len;
        int n = len = word == null ? 0 : word.length();
        if (len == 0) {
            return "\"\"";
        }
        boolean needQuoting = false;
        for (int i2 = 0; i2 < len; ++i2) {
            char c = word.charAt(i2);
            if (c == '\"' || c == '\\' || c == '\r' || c == '\n') {
                StringBuilder sb = new StringBuilder(len + 3);
                sb.append('\"');
                sb.append(word.substring(0, i2));
                int lastc = 0;
                for (int j = i2; j < len; ++j) {
                    char cc = word.charAt(j);
                    if (!(cc != '\"' && cc != '\\' && cc != '\r' && cc != '\n' || cc == '\n' && lastc == 13)) {
                        sb.append('\\');
                    }
                    sb.append(cc);
                    lastc = cc;
                }
                sb.append('\"');
                return sb.toString();
            }
            if (c >= ' ' && (c < '\u007f' || allowUtf8) && specials.indexOf(c) < 0) continue;
            needQuoting = true;
        }
        if (needQuoting) {
            StringBuilder sb = new StringBuilder(len + 2);
            sb.append('\"').append(word).append('\"');
            return sb.toString();
        }
        return word;
    }

    public static String fold(int used, String s2) {
        char c;
        int end2;
        if (!foldText) {
            return s2;
        }
        for (end2 = s2.length() - 1; end2 >= 0 && ((c = s2.charAt(end2)) == ' ' || c == '\t' || c == '\r' || c == '\n'); --end2) {
        }
        if (end2 != s2.length() - 1) {
            s2 = s2.substring(0, end2 + 1);
        }
        if (used + s2.length() <= 76) {
            return MimeUtility.makesafe(s2);
        }
        StringBuilder sb = new StringBuilder(s2.length() + 4);
        char lastc = '\u0000';
        while (used + s2.length() > 76) {
            int lastspace = -1;
            for (int i2 = 0; i2 < s2.length() && (lastspace == -1 || used + i2 <= 76); ++i2) {
                c = s2.charAt(i2);
                if ((c == ' ' || c == '\t') && lastc != ' ' && lastc != '\t') {
                    lastspace = i2;
                }
                lastc = c;
            }
            if (lastspace == -1) {
                sb.append(s2);
                s2 = "";
                used = 0;
                break;
            }
            sb.append(s2.substring(0, lastspace));
            sb.append("\r\n");
            lastc = s2.charAt(lastspace);
            sb.append(lastc);
            s2 = s2.substring(lastspace + 1);
            used = 1;
        }
        sb.append(s2);
        return MimeUtility.makesafe(sb);
    }

    private static String makesafe(CharSequence s2) {
        char c;
        int i2;
        for (i2 = 0; i2 < s2.length() && (c = s2.charAt(i2)) != '\r' && c != '\n'; ++i2) {
        }
        if (i2 == s2.length()) {
            return s2.toString();
        }
        StringBuilder sb = new StringBuilder(s2.length() + 1);
        BufferedReader r = new BufferedReader(new StringReader(s2.toString()));
        try {
            String line;
            while ((line = r.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (sb.length() > 0) {
                    sb.append("\r\n");
                    assert (line.length() > 0);
                    char c2 = line.charAt(0);
                    if (c2 != ' ' && c2 != '\t') {
                        sb.append(' ');
                    }
                }
                sb.append(line);
            }
        }
        catch (IOException ex) {
            return s2.toString();
        }
        return sb.toString();
    }

    public static String unfold(String s2) {
        int i2;
        if (!foldText) {
            return s2;
        }
        StringBuilder sb = null;
        while ((i2 = MimeUtility.indexOfAny(s2, "\r\n")) >= 0) {
            char c;
            int start2 = i2++;
            int slen = s2.length();
            if (i2 < slen && s2.charAt(i2 - 1) == '\r' && s2.charAt(i2) == '\n') {
                ++i2;
            }
            if (start2 > 0 && s2.charAt(start2 - 1) == '\\') {
                if (sb == null) {
                    sb = new StringBuilder(s2.length());
                }
                sb.append(s2.substring(0, start2 - 1));
                sb.append(s2.substring(start2, i2));
                s2 = s2.substring(i2);
                continue;
            }
            if (i2 >= slen || (c = s2.charAt(i2)) == ' ' || c == '\t') {
                if (sb == null) {
                    sb = new StringBuilder(s2.length());
                }
                sb.append(s2.substring(0, start2));
                s2 = s2.substring(i2);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(s2.length());
            }
            sb.append(s2.substring(0, i2));
            s2 = s2.substring(i2);
        }
        if (sb != null) {
            sb.append(s2);
            return sb.toString();
        }
        return s2;
    }

    private static int indexOfAny(String s2, String any) {
        return MimeUtility.indexOfAny(s2, any, 0);
    }

    private static int indexOfAny(String s2, String any, int start2) {
        try {
            int len = s2.length();
            for (int i2 = start2; i2 < len; ++i2) {
                if (any.indexOf(s2.charAt(i2)) < 0) continue;
                return i2;
            }
            return -1;
        }
        catch (StringIndexOutOfBoundsException e) {
            return -1;
        }
    }

    public static String javaCharset(String charset) {
        if (mime2java == null || charset == null) {
            return charset;
        }
        String alias = mime2java.get(charset.toLowerCase(Locale.ENGLISH));
        if (alias != null) {
            try {
                Charset.forName(alias);
            }
            catch (Exception ex) {
                alias = null;
            }
        }
        return alias == null ? charset : alias;
    }

    public static String mimeCharset(String charset) {
        if (java2mime == null || charset == null) {
            return charset;
        }
        String alias = java2mime.get(charset.toLowerCase(Locale.ENGLISH));
        return alias == null ? charset : alias;
    }

    public static String getDefaultJavaCharset() {
        block6: {
            if (defaultJavaCharset == null) {
                String mimecs = null;
                try {
                    mimecs = System.getProperty("mail.mime.charset");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (mimecs != null && mimecs.length() > 0) {
                    defaultJavaCharset = MimeUtility.javaCharset(mimecs);
                    return defaultJavaCharset;
                }
                try {
                    defaultJavaCharset = System.getProperty("file.encoding", "8859_1");
                }
                catch (SecurityException sex) {
                    class NullInputStream
                    extends InputStream {
                        NullInputStream() {
                        }

                        @Override
                        public int read() {
                            return 0;
                        }
                    }
                    InputStreamReader reader = new InputStreamReader(new NullInputStream());
                    defaultJavaCharset = reader.getEncoding();
                    if (defaultJavaCharset != null) break block6;
                    defaultJavaCharset = "8859_1";
                }
            }
        }
        return defaultJavaCharset;
    }

    static String getDefaultMIMECharset() {
        if (defaultMIMECharset == null) {
            try {
                defaultMIMECharset = System.getProperty("mail.mime.charset");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (defaultMIMECharset == null) {
            defaultMIMECharset = MimeUtility.mimeCharset(MimeUtility.getDefaultJavaCharset());
        }
        return defaultMIMECharset;
    }

    private static void loadMappings(LineInputStream is, Map<String, String> table) {
        while (true) {
            String currLine;
            try {
                currLine = is.readLine();
            }
            catch (IOException ioex) {
                break;
            }
            if (currLine == null || currLine.startsWith("--") && currLine.endsWith("--")) break;
            if (currLine.trim().length() == 0 || currLine.startsWith("#")) continue;
            StringTokenizer tk = new StringTokenizer(currLine, " \t");
            try {
                String key2 = tk.nextToken();
                String value2 = tk.nextToken();
                table.put(key2.toLowerCase(Locale.ENGLISH), value2);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
    }

    static int checkAscii(String s2) {
        int ascii = 0;
        int non_ascii = 0;
        int l = s2.length();
        for (int i2 = 0; i2 < l; ++i2) {
            if (MimeUtility.nonascii(s2.charAt(i2))) {
                ++non_ascii;
                continue;
            }
            ++ascii;
        }
        if (non_ascii == 0) {
            return 1;
        }
        if (ascii > non_ascii) {
            return 2;
        }
        return 3;
    }

    static int checkAscii(byte[] b2) {
        int ascii = 0;
        int non_ascii = 0;
        for (int i2 = 0; i2 < b2.length; ++i2) {
            if (MimeUtility.nonascii(b2[i2] & 0xFF)) {
                ++non_ascii;
                continue;
            }
            ++ascii;
        }
        if (non_ascii == 0) {
            return 1;
        }
        if (ascii > non_ascii) {
            return 2;
        }
        return 3;
    }

    static int checkAscii(InputStream is, int max2, boolean breakOnNonAscii) {
        int ascii = 0;
        int non_ascii = 0;
        int block = 4096;
        int linelen = 0;
        boolean longLine = false;
        boolean badEOL = false;
        boolean checkEOL = encodeEolStrict && breakOnNonAscii;
        byte[] buf = null;
        if (max2 != 0) {
            block = max2 == -1 ? 4096 : Math.min(max2, 4096);
            buf = new byte[block];
        }
        while (max2 != 0) {
            int len;
            try {
                len = is.read(buf, 0, block);
                if (len == -1) break;
                int lastb = 0;
                for (int i2 = 0; i2 < len; ++i2) {
                    int b2 = buf[i2] & 0xFF;
                    if (checkEOL && (lastb == 13 && b2 != 10 || lastb != 13 && b2 == 10)) {
                        badEOL = true;
                    }
                    if (b2 == 13 || b2 == 10) {
                        linelen = 0;
                    } else if (++linelen > 998) {
                        longLine = true;
                    }
                    if (MimeUtility.nonascii(b2)) {
                        if (breakOnNonAscii) {
                            return 3;
                        }
                        ++non_ascii;
                    } else {
                        ++ascii;
                    }
                    lastb = b2;
                }
            }
            catch (IOException ioex) {
                break;
            }
            if (max2 == -1) continue;
            max2 -= len;
        }
        if (max2 == 0 && breakOnNonAscii) {
            return 3;
        }
        if (non_ascii == 0) {
            if (badEOL) {
                return 3;
            }
            if (longLine) {
                return 2;
            }
            return 1;
        }
        if (ascii > non_ascii) {
            return 2;
        }
        return 3;
    }

    static final boolean nonascii(int b2) {
        return b2 >= 127 || b2 < 32 && b2 != 13 && b2 != 10 && b2 != 9;
    }

    static {
        block11: {
            nonAsciiCharsetMap = new HashMap<String, Boolean>();
            decodeStrict = PropUtil.getBooleanSystemProperty("mail.mime.decodetext.strict", true);
            encodeEolStrict = PropUtil.getBooleanSystemProperty("mail.mime.encodeeol.strict", false);
            ignoreUnknownEncoding = PropUtil.getBooleanSystemProperty("mail.mime.ignoreunknownencoding", false);
            allowUtf8 = PropUtil.getBooleanSystemProperty("mail.mime.allowutf8", false);
            foldEncodedWords = PropUtil.getBooleanSystemProperty("mail.mime.foldencodedwords", false);
            foldText = PropUtil.getBooleanSystemProperty("mail.mime.foldtext", true);
            java2mime = new HashMap<String, String>(40);
            mime2java = new HashMap<String, String>(14);
            try {
                InputStream is = MimeUtility.class.getResourceAsStream("/META-INF/javamail.charset.map");
                if (is == null) break block11;
                try {
                    is = new LineInputStream(is);
                    MimeUtility.loadMappings((LineInputStream)is, java2mime);
                    MimeUtility.loadMappings((LineInputStream)is, mime2java);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (java2mime.isEmpty()) {
            java2mime.put("8859_1", "ISO-8859-1");
            java2mime.put("iso8859_1", "ISO-8859-1");
            java2mime.put("iso8859-1", "ISO-8859-1");
            java2mime.put("8859_2", "ISO-8859-2");
            java2mime.put("iso8859_2", "ISO-8859-2");
            java2mime.put("iso8859-2", "ISO-8859-2");
            java2mime.put("8859_3", "ISO-8859-3");
            java2mime.put("iso8859_3", "ISO-8859-3");
            java2mime.put("iso8859-3", "ISO-8859-3");
            java2mime.put("8859_4", "ISO-8859-4");
            java2mime.put("iso8859_4", "ISO-8859-4");
            java2mime.put("iso8859-4", "ISO-8859-4");
            java2mime.put("8859_5", "ISO-8859-5");
            java2mime.put("iso8859_5", "ISO-8859-5");
            java2mime.put("iso8859-5", "ISO-8859-5");
            java2mime.put("8859_6", "ISO-8859-6");
            java2mime.put("iso8859_6", "ISO-8859-6");
            java2mime.put("iso8859-6", "ISO-8859-6");
            java2mime.put("8859_7", "ISO-8859-7");
            java2mime.put("iso8859_7", "ISO-8859-7");
            java2mime.put("iso8859-7", "ISO-8859-7");
            java2mime.put("8859_8", "ISO-8859-8");
            java2mime.put("iso8859_8", "ISO-8859-8");
            java2mime.put("iso8859-8", "ISO-8859-8");
            java2mime.put("8859_9", "ISO-8859-9");
            java2mime.put("iso8859_9", "ISO-8859-9");
            java2mime.put("iso8859-9", "ISO-8859-9");
            java2mime.put("sjis", "Shift_JIS");
            java2mime.put("jis", "ISO-2022-JP");
            java2mime.put("iso2022jp", "ISO-2022-JP");
            java2mime.put("euc_jp", "euc-jp");
            java2mime.put("koi8_r", "koi8-r");
            java2mime.put("euc_cn", "euc-cn");
            java2mime.put("euc_tw", "euc-tw");
            java2mime.put("euc_kr", "euc-kr");
        }
        if (mime2java.isEmpty()) {
            mime2java.put("iso-2022-cn", "ISO2022CN");
            mime2java.put("iso-2022-kr", "ISO2022KR");
            mime2java.put("utf-8", "UTF8");
            mime2java.put("utf8", "UTF8");
            mime2java.put("ja_jp.iso2022-7", "ISO2022JP");
            mime2java.put("ja_jp.eucjp", "EUCJIS");
            mime2java.put("euc-kr", "KSC5601");
            mime2java.put("euckr", "KSC5601");
            mime2java.put("us-ascii", "ISO-8859-1");
            mime2java.put("x-us-ascii", "ISO-8859-1");
            mime2java.put("gb2312", "GB18030");
            mime2java.put("cp936", "GB18030");
            mime2java.put("ms936", "GB18030");
            mime2java.put("gbk", "GB18030");
        }
    }
}

