/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.io.Serializable;
import javax.xml.namespace.QName;

public class JAXBElement<T>
implements Serializable {
    protected final QName name;
    protected final Class<T> declaredType;
    protected final Class scope;
    protected T value;
    protected boolean nil = false;
    private static final long serialVersionUID = 1L;

    public JAXBElement(QName name2, Class<T> declaredType, Class scope, T value2) {
        if (declaredType == null || name2 == null) {
            throw new IllegalArgumentException();
        }
        this.declaredType = declaredType;
        if (scope == null) {
            scope = GlobalScope.class;
        }
        this.scope = scope;
        this.name = name2;
        this.setValue(value2);
    }

    public JAXBElement(QName name2, Class<T> declaredType, T value2) {
        this(name2, declaredType, GlobalScope.class, value2);
    }

    public Class<T> getDeclaredType() {
        return this.declaredType;
    }

    public QName getName() {
        return this.name;
    }

    public void setValue(T t) {
        this.value = t;
    }

    public T getValue() {
        return this.value;
    }

    public Class getScope() {
        return this.scope;
    }

    public boolean isNil() {
        return this.value == null || this.nil;
    }

    public void setNil(boolean value2) {
        this.nil = value2;
    }

    public boolean isGlobalScope() {
        return this.scope == GlobalScope.class;
    }

    public boolean isTypeSubstituted() {
        if (this.value == null) {
            return false;
        }
        return this.value.getClass() != this.declaredType;
    }

    public static final class GlobalScope {
    }
}

