/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.converters;

import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.annotations.LongLong;
import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.provider.MemoryManager;
import jnr.ffi.provider.ParameterFlags;

@ToNativeConverter.NoContext
@ToNativeConverter.Cacheable
public class Pointer64ArrayParameterConverter
implements ToNativeConverter<Pointer[], long[]> {
    protected final Runtime runtime;
    protected final int parameterFlags;

    public static ToNativeConverter<Pointer[], long[]> getInstance(ToNativeContext toNativeContext) {
        int parameterFlags = ParameterFlags.parse(toNativeContext.getAnnotations());
        return !ParameterFlags.isOut(parameterFlags) ? new Pointer64ArrayParameterConverter(toNativeContext.getRuntime(), parameterFlags) : new Out(toNativeContext.getRuntime(), parameterFlags);
    }

    Pointer64ArrayParameterConverter(Runtime runtime2, int parameterFlags) {
        this.runtime = runtime2;
        this.parameterFlags = parameterFlags;
    }

    @Override
    @LongLong
    public Class<long[]> nativeType() {
        return long[].class;
    }

    @Override
    public long[] toNative(Pointer[] pointers, ToNativeContext context) {
        if (pointers == null) {
            return null;
        }
        long[] primitive = new long[pointers.length];
        if (ParameterFlags.isIn(this.parameterFlags)) {
            for (int i2 = 0; i2 < pointers.length; ++i2) {
                if (pointers[i2] != null && !pointers[i2].isDirect()) {
                    throw new IllegalArgumentException("invalid pointer in array at index " + i2);
                }
                primitive[i2] = pointers[i2] != null ? pointers[i2].address() : 0L;
            }
        }
        return primitive;
    }

    public static final class Out
    extends Pointer64ArrayParameterConverter
    implements ToNativeConverter.PostInvocation<Pointer[], long[]> {
        Out(Runtime runtime2, int parameterFlags) {
            super(runtime2, parameterFlags);
        }

        @Override
        public void postInvoke(Pointer[] pointers, long[] primitive, ToNativeContext context) {
            if (pointers != null && primitive != null) {
                MemoryManager mm3 = this.runtime.getMemoryManager();
                for (int i2 = 0; i2 < pointers.length; ++i2) {
                    pointers[i2] = mm3.newPointer(primitive[i2]);
                }
            }
        }
    }
}

