/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Closure;
import com.kenai.jffi.ClosureMagazine;
import com.kenai.jffi.ClosureManager;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.annotations.Delegate;
import jnr.ffi.mapper.SignatureTypeMapper;
import jnr.ffi.provider.FromNativeType;
import jnr.ffi.provider.SigType;
import jnr.ffi.provider.ToNativeType;
import jnr.ffi.provider.jffi.AsmClassLoader;
import jnr.ffi.provider.jffi.ClosureUtil;
import jnr.ffi.provider.jffi.InvokerUtil;
import jnr.ffi.provider.jffi.NativeClosurePointer;
import jnr.ffi.provider.jffi.NativeClosureProxy;
import jnr.ffi.provider.jffi.NativeFinalizer;
import jnr.ffi.util.ref.FinalizableWeakReference;

public final class NativeClosureFactory<T> {
    private final Runtime runtime;
    private final ConcurrentMap<Integer, ClosureReference> closures = new ConcurrentHashMap<Integer, ClosureReference>();
    private final CallContext callContext;
    private final NativeClosureProxy.Factory closureProxyFactory;
    private final ConcurrentLinkedQueue<NativeClosurePointer> freeQueue = new ConcurrentLinkedQueue();
    private ClosureMagazine currentMagazine;

    protected NativeClosureFactory(Runtime runtime2, CallContext callContext, NativeClosureProxy.Factory closureProxyFactory) {
        this.runtime = runtime2;
        this.closureProxyFactory = closureProxyFactory;
        this.callContext = callContext;
    }

    static <T> NativeClosureFactory newClosureFactory(Runtime runtime2, Class<T> closureClass, SignatureTypeMapper typeMapper, AsmClassLoader classLoader) {
        Method callMethod = null;
        for (Method m3 : closureClass.getMethods()) {
            if (!m3.isAnnotationPresent(Delegate.class) || !Modifier.isPublic(m3.getModifiers()) || Modifier.isStatic(m3.getModifiers())) continue;
            callMethod = m3;
            break;
        }
        if (callMethod == null) {
            throw new NoSuchMethodError("no public non-static delegate method defined in " + closureClass.getName());
        }
        Class<?>[] parameterTypes = callMethod.getParameterTypes();
        SigType[] parameterSigTypes = new FromNativeType[parameterTypes.length];
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            parameterSigTypes[i2] = ClosureUtil.getParameterType(runtime2, callMethod, i2, typeMapper);
        }
        ToNativeType resultType = ClosureUtil.getResultType(runtime2, callMethod, typeMapper);
        return new NativeClosureFactory<T>(runtime2, InvokerUtil.getCallContext(resultType, parameterSigTypes, InvokerUtil.getNativeCallingConvention(callMethod), false), NativeClosureProxy.newProxyFactory(runtime2, callMethod, resultType, (FromNativeType[])parameterSigTypes, classLoader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expunge(ClosureReference ref, Integer key2) {
        if (ref.next == null && this.closures.remove(key2, ref)) {
            return;
        }
        ConcurrentMap<Integer, ClosureReference> concurrentMap = this.closures;
        synchronized (concurrentMap) {
            ClosureReference clref;
            ClosureReference prev = clref = (ClosureReference)this.closures.get(key2);
            while (clref != null) {
                if (clref == ref) {
                    if (prev != clref) {
                        prev.next = clref.next;
                        break;
                    }
                    if (clref.next != null) {
                        this.closures.replace(key2, clref, clref.next);
                        break;
                    }
                    this.closures.remove(key2, clref);
                    break;
                }
                prev = clref;
                clref = clref.next;
            }
        }
    }

    private void recycle(NativeClosurePointer ptr) {
        this.freeQueue.add(ptr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NativeClosurePointer allocateClosurePointer() {
        NativeClosurePointer closurePointer = this.freeQueue.poll();
        if (closurePointer != null) {
            return closurePointer;
        }
        NativeClosureProxy proxy2 = this.closureProxyFactory.newClosureProxy();
        Closure.Handle closureHandle = null;
        NativeClosureFactory nativeClosureFactory = this;
        synchronized (nativeClosureFactory) {
            do {
                if (this.currentMagazine != null && (closureHandle = this.currentMagazine.allocate(proxy2)) != null) continue;
                this.currentMagazine = ClosureManager.getInstance().newClosureMagazine(this.callContext, this.closureProxyFactory.getInvokeMethod());
            } while (closureHandle == null);
        }
        return new NativeClosurePointer(this.runtime, closureHandle, proxy2);
    }

    NativeClosurePointer newClosure(Object callable, Integer key2) {
        return this.newClosureReference(callable, key2).pointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClosureReference newClosureReference(Object callable, Integer key2) {
        ClosureReference ref;
        NativeClosurePointer ptr = this.allocateClosurePointer();
        ptr.proxy.closureReference = ref = new ClosureReference(callable, key2, this, ptr);
        if (this.closures.putIfAbsent(key2, ref) == null) {
            return ref;
        }
        ConcurrentMap<Integer, ClosureReference> concurrentMap = this.closures;
        synchronized (concurrentMap) {
            do {
                ref.next = (ClosureReference)this.closures.get(key2);
            } while ((ref.next != null || this.closures.putIfAbsent(key2, ref) != null) && !this.closures.replace(key2, ref.next, ref));
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClosureReference getClosureReference(Object callable) {
        Integer key2 = System.identityHashCode(callable);
        ClosureReference ref = (ClosureReference)this.closures.get(key2);
        if (ref != null) {
            if (ref.getCallable() == callable) {
                return ref;
            }
            ConcurrentMap<Integer, ClosureReference> concurrentMap = this.closures;
            synchronized (concurrentMap) {
                while ((ref = ref.next) != null) {
                    if (ref.getCallable() != callable) continue;
                    return ref;
                }
            }
        }
        return this.newClosureReference(callable, key2);
    }

    final class ClosureReference
    extends FinalizableWeakReference<Object> {
        volatile ClosureReference next;
        private final NativeClosureFactory factory;
        private final NativeClosurePointer pointer;
        private final Integer key;

        private ClosureReference(Object referent, Integer key2, NativeClosureFactory factory, NativeClosurePointer pointer2) {
            super(referent, NativeFinalizer.getInstance().getFinalizerQueue());
            this.factory = factory;
            this.key = key2;
            this.pointer = pointer2;
        }

        @Override
        public void finalizeReferent() {
            this.clear();
            this.factory.expunge(this, this.key);
            this.factory.recycle(this.pointer);
        }

        Object getCallable() {
            return this.get();
        }

        Pointer getPointer() {
            return this.pointer;
        }
    }
}

