/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.CharSet;
import org.apache.commons.lang3.StringUtils;

public class CharSetUtils {
    public static boolean containsAny(String str, String ... set2) {
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set2)) {
            return false;
        }
        CharSet chars2 = CharSet.getInstance(set2);
        for (char c : str.toCharArray()) {
            if (!chars2.contains(c)) continue;
            return true;
        }
        return false;
    }

    public static int count(String str, String ... set2) {
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set2)) {
            return 0;
        }
        CharSet chars2 = CharSet.getInstance(set2);
        int count2 = 0;
        for (char c : str.toCharArray()) {
            if (!chars2.contains(c)) continue;
            ++count2;
        }
        return count2;
    }

    private static boolean deepEmpty(String[] strings) {
        if (strings != null) {
            for (String s2 : strings) {
                if (!StringUtils.isNotEmpty(s2)) continue;
                return false;
            }
        }
        return true;
    }

    public static String delete(String str, String ... set2) {
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set2)) {
            return str;
        }
        return CharSetUtils.modify(str, set2, false);
    }

    public static String keep(String str, String ... set2) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty() || CharSetUtils.deepEmpty(set2)) {
            return "";
        }
        return CharSetUtils.modify(str, set2, true);
    }

    private static String modify(String str, String[] set2, boolean expect) {
        char[] chrs;
        CharSet chars2 = CharSet.getInstance(set2);
        StringBuilder buffer = new StringBuilder(str.length());
        for (char chr2 : chrs = str.toCharArray()) {
            if (chars2.contains(chr2) != expect) continue;
            buffer.append(chr2);
        }
        return buffer.toString();
    }

    public static String squeeze(String str, String ... set2) {
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set2)) {
            return str;
        }
        CharSet chars2 = CharSet.getInstance(set2);
        StringBuilder buffer = new StringBuilder(str.length());
        char[] chrs = str.toCharArray();
        int sz = chrs.length;
        char lastChar = chrs[0];
        char ch = ' ';
        Character inChars = null;
        Character notInChars = null;
        buffer.append(lastChar);
        for (int i2 = 1; i2 < sz; ++i2) {
            ch = chrs[i2];
            if (ch == lastChar) {
                if (inChars != null && ch == inChars.charValue()) continue;
                if (notInChars == null || ch != notInChars.charValue()) {
                    if (chars2.contains(ch)) {
                        inChars = Character.valueOf(ch);
                        continue;
                    }
                    notInChars = Character.valueOf(ch);
                }
            }
            buffer.append(ch);
            lastChar = ch;
        }
        return buffer.toString();
    }
}

