/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.regex.Pattern;

public class RegExUtils {
    public static String removeAll(String text, Pattern regex) {
        return RegExUtils.replaceAll(text, regex, "");
    }

    public static String removeAll(String text, String regex) {
        return RegExUtils.replaceAll(text, regex, "");
    }

    public static String removeFirst(String text, Pattern regex) {
        return RegExUtils.replaceFirst(text, regex, "");
    }

    public static String removeFirst(String text, String regex) {
        return RegExUtils.replaceFirst(text, regex, "");
    }

    public static String removePattern(String text, String regex) {
        return RegExUtils.replacePattern(text, regex, "");
    }

    public static String replaceAll(String text, Pattern regex, String replacement2) {
        if (text == null || regex == null || replacement2 == null) {
            return text;
        }
        return regex.matcher(text).replaceAll(replacement2);
    }

    public static String replaceAll(String text, String regex, String replacement2) {
        if (text == null || regex == null || replacement2 == null) {
            return text;
        }
        return text.replaceAll(regex, replacement2);
    }

    public static String replaceFirst(String text, Pattern regex, String replacement2) {
        if (text == null || regex == null || replacement2 == null) {
            return text;
        }
        return regex.matcher(text).replaceFirst(replacement2);
    }

    public static String replaceFirst(String text, String regex, String replacement2) {
        if (text == null || regex == null || replacement2 == null) {
            return text;
        }
        return text.replaceFirst(regex, replacement2);
    }

    public static String replacePattern(String text, String regex, String replacement2) {
        if (text == null || regex == null || replacement2 == null) {
            return text;
        }
        return Pattern.compile(regex, 32).matcher(text).replaceAll(replacement2);
    }
}

