/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.text.StrMatcher;
import org.apache.commons.lang3.text.StrTokenizer;

@Deprecated
public class StrBuilder
implements CharSequence,
Appendable,
Serializable,
Builder<String> {
    static final int CAPACITY = 32;
    private static final long serialVersionUID = 7628716375283629643L;
    protected char[] buffer;
    protected int size;
    private String newLine;
    private String nullText;

    public StrBuilder() {
        this(32);
    }

    public StrBuilder(int initialCapacity) {
        if (initialCapacity <= 0) {
            initialCapacity = 32;
        }
        this.buffer = new char[initialCapacity];
    }

    public StrBuilder(String str) {
        if (str == null) {
            this.buffer = new char[32];
        } else {
            this.buffer = new char[str.length() + 32];
            this.append(str);
        }
    }

    public String getNewLineText() {
        return this.newLine;
    }

    public StrBuilder setNewLineText(String newLine) {
        this.newLine = newLine;
        return this;
    }

    public String getNullText() {
        return this.nullText;
    }

    public StrBuilder setNullText(String nullText) {
        if (nullText != null && nullText.isEmpty()) {
            nullText = null;
        }
        this.nullText = nullText;
        return this;
    }

    @Override
    public int length() {
        return this.size;
    }

    public StrBuilder setLength(int length2) {
        if (length2 < 0) {
            throw new StringIndexOutOfBoundsException(length2);
        }
        if (length2 < this.size) {
            this.size = length2;
        } else if (length2 > this.size) {
            this.ensureCapacity(length2);
            int oldEnd = this.size;
            int newEnd = length2;
            this.size = length2;
            for (int i2 = oldEnd; i2 < newEnd; ++i2) {
                this.buffer[i2] = '\u0000';
            }
        }
        return this;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public StrBuilder ensureCapacity(int capacity) {
        if (capacity > this.buffer.length) {
            char[] old = this.buffer;
            this.buffer = new char[capacity * 2];
            System.arraycopy(old, 0, this.buffer, 0, this.size);
        }
        return this;
    }

    public StrBuilder minimizeCapacity() {
        if (this.buffer.length > this.length()) {
            char[] old = this.buffer;
            this.buffer = new char[this.length()];
            System.arraycopy(old, 0, this.buffer, 0, this.size);
        }
        return this;
    }

    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public StrBuilder clear() {
        this.size = 0;
        return this;
    }

    @Override
    public char charAt(int index2) {
        if (index2 < 0 || index2 >= this.length()) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        return this.buffer[index2];
    }

    public StrBuilder setCharAt(int index2, char ch) {
        if (index2 < 0 || index2 >= this.length()) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        this.buffer[index2] = ch;
        return this;
    }

    public StrBuilder deleteCharAt(int index2) {
        if (index2 < 0 || index2 >= this.size) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        this.deleteImpl(index2, index2 + 1, 1);
        return this;
    }

    public char[] toCharArray() {
        if (this.size == 0) {
            return ArrayUtils.EMPTY_CHAR_ARRAY;
        }
        char[] chars2 = new char[this.size];
        System.arraycopy(this.buffer, 0, chars2, 0, this.size);
        return chars2;
    }

    public char[] toCharArray(int startIndex, int endIndex) {
        int len = (endIndex = this.validateRange(startIndex, endIndex)) - startIndex;
        if (len == 0) {
            return ArrayUtils.EMPTY_CHAR_ARRAY;
        }
        char[] chars2 = new char[len];
        System.arraycopy(this.buffer, startIndex, chars2, 0, len);
        return chars2;
    }

    public char[] getChars(char[] destination) {
        int len = this.length();
        if (destination == null || destination.length < len) {
            destination = new char[len];
        }
        System.arraycopy(this.buffer, 0, destination, 0, len);
        return destination;
    }

    public void getChars(int startIndex, int endIndex, char[] destination, int destinationIndex) {
        if (startIndex < 0) {
            throw new StringIndexOutOfBoundsException(startIndex);
        }
        if (endIndex < 0 || endIndex > this.length()) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        if (startIndex > endIndex) {
            throw new StringIndexOutOfBoundsException("end < start");
        }
        System.arraycopy(this.buffer, startIndex, destination, destinationIndex, endIndex - startIndex);
    }

    public int readFrom(Readable readable) throws IOException {
        int oldSize = this.size;
        if (readable instanceof Reader) {
            int read2;
            Reader r = (Reader)readable;
            this.ensureCapacity(this.size + 1);
            while ((read2 = r.read(this.buffer, this.size, this.buffer.length - this.size)) != -1) {
                this.size += read2;
                this.ensureCapacity(this.size + 1);
            }
        } else if (readable instanceof CharBuffer) {
            CharBuffer cb = (CharBuffer)readable;
            int remaining = cb.remaining();
            this.ensureCapacity(this.size + remaining);
            cb.get(this.buffer, this.size, remaining);
            this.size += remaining;
        } else {
            while (true) {
                this.ensureCapacity(this.size + 1);
                CharBuffer buf = CharBuffer.wrap(this.buffer, this.size, this.buffer.length - this.size);
                int read3 = readable.read(buf);
                if (read3 == -1) break;
                this.size += read3;
            }
        }
        return this.size - oldSize;
    }

    public StrBuilder appendNewLine() {
        if (this.newLine == null) {
            this.append(System.lineSeparator());
            return this;
        }
        return this.append(this.newLine);
    }

    public StrBuilder appendNull() {
        if (this.nullText == null) {
            return this;
        }
        return this.append(this.nullText);
    }

    public StrBuilder append(Object obj) {
        if (obj == null) {
            return this.appendNull();
        }
        if (obj instanceof CharSequence) {
            return this.append((CharSequence)obj);
        }
        return this.append(obj.toString());
    }

    @Override
    public StrBuilder append(CharSequence seq) {
        if (seq == null) {
            return this.appendNull();
        }
        if (seq instanceof StrBuilder) {
            return this.append((StrBuilder)seq);
        }
        if (seq instanceof StringBuilder) {
            return this.append((StringBuilder)seq);
        }
        if (seq instanceof StringBuffer) {
            return this.append((StringBuffer)seq);
        }
        if (seq instanceof CharBuffer) {
            return this.append((CharBuffer)seq);
        }
        return this.append(seq.toString());
    }

    @Override
    public StrBuilder append(CharSequence seq, int startIndex, int length2) {
        if (seq == null) {
            return this.appendNull();
        }
        return this.append(seq.toString(), startIndex, length2);
    }

    public StrBuilder append(String str) {
        if (str == null) {
            return this.appendNull();
        }
        int strLen = str.length();
        if (strLen > 0) {
            int len = this.length();
            this.ensureCapacity(len + strLen);
            str.getChars(0, strLen, this.buffer, len);
            this.size += strLen;
        }
        return this;
    }

    public StrBuilder append(String str, int startIndex, int length2) {
        if (str == null) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > str.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (length2 < 0 || startIndex + length2 > str.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (length2 > 0) {
            int len = this.length();
            this.ensureCapacity(len + length2);
            str.getChars(startIndex, startIndex + length2, this.buffer, len);
            this.size += length2;
        }
        return this;
    }

    public StrBuilder append(String format, Object ... objs) {
        return this.append(String.format(format, objs));
    }

    public StrBuilder append(CharBuffer buf) {
        if (buf == null) {
            return this.appendNull();
        }
        if (buf.hasArray()) {
            int length2 = buf.remaining();
            int len = this.length();
            this.ensureCapacity(len + length2);
            System.arraycopy(buf.array(), buf.arrayOffset() + buf.position(), this.buffer, len, length2);
            this.size += length2;
        } else {
            this.append(buf.toString());
        }
        return this;
    }

    public StrBuilder append(CharBuffer buf, int startIndex, int length2) {
        if (buf == null) {
            return this.appendNull();
        }
        if (buf.hasArray()) {
            int totalLength = buf.remaining();
            if (startIndex < 0 || startIndex > totalLength) {
                throw new StringIndexOutOfBoundsException("startIndex must be valid");
            }
            if (length2 < 0 || startIndex + length2 > totalLength) {
                throw new StringIndexOutOfBoundsException("length must be valid");
            }
            int len = this.length();
            this.ensureCapacity(len + length2);
            System.arraycopy(buf.array(), buf.arrayOffset() + buf.position() + startIndex, this.buffer, len, length2);
            this.size += length2;
        } else {
            this.append(buf.toString(), startIndex, length2);
        }
        return this;
    }

    public StrBuilder append(StringBuffer str) {
        if (str == null) {
            return this.appendNull();
        }
        int strLen = str.length();
        if (strLen > 0) {
            int len = this.length();
            this.ensureCapacity(len + strLen);
            str.getChars(0, strLen, this.buffer, len);
            this.size += strLen;
        }
        return this;
    }

    public StrBuilder append(StringBuffer str, int startIndex, int length2) {
        if (str == null) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > str.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (length2 < 0 || startIndex + length2 > str.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (length2 > 0) {
            int len = this.length();
            this.ensureCapacity(len + length2);
            str.getChars(startIndex, startIndex + length2, this.buffer, len);
            this.size += length2;
        }
        return this;
    }

    public StrBuilder append(StringBuilder str) {
        if (str == null) {
            return this.appendNull();
        }
        int strLen = str.length();
        if (strLen > 0) {
            int len = this.length();
            this.ensureCapacity(len + strLen);
            str.getChars(0, strLen, this.buffer, len);
            this.size += strLen;
        }
        return this;
    }

    public StrBuilder append(StringBuilder str, int startIndex, int length2) {
        if (str == null) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > str.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (length2 < 0 || startIndex + length2 > str.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (length2 > 0) {
            int len = this.length();
            this.ensureCapacity(len + length2);
            str.getChars(startIndex, startIndex + length2, this.buffer, len);
            this.size += length2;
        }
        return this;
    }

    public StrBuilder append(StrBuilder str) {
        if (str == null) {
            return this.appendNull();
        }
        int strLen = str.length();
        if (strLen > 0) {
            int len = this.length();
            this.ensureCapacity(len + strLen);
            System.arraycopy(str.buffer, 0, this.buffer, len, strLen);
            this.size += strLen;
        }
        return this;
    }

    public StrBuilder append(StrBuilder str, int startIndex, int length2) {
        if (str == null) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > str.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (length2 < 0 || startIndex + length2 > str.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (length2 > 0) {
            int len = this.length();
            this.ensureCapacity(len + length2);
            str.getChars(startIndex, startIndex + length2, this.buffer, len);
            this.size += length2;
        }
        return this;
    }

    public StrBuilder append(char[] chars2) {
        if (chars2 == null) {
            return this.appendNull();
        }
        int strLen = chars2.length;
        if (strLen > 0) {
            int len = this.length();
            this.ensureCapacity(len + strLen);
            System.arraycopy(chars2, 0, this.buffer, len, strLen);
            this.size += strLen;
        }
        return this;
    }

    public StrBuilder append(char[] chars2, int startIndex, int length2) {
        if (chars2 == null) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > chars2.length) {
            throw new StringIndexOutOfBoundsException("Invalid startIndex: " + length2);
        }
        if (length2 < 0 || startIndex + length2 > chars2.length) {
            throw new StringIndexOutOfBoundsException("Invalid length: " + length2);
        }
        if (length2 > 0) {
            int len = this.length();
            this.ensureCapacity(len + length2);
            System.arraycopy(chars2, startIndex, this.buffer, len, length2);
            this.size += length2;
        }
        return this;
    }

    public StrBuilder append(boolean value2) {
        if (value2) {
            this.ensureCapacity(this.size + 4);
            this.buffer[this.size++] = 116;
            this.buffer[this.size++] = 114;
            this.buffer[this.size++] = 117;
            this.buffer[this.size++] = 101;
        } else {
            this.ensureCapacity(this.size + 5);
            this.buffer[this.size++] = 102;
            this.buffer[this.size++] = 97;
            this.buffer[this.size++] = 108;
            this.buffer[this.size++] = 115;
            this.buffer[this.size++] = 101;
        }
        return this;
    }

    @Override
    public StrBuilder append(char ch) {
        int len = this.length();
        this.ensureCapacity(len + 1);
        this.buffer[this.size++] = ch;
        return this;
    }

    public StrBuilder append(int value2) {
        return this.append(String.valueOf(value2));
    }

    public StrBuilder append(long value2) {
        return this.append(String.valueOf(value2));
    }

    public StrBuilder append(float value2) {
        return this.append(String.valueOf(value2));
    }

    public StrBuilder append(double value2) {
        return this.append(String.valueOf(value2));
    }

    public StrBuilder appendln(Object obj) {
        return this.append(obj).appendNewLine();
    }

    public StrBuilder appendln(String str) {
        return this.append(str).appendNewLine();
    }

    public StrBuilder appendln(String str, int startIndex, int length2) {
        return this.append(str, startIndex, length2).appendNewLine();
    }

    public StrBuilder appendln(String format, Object ... objs) {
        return this.append(format, objs).appendNewLine();
    }

    public StrBuilder appendln(StringBuffer str) {
        return this.append(str).appendNewLine();
    }

    public StrBuilder appendln(StringBuilder str) {
        return this.append(str).appendNewLine();
    }

    public StrBuilder appendln(StringBuilder str, int startIndex, int length2) {
        return this.append(str, startIndex, length2).appendNewLine();
    }

    public StrBuilder appendln(StringBuffer str, int startIndex, int length2) {
        return this.append(str, startIndex, length2).appendNewLine();
    }

    public StrBuilder appendln(StrBuilder str) {
        return this.append(str).appendNewLine();
    }

    public StrBuilder appendln(StrBuilder str, int startIndex, int length2) {
        return this.append(str, startIndex, length2).appendNewLine();
    }

    public StrBuilder appendln(char[] chars2) {
        return this.append(chars2).appendNewLine();
    }

    public StrBuilder appendln(char[] chars2, int startIndex, int length2) {
        return this.append(chars2, startIndex, length2).appendNewLine();
    }

    public StrBuilder appendln(boolean value2) {
        return this.append(value2).appendNewLine();
    }

    public StrBuilder appendln(char ch) {
        return this.append(ch).appendNewLine();
    }

    public StrBuilder appendln(int value2) {
        return this.append(value2).appendNewLine();
    }

    public StrBuilder appendln(long value2) {
        return this.append(value2).appendNewLine();
    }

    public StrBuilder appendln(float value2) {
        return this.append(value2).appendNewLine();
    }

    public StrBuilder appendln(double value2) {
        return this.append(value2).appendNewLine();
    }

    public <T> StrBuilder appendAll(T ... array2) {
        if (ArrayUtils.isNotEmpty(array2)) {
            for (T element : array2) {
                this.append(element);
            }
        }
        return this;
    }

    public StrBuilder appendAll(Iterable<?> iterable) {
        if (iterable != null) {
            for (Object o : iterable) {
                this.append(o);
            }
        }
        return this;
    }

    public StrBuilder appendAll(Iterator<?> it) {
        if (it != null) {
            while (it.hasNext()) {
                this.append(it.next());
            }
        }
        return this;
    }

    public StrBuilder appendWithSeparators(Object[] array2, String separator) {
        if (array2 != null && array2.length > 0) {
            String sep = Objects.toString(separator, "");
            this.append(array2[0]);
            for (int i2 = 1; i2 < array2.length; ++i2) {
                this.append(sep);
                this.append(array2[i2]);
            }
        }
        return this;
    }

    public StrBuilder appendWithSeparators(Iterable<?> iterable, String separator) {
        if (iterable != null) {
            String sep = Objects.toString(separator, "");
            Iterator<?> it = iterable.iterator();
            while (it.hasNext()) {
                this.append(it.next());
                if (!it.hasNext()) continue;
                this.append(sep);
            }
        }
        return this;
    }

    public StrBuilder appendWithSeparators(Iterator<?> it, String separator) {
        if (it != null) {
            String sep = Objects.toString(separator, "");
            while (it.hasNext()) {
                this.append(it.next());
                if (!it.hasNext()) continue;
                this.append(sep);
            }
        }
        return this;
    }

    public StrBuilder appendSeparator(String separator) {
        return this.appendSeparator(separator, null);
    }

    public StrBuilder appendSeparator(String standard, String defaultIfEmpty) {
        String str;
        String string2 = str = this.isEmpty() ? defaultIfEmpty : standard;
        if (str != null) {
            this.append(str);
        }
        return this;
    }

    public StrBuilder appendSeparator(char separator) {
        if (this.size() > 0) {
            this.append(separator);
        }
        return this;
    }

    public StrBuilder appendSeparator(char standard, char defaultIfEmpty) {
        if (this.size() > 0) {
            this.append(standard);
        } else {
            this.append(defaultIfEmpty);
        }
        return this;
    }

    public StrBuilder appendSeparator(String separator, int loopIndex) {
        if (separator != null && loopIndex > 0) {
            this.append(separator);
        }
        return this;
    }

    public StrBuilder appendSeparator(char separator, int loopIndex) {
        if (loopIndex > 0) {
            this.append(separator);
        }
        return this;
    }

    public StrBuilder appendPadding(int length2, char padChar) {
        if (length2 >= 0) {
            this.ensureCapacity(this.size + length2);
            for (int i2 = 0; i2 < length2; ++i2) {
                this.buffer[this.size++] = padChar;
            }
        }
        return this;
    }

    public StrBuilder appendFixedWidthPadLeft(Object obj, int width, char padChar) {
        if (width > 0) {
            int strLen;
            String str;
            this.ensureCapacity(this.size + width);
            String string2 = str = obj == null ? this.getNullText() : obj.toString();
            if (str == null) {
                str = "";
            }
            if ((strLen = str.length()) >= width) {
                str.getChars(strLen - width, strLen, this.buffer, this.size);
            } else {
                int padLen = width - strLen;
                for (int i2 = 0; i2 < padLen; ++i2) {
                    this.buffer[this.size + i2] = padChar;
                }
                str.getChars(0, strLen, this.buffer, this.size + padLen);
            }
            this.size += width;
        }
        return this;
    }

    public StrBuilder appendFixedWidthPadLeft(int value2, int width, char padChar) {
        return this.appendFixedWidthPadLeft(String.valueOf(value2), width, padChar);
    }

    public StrBuilder appendFixedWidthPadRight(Object obj, int width, char padChar) {
        if (width > 0) {
            int strLen;
            String str;
            this.ensureCapacity(this.size + width);
            String string2 = str = obj == null ? this.getNullText() : obj.toString();
            if (str == null) {
                str = "";
            }
            if ((strLen = str.length()) >= width) {
                str.getChars(0, width, this.buffer, this.size);
            } else {
                int padLen = width - strLen;
                str.getChars(0, strLen, this.buffer, this.size);
                for (int i2 = 0; i2 < padLen; ++i2) {
                    this.buffer[this.size + strLen + i2] = padChar;
                }
            }
            this.size += width;
        }
        return this;
    }

    public StrBuilder appendFixedWidthPadRight(int value2, int width, char padChar) {
        return this.appendFixedWidthPadRight(String.valueOf(value2), width, padChar);
    }

    public StrBuilder insert(int index2, Object obj) {
        if (obj == null) {
            return this.insert(index2, this.nullText);
        }
        return this.insert(index2, obj.toString());
    }

    public StrBuilder insert(int index2, String str) {
        int strLen;
        this.validateIndex(index2);
        if (str == null) {
            str = this.nullText;
        }
        if (str != null && (strLen = str.length()) > 0) {
            int newSize = this.size + strLen;
            this.ensureCapacity(newSize);
            System.arraycopy(this.buffer, index2, this.buffer, index2 + strLen, this.size - index2);
            this.size = newSize;
            str.getChars(0, strLen, this.buffer, index2);
        }
        return this;
    }

    public StrBuilder insert(int index2, char[] chars2) {
        this.validateIndex(index2);
        if (chars2 == null) {
            return this.insert(index2, this.nullText);
        }
        int len = chars2.length;
        if (len > 0) {
            this.ensureCapacity(this.size + len);
            System.arraycopy(this.buffer, index2, this.buffer, index2 + len, this.size - index2);
            System.arraycopy(chars2, 0, this.buffer, index2, len);
            this.size += len;
        }
        return this;
    }

    public StrBuilder insert(int index2, char[] chars2, int offset2, int length2) {
        this.validateIndex(index2);
        if (chars2 == null) {
            return this.insert(index2, this.nullText);
        }
        if (offset2 < 0 || offset2 > chars2.length) {
            throw new StringIndexOutOfBoundsException("Invalid offset: " + offset2);
        }
        if (length2 < 0 || offset2 + length2 > chars2.length) {
            throw new StringIndexOutOfBoundsException("Invalid length: " + length2);
        }
        if (length2 > 0) {
            this.ensureCapacity(this.size + length2);
            System.arraycopy(this.buffer, index2, this.buffer, index2 + length2, this.size - index2);
            System.arraycopy(chars2, offset2, this.buffer, index2, length2);
            this.size += length2;
        }
        return this;
    }

    public StrBuilder insert(int index2, boolean value2) {
        this.validateIndex(index2);
        if (value2) {
            this.ensureCapacity(this.size + 4);
            System.arraycopy(this.buffer, index2, this.buffer, index2 + 4, this.size - index2);
            this.buffer[index2++] = 116;
            this.buffer[index2++] = 114;
            this.buffer[index2++] = 117;
            this.buffer[index2] = 101;
            this.size += 4;
        } else {
            this.ensureCapacity(this.size + 5);
            System.arraycopy(this.buffer, index2, this.buffer, index2 + 5, this.size - index2);
            this.buffer[index2++] = 102;
            this.buffer[index2++] = 97;
            this.buffer[index2++] = 108;
            this.buffer[index2++] = 115;
            this.buffer[index2] = 101;
            this.size += 5;
        }
        return this;
    }

    public StrBuilder insert(int index2, char value2) {
        this.validateIndex(index2);
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.buffer, index2, this.buffer, index2 + 1, this.size - index2);
        this.buffer[index2] = value2;
        ++this.size;
        return this;
    }

    public StrBuilder insert(int index2, int value2) {
        return this.insert(index2, String.valueOf(value2));
    }

    public StrBuilder insert(int index2, long value2) {
        return this.insert(index2, String.valueOf(value2));
    }

    public StrBuilder insert(int index2, float value2) {
        return this.insert(index2, String.valueOf(value2));
    }

    public StrBuilder insert(int index2, double value2) {
        return this.insert(index2, String.valueOf(value2));
    }

    private void deleteImpl(int startIndex, int endIndex, int len) {
        System.arraycopy(this.buffer, endIndex, this.buffer, startIndex, this.size - endIndex);
        this.size -= len;
    }

    public StrBuilder delete(int startIndex, int endIndex) {
        int len = (endIndex = this.validateRange(startIndex, endIndex)) - startIndex;
        if (len > 0) {
            this.deleteImpl(startIndex, endIndex, len);
        }
        return this;
    }

    public StrBuilder deleteAll(char ch) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.buffer[i2] != ch) continue;
            int start2 = i2;
            while (++i2 < this.size && this.buffer[i2] == ch) {
            }
            int len = i2 - start2;
            this.deleteImpl(start2, i2, len);
            i2 -= len;
        }
        return this;
    }

    public StrBuilder deleteFirst(char ch) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.buffer[i2] != ch) continue;
            this.deleteImpl(i2, i2 + 1, 1);
            break;
        }
        return this;
    }

    public StrBuilder deleteAll(String str) {
        int len;
        int n = len = str == null ? 0 : str.length();
        if (len > 0) {
            int index2 = this.indexOf(str, 0);
            while (index2 >= 0) {
                this.deleteImpl(index2, index2 + len, len);
                index2 = this.indexOf(str, index2);
            }
        }
        return this;
    }

    public StrBuilder deleteFirst(String str) {
        int index2;
        int len;
        int n = len = str == null ? 0 : str.length();
        if (len > 0 && (index2 = this.indexOf(str, 0)) >= 0) {
            this.deleteImpl(index2, index2 + len, len);
        }
        return this;
    }

    public StrBuilder deleteAll(StrMatcher matcher) {
        return this.replace(matcher, null, 0, this.size, -1);
    }

    public StrBuilder deleteFirst(StrMatcher matcher) {
        return this.replace(matcher, null, 0, this.size, 1);
    }

    private void replaceImpl(int startIndex, int endIndex, int removeLen, String insertStr, int insertLen) {
        int newSize = this.size - removeLen + insertLen;
        if (insertLen != removeLen) {
            this.ensureCapacity(newSize);
            System.arraycopy(this.buffer, endIndex, this.buffer, startIndex + insertLen, this.size - endIndex);
            this.size = newSize;
        }
        if (insertLen > 0) {
            insertStr.getChars(0, insertLen, this.buffer, startIndex);
        }
    }

    public StrBuilder replace(int startIndex, int endIndex, String replaceStr) {
        endIndex = this.validateRange(startIndex, endIndex);
        int insertLen = replaceStr == null ? 0 : replaceStr.length();
        this.replaceImpl(startIndex, endIndex, endIndex - startIndex, replaceStr, insertLen);
        return this;
    }

    public StrBuilder replaceAll(char search, char replace2) {
        if (search != replace2) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (this.buffer[i2] != search) continue;
                this.buffer[i2] = replace2;
            }
        }
        return this;
    }

    public StrBuilder replaceFirst(char search, char replace2) {
        if (search != replace2) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (this.buffer[i2] != search) continue;
                this.buffer[i2] = replace2;
                break;
            }
        }
        return this;
    }

    public StrBuilder replaceAll(String searchStr, String replaceStr) {
        int searchLen;
        int n = searchLen = searchStr == null ? 0 : searchStr.length();
        if (searchLen > 0) {
            int replaceLen = replaceStr == null ? 0 : replaceStr.length();
            int index2 = this.indexOf(searchStr, 0);
            while (index2 >= 0) {
                this.replaceImpl(index2, index2 + searchLen, searchLen, replaceStr, replaceLen);
                index2 = this.indexOf(searchStr, index2 + replaceLen);
            }
        }
        return this;
    }

    public StrBuilder replaceFirst(String searchStr, String replaceStr) {
        int index2;
        int searchLen;
        int n = searchLen = searchStr == null ? 0 : searchStr.length();
        if (searchLen > 0 && (index2 = this.indexOf(searchStr, 0)) >= 0) {
            int replaceLen = replaceStr == null ? 0 : replaceStr.length();
            this.replaceImpl(index2, index2 + searchLen, searchLen, replaceStr, replaceLen);
        }
        return this;
    }

    public StrBuilder replaceAll(StrMatcher matcher, String replaceStr) {
        return this.replace(matcher, replaceStr, 0, this.size, -1);
    }

    public StrBuilder replaceFirst(StrMatcher matcher, String replaceStr) {
        return this.replace(matcher, replaceStr, 0, this.size, 1);
    }

    public StrBuilder replace(StrMatcher matcher, String replaceStr, int startIndex, int endIndex, int replaceCount) {
        endIndex = this.validateRange(startIndex, endIndex);
        return this.replaceImpl(matcher, replaceStr, startIndex, endIndex, replaceCount);
    }

    private StrBuilder replaceImpl(StrMatcher matcher, String replaceStr, int from, int to, int replaceCount) {
        if (matcher == null || this.size == 0) {
            return this;
        }
        int replaceLen = replaceStr == null ? 0 : replaceStr.length();
        for (int i2 = from; i2 < to && replaceCount != 0; ++i2) {
            char[] buf = this.buffer;
            int removeLen = matcher.isMatch(buf, i2, from, to);
            if (removeLen <= 0) continue;
            this.replaceImpl(i2, i2 + removeLen, removeLen, replaceStr, replaceLen);
            to = to - removeLen + replaceLen;
            i2 = i2 + replaceLen - 1;
            if (replaceCount <= 0) continue;
            --replaceCount;
        }
        return this;
    }

    public StrBuilder reverse() {
        if (this.size == 0) {
            return this;
        }
        int half = this.size / 2;
        char[] buf = this.buffer;
        int leftIdx = 0;
        int rightIdx = this.size - 1;
        while (leftIdx < half) {
            char swap = buf[leftIdx];
            buf[leftIdx] = buf[rightIdx];
            buf[rightIdx] = swap;
            ++leftIdx;
            --rightIdx;
        }
        return this;
    }

    public StrBuilder trim() {
        int pos2;
        if (this.size == 0) {
            return this;
        }
        int len = this.size;
        char[] buf = this.buffer;
        for (pos2 = 0; pos2 < len && buf[pos2] <= ' '; ++pos2) {
        }
        while (pos2 < len && buf[len - 1] <= ' ') {
            --len;
        }
        if (len < this.size) {
            this.delete(len, this.size);
        }
        if (pos2 > 0) {
            this.delete(0, pos2);
        }
        return this;
    }

    public boolean startsWith(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len == 0) {
            return true;
        }
        if (len > this.size) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (this.buffer[i2] == str.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len == 0) {
            return true;
        }
        if (len > this.size) {
            return false;
        }
        int pos2 = this.size - len;
        int i2 = 0;
        while (i2 < len) {
            if (this.buffer[pos2] != str.charAt(i2)) {
                return false;
            }
            ++i2;
            ++pos2;
        }
        return true;
    }

    @Override
    public CharSequence subSequence(int startIndex, int endIndex) {
        if (startIndex < 0) {
            throw new StringIndexOutOfBoundsException(startIndex);
        }
        if (endIndex > this.size) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        if (startIndex > endIndex) {
            throw new StringIndexOutOfBoundsException(endIndex - startIndex);
        }
        return this.substring(startIndex, endIndex);
    }

    public String substring(int start2) {
        return this.substring(start2, this.size);
    }

    public String substring(int startIndex, int endIndex) {
        endIndex = this.validateRange(startIndex, endIndex);
        return new String(this.buffer, startIndex, endIndex - startIndex);
    }

    public String leftString(int length2) {
        if (length2 <= 0) {
            return "";
        }
        if (length2 >= this.size) {
            return new String(this.buffer, 0, this.size);
        }
        return new String(this.buffer, 0, length2);
    }

    public String rightString(int length2) {
        if (length2 <= 0) {
            return "";
        }
        if (length2 >= this.size) {
            return new String(this.buffer, 0, this.size);
        }
        return new String(this.buffer, this.size - length2, length2);
    }

    public String midString(int index2, int length2) {
        if (index2 < 0) {
            index2 = 0;
        }
        if (length2 <= 0 || index2 >= this.size) {
            return "";
        }
        if (this.size <= index2 + length2) {
            return new String(this.buffer, index2, this.size - index2);
        }
        return new String(this.buffer, index2, length2);
    }

    public boolean contains(char ch) {
        char[] thisBuf = this.buffer;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (thisBuf[i2] != ch) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String str) {
        return this.indexOf(str, 0) >= 0;
    }

    public boolean contains(StrMatcher matcher) {
        return this.indexOf(matcher, 0) >= 0;
    }

    public int indexOf(char ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(char ch, int startIndex) {
        if ((startIndex = Math.max(startIndex, 0)) >= this.size) {
            return -1;
        }
        char[] thisBuf = this.buffer;
        for (int i2 = startIndex; i2 < this.size; ++i2) {
            if (thisBuf[i2] != ch) continue;
            return i2;
        }
        return -1;
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int startIndex) {
        startIndex = Math.max(startIndex, 0);
        if (str == null || startIndex >= this.size) {
            return -1;
        }
        int strLen = str.length();
        if (strLen == 1) {
            return this.indexOf(str.charAt(0), startIndex);
        }
        if (strLen == 0) {
            return startIndex;
        }
        if (strLen > this.size) {
            return -1;
        }
        char[] thisBuf = this.buffer;
        int len = this.size - strLen + 1;
        block0: for (int i2 = startIndex; i2 < len; ++i2) {
            for (int j = 0; j < strLen; ++j) {
                if (str.charAt(j) != thisBuf[i2 + j]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public int indexOf(StrMatcher matcher) {
        return this.indexOf(matcher, 0);
    }

    public int indexOf(StrMatcher matcher, int startIndex) {
        startIndex = Math.max(startIndex, 0);
        if (matcher == null || startIndex >= this.size) {
            return -1;
        }
        int len = this.size;
        char[] buf = this.buffer;
        for (int i2 = startIndex; i2 < len; ++i2) {
            if (matcher.isMatch(buf, i2, startIndex, len) <= 0) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(char ch) {
        return this.lastIndexOf(ch, this.size - 1);
    }

    public int lastIndexOf(char ch, int startIndex) {
        int n = startIndex = startIndex >= this.size ? this.size - 1 : startIndex;
        if (startIndex < 0) {
            return -1;
        }
        for (int i2 = startIndex; i2 >= 0; --i2) {
            if (this.buffer[i2] != ch) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.size - 1);
    }

    public int lastIndexOf(String str, int startIndex) {
        int n = startIndex = startIndex >= this.size ? this.size - 1 : startIndex;
        if (str == null || startIndex < 0) {
            return -1;
        }
        int strLen = str.length();
        if (strLen > 0 && strLen <= this.size) {
            if (strLen == 1) {
                return this.lastIndexOf(str.charAt(0), startIndex);
            }
            block0: for (int i2 = startIndex - strLen + 1; i2 >= 0; --i2) {
                for (int j = 0; j < strLen; ++j) {
                    if (str.charAt(j) != this.buffer[i2 + j]) continue block0;
                }
                return i2;
            }
        } else if (strLen == 0) {
            return startIndex;
        }
        return -1;
    }

    public int lastIndexOf(StrMatcher matcher) {
        return this.lastIndexOf(matcher, this.size);
    }

    public int lastIndexOf(StrMatcher matcher, int startIndex) {
        int n = startIndex = startIndex >= this.size ? this.size - 1 : startIndex;
        if (matcher == null || startIndex < 0) {
            return -1;
        }
        char[] buf = this.buffer;
        int endIndex = startIndex + 1;
        for (int i2 = startIndex; i2 >= 0; --i2) {
            if (matcher.isMatch(buf, i2, 0, endIndex) <= 0) continue;
            return i2;
        }
        return -1;
    }

    public StrTokenizer asTokenizer() {
        return new StrBuilderTokenizer();
    }

    public Reader asReader() {
        return new StrBuilderReader();
    }

    public Writer asWriter() {
        return new StrBuilderWriter();
    }

    public void appendTo(Appendable appendable) throws IOException {
        if (appendable instanceof Writer) {
            ((Writer)appendable).write(this.buffer, 0, this.size);
        } else if (appendable instanceof StringBuilder) {
            ((StringBuilder)appendable).append(this.buffer, 0, this.size);
        } else if (appendable instanceof StringBuffer) {
            ((StringBuffer)appendable).append(this.buffer, 0, this.size);
        } else if (appendable instanceof CharBuffer) {
            ((CharBuffer)appendable).put(this.buffer, 0, this.size);
        } else {
            appendable.append(this);
        }
    }

    public boolean equalsIgnoreCase(StrBuilder other) {
        if (this == other) {
            return true;
        }
        if (this.size != other.size) {
            return false;
        }
        char[] thisBuf = this.buffer;
        char[] otherBuf = other.buffer;
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            char c1 = thisBuf[i2];
            char c2 = otherBuf[i2];
            if (c1 == c2 || Character.toUpperCase(c1) == Character.toUpperCase(c2)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(StrBuilder other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        char[] thisBuf = this.buffer;
        char[] otherBuf = other.buffer;
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            if (thisBuf[i2] == otherBuf[i2]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        return obj instanceof StrBuilder && this.equals((StrBuilder)obj);
    }

    public int hashCode() {
        char[] buf = this.buffer;
        int hash2 = 0;
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            hash2 = 31 * hash2 + buf[i2];
        }
        return hash2;
    }

    @Override
    public String toString() {
        return new String(this.buffer, 0, this.size);
    }

    public StringBuffer toStringBuffer() {
        return new StringBuffer(this.size).append(this.buffer, 0, this.size);
    }

    public StringBuilder toStringBuilder() {
        return new StringBuilder(this.size).append(this.buffer, 0, this.size);
    }

    @Override
    public String build() {
        return this.toString();
    }

    protected int validateRange(int startIndex, int endIndex) {
        if (startIndex < 0) {
            throw new StringIndexOutOfBoundsException(startIndex);
        }
        if (endIndex > this.size) {
            endIndex = this.size;
        }
        if (startIndex > endIndex) {
            throw new StringIndexOutOfBoundsException("end < start");
        }
        return endIndex;
    }

    protected void validateIndex(int index2) {
        if (index2 < 0 || index2 > this.size) {
            throw new StringIndexOutOfBoundsException(index2);
        }
    }

    class StrBuilderWriter
    extends Writer {
        StrBuilderWriter() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(int c) {
            StrBuilder.this.append((char)c);
        }

        @Override
        public void write(char[] cbuf) {
            StrBuilder.this.append(cbuf);
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            StrBuilder.this.append(cbuf, off, len);
        }

        @Override
        public void write(String str) {
            StrBuilder.this.append(str);
        }

        @Override
        public void write(String str, int off, int len) {
            StrBuilder.this.append(str, off, len);
        }
    }

    class StrBuilderReader
    extends Reader {
        private int pos;
        private int mark;

        StrBuilderReader() {
        }

        @Override
        public void close() {
        }

        @Override
        public int read() {
            if (!this.ready()) {
                return -1;
            }
            return StrBuilder.this.charAt(this.pos++);
        }

        @Override
        public int read(char[] b2, int off, int len) {
            if (off < 0 || len < 0 || off > b2.length || off + len > b2.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.pos >= StrBuilder.this.size()) {
                return -1;
            }
            if (this.pos + len > StrBuilder.this.size()) {
                len = StrBuilder.this.size() - this.pos;
            }
            StrBuilder.this.getChars(this.pos, this.pos + len, b2, off);
            this.pos += len;
            return len;
        }

        @Override
        public long skip(long n) {
            if ((long)this.pos + n > (long)StrBuilder.this.size()) {
                n = StrBuilder.this.size() - this.pos;
            }
            if (n < 0L) {
                return 0L;
            }
            this.pos = (int)((long)this.pos + n);
            return n;
        }

        @Override
        public boolean ready() {
            return this.pos < StrBuilder.this.size();
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readAheadLimit) {
            this.mark = this.pos;
        }

        @Override
        public void reset() {
            this.pos = this.mark;
        }
    }

    class StrBuilderTokenizer
    extends StrTokenizer {
        StrBuilderTokenizer() {
        }

        @Override
        protected List<String> tokenize(char[] chars2, int offset2, int count2) {
            if (chars2 == null) {
                return super.tokenize(StrBuilder.this.buffer, 0, StrBuilder.this.size());
            }
            return super.tokenize(chars2, offset2, count2);
        }

        @Override
        public String getContent() {
            String str = super.getContent();
            if (str == null) {
                return StrBuilder.this.toString();
            }
            return str;
        }
    }
}

