/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.ast.impl;

import org.asciidoctor.ast.Author;
import org.jruby.RubyStruct;
import org.jruby.javasupport.JavaEmbedUtils;

public class AuthorImpl
implements Author {
    private static final String AUTHOR_KEY_NAME = "name";
    private static final String LASTNAME_KEY_NAME = "lastname";
    private static final String FIRST_NAME_KEY_NAME = "firstname";
    private static final String EMAIL_KEY_NAME = "email";
    private static final String INITIALS_KEY_NAME = "initials";
    private static final String MIDDLE_NAME_KEY_NAME = "middlename";
    private String fullName;
    private String lastName;
    private String firstName;
    private String middleName;
    private String email;
    private String initials;

    public static Author getInstance(RubyStruct authorStruct) {
        AuthorImpl author = new AuthorImpl();
        author.setFullName(AuthorImpl.aref(authorStruct, AUTHOR_KEY_NAME));
        author.setFirstName(AuthorImpl.aref(authorStruct, FIRST_NAME_KEY_NAME));
        author.setMiddleName(AuthorImpl.aref(authorStruct, MIDDLE_NAME_KEY_NAME));
        author.setLastName(AuthorImpl.aref(authorStruct, LASTNAME_KEY_NAME));
        author.setInitials(AuthorImpl.aref(authorStruct, INITIALS_KEY_NAME));
        author.setEmail(AuthorImpl.aref(authorStruct, EMAIL_KEY_NAME));
        return author;
    }

    private static String aref(RubyStruct s2, String key2) {
        return (String)JavaEmbedUtils.rubyToJava(s2.aref(s2.getRuntime().newString(key2)));
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String getInitials() {
        return this.initials;
    }

    public void setInitials(String initials) {
        this.initials = initials;
    }

    public String toString() {
        StringBuilder authorStringRepresentation = new StringBuilder();
        if (this.getFullName() != null) {
            authorStringRepresentation.append(this.getFullName());
        }
        if (this.getEmail() != null) {
            authorStringRepresentation.append(" <").append(this.getEmail()).append(">");
        }
        return authorStringRepresentation.toString();
    }
}

