/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asciidoctor.SafeMode;

public class AsciidoctorUtils {
    private static final String RUNNER = "asciidoctor";

    private AsciidoctorUtils() {
    }

    public static boolean isOptionWithAttribute(Map<String, Object> options2, String attributeName, String attributeValue) {
        String configuredAttributeValue;
        Map attributes;
        return options2.containsKey("attributes") && (attributes = (Map)options2.get("attributes")).containsKey(attributeName) && (configuredAttributeValue = (String)attributes.get(attributeName)).equals(attributeValue);
    }

    public static List<String> toAsciidoctorCommand(Map<String, Object> options2, String inputPath) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(RUNNER);
        command.addAll(AsciidoctorUtils.getOptions(options2));
        command.add(inputPath);
        return command;
    }

    private static List<String> getOptions(Map<String, Object> options2) {
        ArrayList<String> optionsAndAttributes = new ArrayList<String>();
        if (options2.containsKey("destination_dir")) {
            optionsAndAttributes.add("-D");
            optionsAndAttributes.add(options2.get("destination_dir").toString());
        }
        if (options2.containsKey("base_dir")) {
            optionsAndAttributes.add("-B");
            optionsAndAttributes.add(options2.get("base_dir").toString());
        }
        if (options2.containsKey("template_dirs")) {
            List templates = (List)options2.get("template_dirs");
            for (String template : templates) {
                optionsAndAttributes.add("-T");
                optionsAndAttributes.add(template);
            }
        }
        if (options2.containsKey("template_engine")) {
            optionsAndAttributes.add("-E");
            optionsAndAttributes.add(options2.get("template_engine").toString());
        }
        if (options2.containsKey("compact")) {
            optionsAndAttributes.add("-C");
        }
        if (options2.containsKey("eruby")) {
            optionsAndAttributes.add("-e");
            optionsAndAttributes.add(options2.get("eruby").toString());
        }
        if (options2.containsKey("header_footer")) {
            optionsAndAttributes.add("-s");
        }
        if (options2.containsKey("safe")) {
            Integer level2 = (Integer)options2.get("safe");
            SafeMode getSafeMode = SafeMode.safeMode(level2);
            optionsAndAttributes.add("-S");
            optionsAndAttributes.add(getSafeMode.toString());
        }
        if (options2.containsKey("to_file")) {
            optionsAndAttributes.add("-o");
            optionsAndAttributes.add(options2.get("to_file").toString());
        }
        if (options2.containsKey("doctype")) {
            optionsAndAttributes.add("-d");
            optionsAndAttributes.add(options2.get("doctype").toString());
        }
        if (options2.containsKey("backend")) {
            optionsAndAttributes.add("-b");
            optionsAndAttributes.add(options2.get("backend").toString());
        }
        if (options2.containsKey("attributes")) {
            optionsAndAttributes.addAll(AsciidoctorUtils.getAttributesSyntax((Map)options2.get("attributes")));
        }
        return optionsAndAttributes;
    }

    private static List<String> getAttributesSyntax(Map<String, Object> attributes) {
        ArrayList<String> attributesOutput = new ArrayList<String>();
        Set<Map.Entry<String, Object>> entrySet = attributes.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            attributesOutput.addAll(AsciidoctorUtils.getAttributeSyntax(entry.getKey(), entry.getValue()));
        }
        return attributesOutput;
    }

    private static List<String> getAttributeSyntax(String attributeName, Object attributeValue) {
        ArrayList<String> attribute = new ArrayList<String>();
        attribute.add("-a");
        StringBuilder argument = new StringBuilder(attributeName);
        if (attributeValue != null && !"".equals(attributeValue.toString().trim())) {
            argument.append("=");
            argument.append(attributeValue.toString());
        }
        if (attributeValue == null) {
            argument.append("!");
        }
        attribute.add(argument.toString());
        return attribute;
    }
}

