/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.internal;

import java.io.InputStream;
import org.asciidoctor.extension.RubyExtensionRegistry;
import org.asciidoctor.jruby.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyExtensionRegistryImpl
implements RubyExtensionRegistry {
    private Ruby rubyRuntime;

    public RubyExtensionRegistryImpl(Ruby rubyRuntime) {
        this.rubyRuntime = rubyRuntime;
    }

    @Override
    public RubyExtensionRegistryImpl requireLibrary(String requiredLibrary) {
        RubyUtils.requireLibrary(this.rubyRuntime, requiredLibrary);
        return this;
    }

    @Override
    public RubyExtensionRegistryImpl loadClass(InputStream rubyClassStream) {
        RubyUtils.loadRubyClass(this.rubyRuntime, rubyClassStream);
        return this;
    }

    @Override
    public RubyExtensionRegistryImpl preprocessor(String preprocessor) {
        this.getAsciidoctorModule().callMethod("preprocessor", (IRubyObject)this.rubyRuntime.newString(preprocessor));
        return this;
    }

    @Override
    public RubyExtensionRegistryImpl postprocessor(String postprocessor) {
        this.getAsciidoctorModule().callMethod("postprocessor", (IRubyObject)this.rubyRuntime.newString(postprocessor));
        return this;
    }

    @Override
    public RubyExtensionRegistryImpl docinfoProcessor(String docinfoProcessor) {
        this.getAsciidoctorModule().callMethod("docinfo_processor", (IRubyObject)this.rubyRuntime.newString(docinfoProcessor));
        return this;
    }

    @Override
    public RubyExtensionRegistryImpl includeProcessor(String includeProcessor) {
        this.getAsciidoctorModule().callMethod("include_processor", (IRubyObject)this.rubyRuntime.newString(includeProcessor));
        return this;
    }

    @Override
    public RubyExtensionRegistryImpl treeprocessor(String treeProcessor) {
        this.getAsciidoctorModule().callMethod("treeprocessor", (IRubyObject)this.rubyRuntime.newString(treeProcessor));
        return this;
    }

    @Override
    public RubyExtensionRegistryImpl block(String blockName, String blockProcessor) {
        this.getAsciidoctorModule().callMethod("block_processor", this.rubyRuntime.newString(blockProcessor), RubyUtils.toSymbol(this.rubyRuntime, blockName));
        return this;
    }

    @Override
    public RubyExtensionRegistryImpl block(String blockProcessor) {
        this.getAsciidoctorModule().callMethod("block_processor", (IRubyObject)this.rubyRuntime.newString(blockProcessor));
        return this;
    }

    @Override
    public RubyExtensionRegistryImpl blockMacro(String blockName, String blockMacroProcessor) {
        this.getAsciidoctorModule().callMethod("block_macro", this.rubyRuntime.newString(blockMacroProcessor), RubyUtils.toSymbol(this.rubyRuntime, blockName));
        return this;
    }

    @Override
    public RubyExtensionRegistryImpl blockMacro(String blockMacroProcessor) {
        this.getAsciidoctorModule().callMethod("block_macro", (IRubyObject)this.rubyRuntime.newString(blockMacroProcessor));
        return this;
    }

    @Override
    public RubyExtensionRegistryImpl inlineMacro(String blockName, String inlineMacroProcessor) {
        this.getAsciidoctorModule().callMethod("inline_macro", this.rubyRuntime.newString(inlineMacroProcessor), RubyUtils.toSymbol(this.rubyRuntime, blockName));
        return this;
    }

    @Override
    public RubyExtensionRegistryImpl inlineMacro(String inlineMacroProcessor) {
        this.getAsciidoctorModule().callMethod("inline_macro", (IRubyObject)this.rubyRuntime.newString(inlineMacroProcessor));
        return this;
    }

    private RubyModule getAsciidoctorModule() {
        return this.rubyRuntime.getModule("AsciidoctorModule");
    }
}

