/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.internal;

import java.io.InputStream;
import org.asciidoctor.jruby.internal.IOUtils;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubySymbol;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyUtils {
    public static <T> T rubyToJava(Ruby runtime2, IRubyObject rubyObject, Class<T> returnType) {
        return (T)JavaEmbedUtils.rubyToJava(runtime2, rubyObject, returnType);
    }

    public static RubySymbol toSymbol(Ruby rubyRuntime, String key2) {
        RubySymbol newSymbol = RubySymbol.newSymbol(rubyRuntime, key2);
        return newSymbol;
    }

    public static RubyClass toRubyClass(Ruby rubyRuntime, Class<?> rubyClass) {
        return JavaClass.get(rubyRuntime, rubyClass).getProxyClass();
    }

    public static void requireLibrary(Ruby rubyRuntime, String require2) {
        rubyRuntime.evalScriptlet(String.format("require '%s'", require2));
    }

    public static void loadRubyClass(Ruby rubyRuntime, InputStream rubyClassDefinition) {
        String script = IOUtils.readFull(rubyClassDefinition);
        rubyRuntime.evalScriptlet(script);
    }

    public static final void setGlobalVariable(Ruby rubyRuntime, String variableName, Object variableValue) {
        String script = String.format("$%s = %s", variableName, variableValue);
        rubyRuntime.evalScriptlet(script);
    }
}

