/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.formatter.qual;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public enum ConversionCategory {
    GENERAL(null, "bBhHsS"),
    CHAR(new Class[]{Character.class, Byte.class, Short.class, Integer.class}, "cC"),
    INT(new Class[]{Byte.class, Short.class, Integer.class, Long.class, BigInteger.class}, "doxX"),
    FLOAT(new Class[]{Float.class, Double.class, BigDecimal.class}, "eEfgGaA"),
    TIME(new Class[]{Long.class, Calendar.class, Date.class}, "tT"),
    CHAR_AND_INT(new Class[]{Byte.class, Short.class, Integer.class}, null),
    INT_AND_TIME(new Class[]{Long.class}, null),
    NULL(new Class[0], null),
    UNUSED(null, null);

    public final Class<?> @Nullable [] types;
    public final @Nullable String chars;

    private ConversionCategory(Class<?>[] types, String chars2) {
        this.types = types;
        this.chars = chars2;
    }

    public static ConversionCategory fromConversionChar(char c) {
        for (ConversionCategory v : new ConversionCategory[]{GENERAL, CHAR, INT, FLOAT, TIME}) {
            if (!v.chars.contains(String.valueOf(c))) continue;
            return v;
        }
        throw new IllegalArgumentException("Bad conversion character " + c);
    }

    private static <E> Set<E> arrayToSet(E[] a) {
        return new HashSet<E>(Arrays.asList(a));
    }

    public static boolean isSubsetOf(ConversionCategory a, ConversionCategory b2) {
        return ConversionCategory.intersect(a, b2) == a;
    }

    public static ConversionCategory intersect(ConversionCategory a, ConversionCategory b2) {
        if (a == UNUSED) {
            return b2;
        }
        if (b2 == UNUSED) {
            return a;
        }
        if (a == GENERAL) {
            return b2;
        }
        if (b2 == GENERAL) {
            return a;
        }
        Set<Class<Class<?>>> as = ConversionCategory.arrayToSet(a.types);
        Set<Class<?>> bs = ConversionCategory.arrayToSet(b2.types);
        as.retainAll(bs);
        for (ConversionCategory v : new ConversionCategory[]{CHAR, INT, FLOAT, TIME, CHAR_AND_INT, INT_AND_TIME, NULL}) {
            Set<Class<?>> vs = ConversionCategory.arrayToSet(v.types);
            if (!vs.equals(as)) continue;
            return v;
        }
        throw new RuntimeException();
    }

    public static ConversionCategory union(ConversionCategory a, ConversionCategory b2) {
        if (a == UNUSED || b2 == UNUSED) {
            return UNUSED;
        }
        if (a == GENERAL || b2 == GENERAL) {
            return GENERAL;
        }
        if (a == CHAR_AND_INT && b2 == INT_AND_TIME || a == INT_AND_TIME && b2 == CHAR_AND_INT) {
            return INT;
        }
        Set<Class<?>> as = ConversionCategory.arrayToSet(a.types);
        Set<Class<?>> bs = ConversionCategory.arrayToSet(b2.types);
        as.addAll(bs);
        for (ConversionCategory v : new ConversionCategory[]{NULL, CHAR_AND_INT, INT_AND_TIME, CHAR, INT, FLOAT, TIME}) {
            Set<Class<?>> vs = ConversionCategory.arrayToSet(v.types);
            if (!vs.equals(as)) continue;
            return v;
        }
        return GENERAL;
    }

    private String className(Class<?> cls) {
        if (cls == Boolean.class) {
            return "boolean";
        }
        if (cls == Character.class) {
            return "char";
        }
        if (cls == Byte.class) {
            return "byte";
        }
        if (cls == Short.class) {
            return "short";
        }
        if (cls == Integer.class) {
            return "int";
        }
        if (cls == Long.class) {
            return "long";
        }
        if (cls == Float.class) {
            return "float";
        }
        if (cls == Double.class) {
            return "double";
        }
        return cls.getSimpleName();
    }

    @Pure
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name());
        if (this != UNUSED && this != GENERAL) {
            StringJoiner sj = new StringJoiner(", ", " conversion category (one of: ", ")");
            for (Class<?> cls : this.types) {
                sj.add(this.className(cls));
            }
            sb.append(sj);
        }
        return sb.toString();
    }
}

