/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NullnessUtil {
    private NullnessUtil() {
        throw new AssertionError((Object)"shouldn't be instantiated");
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T castNonNull(@Nullable T ref) {
        assert (ref != null) : "Misuse of castNonNull: called with a null argument";
        return ref;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T castNonNull(@Nullable T ref, String message2) {
        assert (ref != null) : "Misuse of castNonNull: called with a null argument: " + message2;
        return ref;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [] castNonNullDeep(T @Nullable [] arr) {
        return NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [] castNonNullDeep(T @Nullable [] arr, String message2) {
        return NullnessUtil.castNonNullArray(arr, message2);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][] castNonNullDeep(T @Nullable [] @Nullable [] arr) {
        return (Object[][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][] castNonNullDeep(T @Nullable [] @Nullable [] arr, String message2) {
        return (Object[][])NullnessUtil.castNonNullArray(arr, message2);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] arr) {
        return (Object[][][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] arr, String message2) {
        return (Object[][][])NullnessUtil.castNonNullArray(arr, message2);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] arr) {
        return (Object[][][][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] arr, String message2) {
        return (Object[][][][])NullnessUtil.castNonNullArray(arr, message2);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] @Nullable [] arr) {
        return (Object[][][][][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] @Nullable [] arr, String message2) {
        return (Object[][][][][])NullnessUtil.castNonNullArray(arr, message2);
    }

    private static <T> @NonNull T @NonNull [] castNonNullArray(T @Nullable [] arr, @Nullable String message2) {
        assert (arr != null) : "Misuse of castNonNullArray: called with a null array argument" + (message2 == null ? "" : ": " + message2);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            assert (arr[i2] != null) : "Misuse of castNonNull: called with a null array element" + (message2 == null ? "" : ": " + message2);
            NullnessUtil.checkIfArray(arr[i2], message2);
        }
        return arr;
    }

    private static void checkIfArray(@NonNull Object ref, @Nullable String message2) {
        assert (ref != null) : "Misuse of checkIfArray: called with a null argument" + (message2 == null ? "" : ": " + message2);
        Class<?> comp = ref.getClass().getComponentType();
        if (comp != null && !comp.isPrimitive()) {
            NullnessUtil.castNonNullArray((Object[])ref, message2);
        }
    }
}

