/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.commons;

import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.ApiError;
import org.forgerock.api.models.Errors;
import org.forgerock.util.i18n.LocalizableString;

public final class CommonsApi {
    public static final ApiDescription COMMONS_API_DESCRIPTION = CommonsApi.buildCommonsApi();

    private static ApiDescription buildCommonsApi() {
        Errors.Builder commonErrors = org.forgerock.api.models.Errors.errors();
        for (Errors error2 : Errors.values()) {
            commonErrors.put(error2.camelCaseName, error2.toApiError());
        }
        return ApiDescription.apiDescription().id("frapi:common").description(CommonsApi.i18n("commonApi.description")).version("1.0.0").errors(commonErrors.build()).build();
    }

    private static LocalizableString i18n(String translationKey) {
        String value2 = "i18n:org/forgerock/api/commons/frapiCommons#" + translationKey;
        return new LocalizableString(value2, CommonsApi.class.getClassLoader());
    }

    private CommonsApi() {
    }

    public static enum Errors {
        BAD_REQUEST(400, "badRequest"),
        UNAUTHORIZED(401, "unauthorized"),
        PAYMENT_REQUIRED(402, "paymentRequired"),
        FORBIDDEN(403, "forbidden"),
        NOT_FOUND(404, "notFound"),
        METHOD_NOT_ALLOWED(405, "methodNotAllowed"),
        NOT_ACCEPTABLE(406, "notAcceptable"),
        PROXY_AUTH_REQUIRED(407, "proxyAuthRequired"),
        REQUEST_TIMEOUT(408, "requestTimeout"),
        CONFLICT(409, "conflict"),
        GONE(410, "gone"),
        LENGTH_REQUIRED(411, "lengthRequired"),
        VERSION_MISMATCH(412, "versionMismatch"),
        PRECONDITION_FAILED(412, "preconditionFailed"),
        REQUEST_ENTITY_TOO_LARGE(413, "requestEntityTooLarge"),
        REQUEST_URI_TOO_LARGE(414, "requestUriTooLarge"),
        UNSUPPORTED_MEDIA_TYPE(415, "unsupportedMediaType"),
        RANGE_NOT_SATISFIABLE(416, "rangeNotSatisfiable"),
        EXPECTATION_FAILED(417, "expectationFailed"),
        VERSION_REQUIRED(428, "versionRequired"),
        PRECONDITION_REQUIRED(428, "preconditionRequired"),
        INTERNAL_SERVER_ERROR(500, "internalServerError"),
        NOT_SUPPORTED(501, "notSupported"),
        BAD_GATEWAY(502, "badGateway"),
        UNAVAILABLE(503, "unavailable"),
        GATEWAY_TIMEOUT(504, "gatewayTimeout"),
        HTTP_VERSION_NOT_SUPPORTED(505, "httpVersionNotSupported");

        private String camelCaseName;
        private String reference;
        private int code;
        private String translationKey;

        private Errors(int errorCode, String camelCaseName) {
            this.code = errorCode;
            this.camelCaseName = camelCaseName;
            this.reference = "frapi:common#/errors/" + camelCaseName;
            this.translationKey = "error." + camelCaseName + ".description";
        }

        public String getReference() {
            return this.reference;
        }

        private ApiError toApiError() {
            return ApiError.apiError().code(this.code).description(CommonsApi.i18n(this.translationKey)).build();
        }
    }
}

