/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.validation.ValidationException;
import org.forgerock.api.enums.ReadPolicy;
import org.forgerock.api.enums.WritePolicy;
import org.forgerock.api.jackson.CrestReadWritePoliciesSchema;
import org.forgerock.api.jackson.JacksonUtils;
import org.forgerock.api.jackson.OrderedFieldSchema;
import org.forgerock.api.jackson.ValidatableSchema;
import org.forgerock.api.jackson.WithExampleSchema;
import org.forgerock.json.JsonValue;

public class CrestArraySchema
extends ArraySchema
implements CrestReadWritePoliciesSchema,
OrderedFieldSchema,
ValidatableSchema,
WithExampleSchema<List<Object>> {
    private static final JavaType EXAMPLE_VALUE_TYPE = JacksonUtils.OBJECT_MAPPER.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, Object.class);
    private WritePolicy writePolicy;
    private ReadPolicy readPolicy;
    private Boolean errorOnWritePolicyFailure;
    private Boolean returnOnDemand;
    private Integer propertyOrder;
    private List<Object> example;

    @Override
    public WritePolicy getWritePolicy() {
        return this.writePolicy;
    }

    @Override
    public void setWritePolicy(WritePolicy policy) {
        this.writePolicy = policy;
    }

    @Override
    public ReadPolicy getReadPolicy() {
        return this.readPolicy;
    }

    @Override
    public void setReadPolicy(ReadPolicy readPolicy) {
        this.readPolicy = readPolicy;
    }

    @Override
    public Boolean getErrorOnWritePolicyFailure() {
        return this.errorOnWritePolicyFailure;
    }

    @Override
    public void setErrorOnWritePolicyFailure(Boolean errorOnWritePolicyFailure) {
        this.errorOnWritePolicyFailure = errorOnWritePolicyFailure;
    }

    @Override
    public Boolean getReturnOnDemand() {
        return this.returnOnDemand;
    }

    @Override
    public void setReturnOnDemand(Boolean returnOnDemand) {
        this.returnOnDemand = returnOnDemand;
    }

    @Override
    public Integer getPropertyOrder() {
        return this.propertyOrder;
    }

    @Override
    public void setPropertyOrder(Integer order2) {
        this.propertyOrder = order2;
    }

    @Override
    public void validate(JsonValue object) throws ValidationException {
        block7: {
            block6: {
                if (!object.isCollection()) {
                    throw new ValidationException("Array expected, but got: " + object.getObject());
                }
                if (this.maxItems != null && object.size() > this.maxItems) {
                    throw new ValidationException("Array has too many items. Maximum permitted: " + this.maxItems);
                }
                if (this.minItems != null && object.size() < this.minItems) {
                    throw new ValidationException("Array has too few items. Minimum permitted: " + this.minItems);
                }
                if (!this.items.isSingleItems()) break block6;
                if (!(this.items.asSingleItems().getSchema() instanceof ValidatableSchema)) break block7;
                ValidatableSchema itemSchema = (ValidatableSchema)((Object)this.items.asSingleItems().getSchema());
                for (JsonValue item : object) {
                    itemSchema.validate(item);
                }
                break block7;
            }
            Iterator<JsonValue> arrayItems = object.iterator();
            for (JsonSchema itemSchema : this.items.asArrayItems().getJsonSchemas()) {
                if (!arrayItems.hasNext()) {
                    throw new ValidationException("Not enough items. Expecting " + itemSchema);
                }
                if (!(itemSchema instanceof ValidatableSchema)) continue;
                ((ValidatableSchema)((Object)itemSchema)).validate(arrayItems.next());
            }
        }
    }

    @Override
    public List<Object> getExample() {
        List<Object> example = this.example;
        if (example == null) {
            boolean foundExample;
            example = new ArrayList<Object>();
            boolean bl = foundExample = this.items.isSingleItems() ? this.applySingleSchemaExample(example) : this.applyMultipleSchemasExamples(example);
            if (!foundExample) {
                example = null;
            }
        }
        return example;
    }

    private boolean applySingleSchemaExample(List<Object> example) {
        Object itemsExample;
        boolean foundExample = false;
        if (this.items.asSingleItems().getSchema() instanceof WithExampleSchema && (itemsExample = ((WithExampleSchema)((Object)this.items.asSingleItems().getSchema())).getExample()) != null) {
            int count2 = this.minItems != null && this.minItems > 1 ? this.minItems : 1;
            foundExample = true;
            for (int i2 = 0; i2 < count2; ++i2) {
                example.add(itemsExample);
            }
        }
        return foundExample;
    }

    private boolean applyMultipleSchemasExamples(List<Object> example) {
        boolean foundExample = false;
        for (JsonSchema schema : this.items.asArrayItems().getJsonSchemas()) {
            if (!(schema instanceof WithExampleSchema)) continue;
            Object propertyExample = ((WithExampleSchema)((Object)schema)).getExample();
            if (propertyExample != null) {
                foundExample = true;
                example.add(propertyExample);
                continue;
            }
            example.add(new HashMap());
        }
        return foundExample;
    }

    @Override
    public void setExample(String example) throws IOException {
        this.example = (List)JacksonUtils.OBJECT_MAPPER.readValue(example, EXAMPLE_VALUE_TYPE);
    }
}

