/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.jackson;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.module.jsonSchema.types.IntegerSchema;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import org.forgerock.api.enums.ReadPolicy;
import org.forgerock.api.enums.WritePolicy;
import org.forgerock.api.jackson.CrestReadWritePoliciesSchema;
import org.forgerock.api.jackson.EnumSchema;
import org.forgerock.api.jackson.JacksonUtils;
import org.forgerock.api.jackson.MinimumMaximumSchema;
import org.forgerock.api.jackson.MultipleOfSchema;
import org.forgerock.api.jackson.OrderedFieldSchema;
import org.forgerock.api.jackson.PropertyFormatSchema;
import org.forgerock.api.jackson.ValidatableSchema;
import org.forgerock.api.jackson.WithExampleSchema;
import org.forgerock.api.util.ValidationUtil;
import org.forgerock.json.JsonValue;

class CrestIntegerSchema
extends IntegerSchema
implements CrestReadWritePoliciesSchema,
OrderedFieldSchema,
EnumSchema,
ValidatableSchema,
MultipleOfSchema,
PropertyFormatSchema,
MinimumMaximumSchema,
WithExampleSchema<Long> {
    private WritePolicy writePolicy;
    private ReadPolicy readPolicy;
    private Boolean errorOnWritePolicyFailure;
    private Boolean returnOnDemand;
    private Integer propertyOrder;
    private Double multipleOf;
    private String propertyFormat;
    private BigDecimal propertyMinimum;
    private BigDecimal propertyMaximum;
    @JsonProperty
    private Map<String, List<String>> options;
    private Long example;

    CrestIntegerSchema() {
    }

    @Override
    public WritePolicy getWritePolicy() {
        return this.writePolicy;
    }

    @Override
    public void setWritePolicy(WritePolicy policy) {
        this.writePolicy = policy;
    }

    @Override
    public ReadPolicy getReadPolicy() {
        return this.readPolicy;
    }

    @Override
    public void setReadPolicy(ReadPolicy readPolicy) {
        this.readPolicy = readPolicy;
    }

    @Override
    public Boolean getErrorOnWritePolicyFailure() {
        return this.errorOnWritePolicyFailure;
    }

    @Override
    public void setErrorOnWritePolicyFailure(Boolean errorOnWritePolicyFailure) {
        this.errorOnWritePolicyFailure = errorOnWritePolicyFailure;
    }

    @Override
    public Boolean getReturnOnDemand() {
        return this.returnOnDemand;
    }

    @Override
    public void setReturnOnDemand(Boolean returnOnDemand) {
        this.returnOnDemand = returnOnDemand;
    }

    @Override
    public Integer getPropertyOrder() {
        return this.propertyOrder;
    }

    @Override
    public void setPropertyOrder(Integer order2) {
        this.propertyOrder = order2;
    }

    @Override
    public List<String> getEnumTitles() {
        return this.options == null ? null : this.options.get("enum_titles");
    }

    @Override
    public void setEnumTitles(List<String> titles) {
        this.options = Collections.singletonMap("enum_titles", titles);
    }

    @Override
    public void validate(JsonValue object) throws ValidationException {
        if (!object.isNumber()) {
            throw new ValidationException("Expected integer, but got " + object.getObject());
        }
        Number number = object.asNumber();
        if (!(number instanceof Integer) && !(number instanceof Long)) {
            throw new ValidationException("Expected integer, but got " + object.getObject());
        }
        JacksonUtils.validateMaximumAndMinimum(number, this.getMaximum(), this.getExclusiveMaximum(), this.getMinimum(), this.getExclusiveMinimum());
        JacksonUtils.validateFormatForNumber(this.format);
        JacksonUtils.validateEnum(this.enums, number.toString());
    }

    @Override
    public Double getMultipleOf() {
        return this.multipleOf;
    }

    @Override
    public void setMultipleOf(Double multipleOf) {
        this.multipleOf = multipleOf;
    }

    @Override
    @JsonProperty(value="readOnly")
    public Boolean getReadonly() {
        return super.getReadonly();
    }

    @Override
    @JsonProperty(value="format")
    public String getPropertyFormat() {
        if (!ValidationUtil.isEmpty(this.propertyFormat)) {
            return this.propertyFormat;
        }
        return this.format == null ? null : this.format.toString();
    }

    @Override
    public void setPropertyFormat(String propertyFormat) {
        this.propertyFormat = propertyFormat;
    }

    @Override
    @JsonProperty(value="minimum")
    public BigDecimal getPropertyMinimum() {
        return this.propertyMinimum;
    }

    @Override
    public void setPropertyMinimum(BigDecimal propertyMinimum) {
        this.propertyMinimum = propertyMinimum;
    }

    @Override
    @JsonProperty(value="maximum")
    public BigDecimal getPropertyMaximum() {
        return this.propertyMaximum;
    }

    @Override
    public void setPropertyMaximum(BigDecimal propertyMaximum) {
        this.propertyMaximum = propertyMaximum;
    }

    @Override
    public Long getExample() {
        return this.example;
    }

    @Override
    public void setExample(String example) {
        this.example = Long.valueOf(example);
    }
}

