/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.jackson;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.ObjectVisitor;
import com.fasterxml.jackson.module.jsonSchema.factories.ObjectVisitorDecorator;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.VisitorContext;
import com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.types.NumberSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.SimpleTypeSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import com.google.common.io.Resources;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.forgerock.api.annotations.AdditionalProperties;
import org.forgerock.api.annotations.Default;
import org.forgerock.api.annotations.Description;
import org.forgerock.api.annotations.EnumTitle;
import org.forgerock.api.annotations.Example;
import org.forgerock.api.annotations.Format;
import org.forgerock.api.annotations.MultipleOf;
import org.forgerock.api.annotations.PropertyOrder;
import org.forgerock.api.annotations.PropertyPolicies;
import org.forgerock.api.annotations.ReadOnly;
import org.forgerock.api.annotations.Title;
import org.forgerock.api.annotations.UniqueItems;
import org.forgerock.api.enums.WritePolicy;
import org.forgerock.api.jackson.CrestJsonSchemaFactory;
import org.forgerock.api.jackson.CrestReadWritePoliciesSchema;
import org.forgerock.api.jackson.EnumSchema;
import org.forgerock.api.jackson.JacksonUtils;
import org.forgerock.api.jackson.MinimumMaximumSchema;
import org.forgerock.api.jackson.MultipleOfSchema;
import org.forgerock.api.jackson.OrderedFieldSchema;
import org.forgerock.api.jackson.PropertyFormatSchema;
import org.forgerock.api.jackson.RequiredFieldsSchema;
import org.forgerock.api.jackson.WithExampleSchema;
import org.forgerock.api.util.ValidationUtil;

public class CrestPropertyDetailsSchemaFactoryWrapper
extends SchemaFactoryWrapper {
    private static final WrapperFactory WRAPPER_FACTORY = new WrapperFactory(){

        @Override
        public SchemaFactoryWrapper getWrapper(SerializerProvider provider) {
            CrestPropertyDetailsSchemaFactoryWrapper wrapper = new CrestPropertyDetailsSchemaFactoryWrapper();
            wrapper.setProvider(provider);
            return wrapper;
        }

        @Override
        public SchemaFactoryWrapper getWrapper(SerializerProvider provider, VisitorContext rvc) {
            CrestPropertyDetailsSchemaFactoryWrapper wrapper = new CrestPropertyDetailsSchemaFactoryWrapper();
            wrapper.setProvider(provider);
            wrapper.setVisitorContext(rvc);
            return wrapper;
        }
    };
    private static final String CLASSPATH_RESOURCE = "classpath:";

    public CrestPropertyDetailsSchemaFactoryWrapper() {
        super(WRAPPER_FACTORY);
        this.schemaProvider = new CrestJsonSchemaFactory();
    }

    @Override
    public JsonObjectFormatVisitor expectObjectFormat(JavaType convertedType) {
        Set<String> requiredFieldNames;
        Description description;
        Title title;
        ObjectVisitor objectVisitor = (ObjectVisitor)super.expectObjectFormat(convertedType);
        Class<?> clazz = convertedType.getRawClass();
        if (this.schema instanceof SimpleTypeSchema && (title = clazz.getAnnotation(Title.class)) != null && !ValidationUtil.isEmpty(title.value())) {
            ((SimpleTypeSchema)this.schema).setTitle(title.value());
        }
        if ((description = clazz.getAnnotation(Description.class)) != null && !ValidationUtil.isEmpty(description.value())) {
            this.schema.setDescription(description.value());
        }
        if (this.schema instanceof RequiredFieldsSchema) {
            requiredFieldNames = Collections.synchronizedSet(new HashSet());
            ((RequiredFieldsSchema)((Object)this.schema)).setRequiredFields(requiredFieldNames);
        } else {
            requiredFieldNames = null;
        }
        Example example = clazz.getAnnotation(Example.class);
        if (this.schema instanceof WithExampleSchema && example != null && !ValidationUtil.isEmpty(example.value())) {
            this.setExample(clazz, example, (WithExampleSchema)((Object)this.schema));
        }
        return new ObjectVisitorDecorator(objectVisitor){

            @Override
            public JsonSchema getSchema() {
                return super.getSchema();
            }

            @Override
            public void optionalProperty(BeanProperty writer) throws JsonMappingException {
                super.optionalProperty(writer);
                JsonSchema schema = this.schemaFor(writer);
                this.addFieldPolicies(writer, schema);
                this.addPropertyOrder(writer, schema);
                this.addEnumTitles(writer, schema);
                this.addRequired(writer, schema);
                this.addStringPattern(writer, schema);
                this.addStringMinLength(writer, schema);
                this.addStringMaxLength(writer, schema);
                this.addArrayMinItems(writer, schema);
                this.addArrayMaxItems(writer, schema);
                this.addNumberMaximum(writer, schema);
                this.addNumberMinimum(writer, schema);
                this.addNumberExclusiveMinimum(writer, schema);
                this.addNumberExclusiveMaximum(writer, schema);
                this.addReadOnly(writer, schema);
                this.addTitle(writer, schema);
                this.addDescription(writer, schema);
                this.addDefault(writer, schema);
                this.addUniqueItems(writer, schema);
                this.addMultipleOf(writer, schema);
                this.addFormat(writer, schema);
                this.addExample(writer, schema);
                this.addAdditionalProperties(writer, schema);
            }

            private void addExample(BeanProperty writer, JsonSchema schema) {
                Example annotation2 = this.annotationFor(writer, Example.class);
                if (annotation2 != null) {
                    WithExampleSchema exampleSchema = (WithExampleSchema)((Object)schema);
                    CrestPropertyDetailsSchemaFactoryWrapper.this.setExample(writer.getType().getRawClass(), annotation2, exampleSchema);
                }
            }

            private void addEnumTitles(BeanProperty writer, JsonSchema schema) {
                JavaType type2 = writer.getType();
                if (type2.isEnumType()) {
                    Class<Enum> enumClass = type2.getRawClass().asSubclass(Enum.class);
                    Enum[] enumConstants = enumClass.getEnumConstants();
                    ArrayList<String> titles = new ArrayList<String>(enumConstants.length);
                    boolean foundTitle = false;
                    for (Enum value2 : enumConstants) {
                        try {
                            EnumTitle title = enumClass.getField(value2.name()).getAnnotation(EnumTitle.class);
                            if (title != null) {
                                titles.add(title.value());
                                foundTitle = true;
                                continue;
                            }
                            titles.add(null);
                        }
                        catch (NoSuchFieldException e) {
                            throw new IllegalStateException("Enum doesn't have its own value as a field", e);
                        }
                    }
                    if (foundTitle) {
                        ((EnumSchema)((Object)schema)).setEnumTitles(titles);
                    }
                }
            }

            private void addPropertyOrder(BeanProperty writer, JsonSchema schema) {
                PropertyOrder order2 = this.annotationFor(writer, PropertyOrder.class);
                if (order2 != null) {
                    ((OrderedFieldSchema)((Object)schema)).setPropertyOrder(order2.value());
                }
            }

            private void addFieldPolicies(BeanProperty writer, JsonSchema schema) {
                PropertyPolicies policies = this.annotationFor(writer, PropertyPolicies.class);
                if (policies != null) {
                    CrestReadWritePoliciesSchema schemaPolicies = (CrestReadWritePoliciesSchema)((Object)schema);
                    if (policies.write() != WritePolicy.WRITABLE) {
                        schemaPolicies.setWritePolicy(policies.write());
                        schemaPolicies.setErrorOnWritePolicyFailure(policies.errorOnWritePolicyFailure());
                    }
                    schemaPolicies.setReadPolicy(policies.read());
                    schemaPolicies.setReturnOnDemand(policies.returnOnDemand());
                }
            }

            private void addRequired(BeanProperty writer, JsonSchema schema) {
                NotNull notNull = this.annotationFor(writer, NotNull.class);
                if (notNull != null) {
                    if (requiredFieldNames != null) {
                        requiredFieldNames.add(writer.getName());
                    } else {
                        schema.setRequired(true);
                    }
                }
            }

            private void addStringPattern(BeanProperty writer, JsonSchema schema) {
                Pattern pattern = this.annotationFor(writer, Pattern.class);
                if (pattern != null && !ValidationUtil.isEmpty(pattern.regexp())) {
                    ((StringSchema)schema).setPattern(pattern.regexp());
                }
            }

            private void addStringMinLength(BeanProperty writer, JsonSchema schema) {
                Integer size2 = this.getMinSize(writer);
                if (size2 != null && schema instanceof StringSchema) {
                    ((StringSchema)schema).setMinLength(size2);
                }
            }

            private void addStringMaxLength(BeanProperty writer, JsonSchema schema) {
                Integer size2 = this.getMaxSize(writer);
                if (size2 != null && schema instanceof StringSchema) {
                    ((StringSchema)schema).setMaxLength(size2);
                }
            }

            private void addArrayMinItems(BeanProperty writer, JsonSchema schema) {
                Integer size2 = this.getMinSize(writer);
                if (size2 != null && schema instanceof ArraySchema) {
                    ((ArraySchema)schema).setMinItems(size2);
                }
            }

            private void addArrayMaxItems(BeanProperty writer, JsonSchema schema) {
                Integer size2 = this.getMaxSize(writer);
                if (size2 != null && schema instanceof ArraySchema) {
                    ((ArraySchema)schema).setMaxItems(size2);
                }
            }

            private void addNumberMinimum(BeanProperty writer, JsonSchema schema) {
                DecimalMin decimalMin;
                Min min2 = this.annotationFor(writer, Min.class);
                if (min2 != null) {
                    ((MinimumMaximumSchema)((Object)schema)).setPropertyMinimum(new BigDecimal(min2.value()));
                }
                if ((decimalMin = this.annotationFor(writer, DecimalMin.class)) != null) {
                    ((MinimumMaximumSchema)((Object)schema)).setPropertyMinimum(new BigDecimal(decimalMin.value()));
                }
            }

            private void addNumberMaximum(BeanProperty writer, JsonSchema schema) {
                DecimalMax decimalMax;
                Max max2 = this.annotationFor(writer, Max.class);
                if (max2 != null) {
                    ((MinimumMaximumSchema)((Object)schema)).setPropertyMaximum(new BigDecimal(max2.value()));
                }
                if ((decimalMax = this.annotationFor(writer, DecimalMax.class)) != null) {
                    ((MinimumMaximumSchema)((Object)schema)).setPropertyMaximum(new BigDecimal(decimalMax.value()));
                }
            }

            private void addNumberExclusiveMinimum(BeanProperty writer, JsonSchema schema) {
                DecimalMin decimalMin = this.annotationFor(writer, DecimalMin.class);
                if (decimalMin != null && !decimalMin.inclusive()) {
                    ((NumberSchema)schema).setExclusiveMinimum(true);
                }
            }

            private void addNumberExclusiveMaximum(BeanProperty writer, JsonSchema schema) {
                DecimalMax decimalMax = this.annotationFor(writer, DecimalMax.class);
                if (decimalMax != null && !decimalMax.inclusive()) {
                    ((NumberSchema)schema).setExclusiveMaximum(true);
                }
            }

            private void addReadOnly(BeanProperty writer, JsonSchema schema) {
                ReadOnly readOnly = this.annotationFor(writer, ReadOnly.class);
                if (readOnly != null) {
                    schema.setReadonly(readOnly.value());
                }
            }

            private void addTitle(BeanProperty writer, JsonSchema schema) {
                Title title = this.annotationFor(writer, Title.class);
                if (title != null && !ValidationUtil.isEmpty(title.value())) {
                    ((SimpleTypeSchema)schema).setTitle(title.value());
                }
            }

            private void addDescription(BeanProperty writer, JsonSchema schema) {
                Description description = this.annotationFor(writer, Description.class);
                if (description != null && !ValidationUtil.isEmpty(description.value())) {
                    schema.setDescription(description.value());
                }
            }

            private void addDefault(BeanProperty writer, JsonSchema schema) {
                Default defaultAnnotation = this.annotationFor(writer, Default.class);
                if (defaultAnnotation != null && !ValidationUtil.isEmpty(defaultAnnotation.value())) {
                    ((SimpleTypeSchema)schema).setDefault(defaultAnnotation.value());
                }
            }

            private void addUniqueItems(BeanProperty writer, JsonSchema schema) {
                UniqueItems uniqueItems = this.annotationFor(writer, UniqueItems.class);
                if (uniqueItems != null) {
                    ((ArraySchema)schema).setUniqueItems(uniqueItems.value());
                }
            }

            private void addMultipleOf(BeanProperty writer, JsonSchema schema) {
                MultipleOf multipleOf = this.annotationFor(writer, MultipleOf.class);
                if (multipleOf != null) {
                    ((MultipleOfSchema)((Object)schema)).setMultipleOf(multipleOf.value());
                }
            }

            private void addFormat(BeanProperty writer, JsonSchema schema) {
                if (schema instanceof PropertyFormatSchema) {
                    Format format = this.annotationFor(writer, Format.class);
                    if (format != null && !ValidationUtil.isEmpty(format.value())) {
                        ((PropertyFormatSchema)((Object)schema)).setPropertyFormat(format.value());
                    } else if (writer.getType() instanceof SimpleType) {
                        String formatValue;
                        Class<?> rawClass = writer.getType().getRawClass();
                        if (Integer.class.equals(rawClass) || Integer.TYPE.equals(rawClass)) {
                            formatValue = "int32";
                        } else if (Long.class.equals(rawClass) || Long.TYPE.equals(rawClass)) {
                            formatValue = "int64";
                        } else if (Double.class.equals(rawClass) || Double.TYPE.equals(rawClass)) {
                            formatValue = "double";
                        } else if (Float.class.equals(rawClass) || Float.TYPE.equals(rawClass)) {
                            formatValue = "float";
                        } else {
                            return;
                        }
                        ((PropertyFormatSchema)((Object)schema)).setPropertyFormat(formatValue);
                    }
                }
            }

            private void addAdditionalProperties(BeanProperty writer, JsonSchema schema) throws JsonMappingException {
                AdditionalProperties additionalProperties = this.annotationFor(writer, AdditionalProperties.class);
                if (additionalProperties != null && !additionalProperties.value().isInstance(Void.class)) {
                    CrestPropertyDetailsSchemaFactoryWrapper visitor = new CrestPropertyDetailsSchemaFactoryWrapper();
                    JacksonUtils.OBJECT_MAPPER.acceptJsonFormatVisitor(additionalProperties.value(), (JsonFormatVisitorWrapper)visitor);
                    ObjectSchema.SchemaAdditionalProperties schemaAdditionalProperties = new ObjectSchema.SchemaAdditionalProperties(visitor.finalSchema());
                    ((ObjectSchema)schema).setAdditionalProperties(schemaAdditionalProperties);
                }
            }

            private Integer getMaxSize(BeanProperty writer) {
                int value2;
                Size size2 = writer.getAnnotation(Size.class);
                if (size2 != null && (value2 = size2.max()) != Integer.MAX_VALUE) {
                    return value2;
                }
                return null;
            }

            private Integer getMinSize(BeanProperty writer) {
                int value2;
                Size size2 = writer.getAnnotation(Size.class);
                if (size2 != null && (value2 = size2.min()) != 0) {
                    return value2;
                }
                return null;
            }

            private <T extends Annotation> T annotationFor(BeanProperty writer, Class<T> type2) {
                return writer.getMember().getAnnotation(type2);
            }

            private JsonSchema schemaFor(BeanProperty writer) {
                return this.getSchema().asObjectSchema().getProperties().get(writer.getName());
            }
        };
    }

    private void setExample(Class<?> contextClass, Example annotation2, WithExampleSchema<?> exampleSchema) {
        String example = annotation2.value();
        if (example.startsWith(CLASSPATH_RESOURCE)) {
            ClassLoader classLoader = contextClass.getClassLoader();
            try {
                String name2 = example.substring(CLASSPATH_RESOURCE.length()).trim();
                URL resource2 = classLoader.getResource(name2);
                if (resource2 == null) {
                    throw new IllegalStateException("Cannot read resource: " + example);
                }
                example = Resources.toString(resource2, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot read resource: " + example, e);
            }
        }
        try {
            exampleSchema.setExample(example);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not parse example value to type of schema", e);
        }
    }
}

