/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.markup.asciidoc;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.api.markup.asciidoc.AsciiDocException;
import org.forgerock.api.markup.asciidoc.AsciiDocSymbols;
import org.forgerock.api.markup.asciidoc.AsciiDocTable;
import org.forgerock.api.util.ValidationUtil;
import org.forgerock.util.Reject;

public final class AsciiDoc {
    public static final Pattern INCLUDE_PATTERN = Pattern.compile("include[:]{2}([^\\[]+)\\[\\]");
    private static final String NAMESPACE_DELIMITER = "_";
    private static final Pattern POSIX_FILENAME_REPLACEMENT_PATTERN = Pattern.compile("^[-]|[^A-Za-z0-9._-]");
    private static final Pattern SQUASH_UNDERSCORES_PATTERN = Pattern.compile("[_]{2,}");
    private final StringBuilder builder = new StringBuilder();

    private AsciiDoc() {
    }

    public static AsciiDoc asciiDoc() {
        return new AsciiDoc();
    }

    private AsciiDoc line(AsciiDocSymbols symbol, String content) {
        if (ValidationUtil.isEmpty(content)) {
            throw new AsciiDocException("content required");
        }
        this.builder.append((Object)AsciiDocSymbols.NEWLINE).append((Object)Reject.checkNotNull(symbol)).append(content).append((Object)AsciiDocSymbols.NEWLINE);
        return this;
    }

    private AsciiDoc block(AsciiDocSymbols symbol, String content) {
        if (ValidationUtil.isEmpty(content)) {
            throw new AsciiDocException("content required");
        }
        this.builder.append((Object)Reject.checkNotNull(symbol)).append((Object)AsciiDocSymbols.NEWLINE).append(content).append((Object)AsciiDocSymbols.NEWLINE).append((Object)Reject.checkNotNull(symbol)).append((Object)AsciiDocSymbols.NEWLINE);
        return this;
    }

    public AsciiDoc newline() {
        this.builder.append((Object)AsciiDocSymbols.NEWLINE);
        return this;
    }

    public AsciiDoc rawText(String text) {
        if (text == null) {
            throw new AsciiDocException("text required");
        }
        this.builder.append(text);
        return this;
    }

    public AsciiDoc rawLine(String text) {
        if (ValidationUtil.isEmpty(text)) {
            throw new AsciiDocException("text required");
        }
        int newlinesAbove = AsciiDoc.requireTrailingNewlines(1, this.builder);
        if (newlinesAbove == 1) {
            this.builder.append((Object)AsciiDocSymbols.NEWLINE);
        }
        this.builder.append(text);
        int newlinesBelow = AsciiDoc.requireTrailingNewlines(1, text);
        if (newlinesBelow == 1) {
            this.builder.append((Object)AsciiDocSymbols.NEWLINE);
        }
        return this;
    }

    public AsciiDoc rawParagraph(String text) {
        if (ValidationUtil.isEmpty(text)) {
            throw new AsciiDocException("text required");
        }
        int newlinesAbove = AsciiDoc.requireTrailingNewlines(2, this.builder);
        while (--newlinesAbove > -1) {
            this.builder.append((Object)AsciiDocSymbols.NEWLINE);
        }
        this.builder.append(text);
        int newlinesBelow = AsciiDoc.requireTrailingNewlines(2, text);
        while (--newlinesBelow > -1) {
            this.builder.append((Object)AsciiDocSymbols.NEWLINE);
        }
        return this;
    }

    private static int requireTrailingNewlines(int newlines, CharSequence text) {
        if (newlines < 0) {
            throw new IllegalArgumentException("newlines must be positive");
        }
        for (int i2 = 0; newlines > 0 && text.length() > i2 && text.charAt(text.length() - (i2 + 1)) == '\n'; --newlines, ++i2) {
        }
        return newlines;
    }

    public AsciiDoc boldText(String text) {
        if (ValidationUtil.isEmpty(text)) {
            throw new AsciiDocException("text required");
        }
        this.builder.append((Object)AsciiDocSymbols.BOLD).append(text).append((Object)AsciiDocSymbols.BOLD);
        return this;
    }

    public AsciiDoc italic(String text) {
        if (ValidationUtil.isEmpty(text)) {
            throw new AsciiDocException("text required");
        }
        this.builder.append((Object)AsciiDocSymbols.ITALIC).append(text).append((Object)AsciiDocSymbols.ITALIC);
        return this;
    }

    public AsciiDoc mono(String text) {
        if (ValidationUtil.isEmpty(text)) {
            throw new AsciiDocException("text required");
        }
        this.builder.append((Object)AsciiDocSymbols.MONO).append(text).append((Object)AsciiDocSymbols.MONO);
        return this;
    }

    public AsciiDoc documentTitle(String title) {
        return this.line(AsciiDocSymbols.DOC_TITLE, title);
    }

    public AsciiDoc blockTitle(String title) {
        return this.line(AsciiDocSymbols.BLOCK_TITLE, title);
    }

    public AsciiDoc sectionTitle(String title, int level2) {
        switch (level2) {
            case 1: {
                return this.line(AsciiDocSymbols.SECTION_TITLE_1, title);
            }
            case 2: {
                return this.line(AsciiDocSymbols.SECTION_TITLE_2, title);
            }
            case 3: {
                return this.line(AsciiDocSymbols.SECTION_TITLE_3, title);
            }
            case 4: {
                return this.line(AsciiDocSymbols.SECTION_TITLE_4, title);
            }
            case 5: {
                return this.line(AsciiDocSymbols.SECTION_TITLE_5, title);
            }
        }
        throw new AsciiDocException("Unsupported section-level: " + level2);
    }

    public AsciiDoc sectionTitle1(String title) {
        return this.line(AsciiDocSymbols.SECTION_TITLE_1, title);
    }

    public AsciiDoc sectionTitle2(String title) {
        return this.line(AsciiDocSymbols.SECTION_TITLE_2, title);
    }

    public AsciiDoc sectionTitle3(String title) {
        return this.line(AsciiDocSymbols.SECTION_TITLE_3, title);
    }

    public AsciiDoc sectionTitle4(String title) {
        return this.line(AsciiDocSymbols.SECTION_TITLE_4, title);
    }

    public AsciiDoc sectionTitle5(String title) {
        return this.line(AsciiDocSymbols.SECTION_TITLE_5, title);
    }

    public AsciiDoc exampleBlock(String content) {
        return this.block(AsciiDocSymbols.EXAMPLE, content);
    }

    public AsciiDoc listingBlock(String content) {
        return this.block(AsciiDocSymbols.LISTING, content);
    }

    public AsciiDoc listingBlock(String content, String sourceType) {
        if (ValidationUtil.isEmpty(content) || ValidationUtil.isEmpty(sourceType)) {
            throw new AsciiDocException("content and sourceType required");
        }
        this.builder.append("[source,").append(sourceType).append("]").append((Object)AsciiDocSymbols.NEWLINE);
        return this.block(AsciiDocSymbols.LISTING, content);
    }

    public AsciiDoc literalBlock(String content) {
        return this.block(AsciiDocSymbols.LITERAL, content);
    }

    public AsciiDoc passthroughBlock(String content) {
        return this.block(AsciiDocSymbols.PASSTHROUGH, content);
    }

    public AsciiDoc sidebarBlock(String content) {
        return this.block(AsciiDocSymbols.SIDEBAR, content);
    }

    public AsciiDoc anchor(String id2) {
        if (ValidationUtil.isEmpty(id2)) {
            throw new AsciiDocException("id required");
        }
        if (ValidationUtil.containsWhitespace(id2)) {
            throw new AsciiDocException("id contains whitespace");
        }
        this.builder.append((Object)AsciiDocSymbols.ANCHOR_START).append(id2).append((Object)AsciiDocSymbols.ANCHOR_END);
        return this;
    }

    public AsciiDoc anchor(String id2, String xreflabel) {
        if (ValidationUtil.isEmpty(id2) || ValidationUtil.isEmpty(xreflabel)) {
            throw new AsciiDocException("id and xreflabel required");
        }
        if (ValidationUtil.containsWhitespace(id2)) {
            throw new AsciiDocException("id contains whitespace");
        }
        this.builder.append((Object)AsciiDocSymbols.ANCHOR_START).append(id2).append(',').append(xreflabel).append((Object)AsciiDocSymbols.ANCHOR_END);
        return this;
    }

    public AsciiDoc link(String anchorId) {
        if (ValidationUtil.isEmpty(anchorId)) {
            throw new AsciiDocException("anchorId required");
        }
        if (ValidationUtil.containsWhitespace(anchorId)) {
            throw new AsciiDocException("anchorId contains whitespace");
        }
        this.builder.append((Object)AsciiDocSymbols.CROSS_REF_START).append(anchorId).append((Object)AsciiDocSymbols.CROSS_REF_END);
        return this;
    }

    public AsciiDoc link(String anchorId, String xreflabel) {
        if (ValidationUtil.isEmpty(anchorId) || ValidationUtil.isEmpty(xreflabel)) {
            throw new AsciiDocException("anchorId and xreflabel required");
        }
        if (ValidationUtil.containsWhitespace(anchorId)) {
            throw new AsciiDocException("anchorId contains whitespace");
        }
        this.builder.append((Object)AsciiDocSymbols.CROSS_REF_START).append(anchorId).append(',').append(xreflabel).append((Object)AsciiDocSymbols.CROSS_REF_END);
        return this;
    }

    public AsciiDoc unorderedList1(String content) {
        this.line(AsciiDocSymbols.UNORDERED_LIST_1, content);
        return this;
    }

    public AsciiDoc listContinuation() {
        int newlinesAbove = AsciiDoc.requireTrailingNewlines(1, this.builder);
        if (newlinesAbove == 1) {
            this.builder.append((Object)AsciiDocSymbols.NEWLINE);
        }
        this.builder.append((Object)AsciiDocSymbols.LIST_CONTINUATION);
        return this;
    }

    public AsciiDoc horizontalRule() {
        int newlinesAbove = AsciiDoc.requireTrailingNewlines(1, this.builder);
        if (newlinesAbove == 1) {
            this.builder.append((Object)AsciiDocSymbols.NEWLINE);
        }
        this.builder.append((Object)AsciiDocSymbols.HORIZONTAL_RULE).append((Object)AsciiDocSymbols.NEWLINE);
        return this;
    }

    public AsciiDocTable tableStart() {
        return new AsciiDocTable(this, this.builder);
    }

    public AsciiDoc include(String ... path2) {
        if (ValidationUtil.isEmpty(path2)) {
            throw new AsciiDocException("path required");
        }
        this.builder.append((Object)AsciiDocSymbols.INCLUDE);
        this.builder.append(path2[0]);
        for (int i2 = 1; i2 < path2.length; ++i2) {
            this.builder.append('/').append(path2[i2]);
        }
        this.builder.append("[]").append((Object)AsciiDocSymbols.NEWLINE);
        return this;
    }

    public void toFile(Path outputDirPath, String filename2) throws IOException {
        Path filePath = outputDirPath.resolve(filename2);
        Files.createDirectories(outputDirPath, new FileAttribute[0]);
        Files.createFile(filePath, new FileAttribute[0]);
        Files.write(filePath, this.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public String toString() {
        return this.builder.toString();
    }

    public static String normalizeName(String ... parts) {
        if (ValidationUtil.isEmpty(parts)) {
            throw new AsciiDocException("parts required");
        }
        String s2 = parts[0].toLowerCase(Locale.ROOT);
        for (int i2 = 1; i2 < parts.length; ++i2) {
            s2 = s2 + NAMESPACE_DELIMITER + parts[i2].toLowerCase(Locale.ROOT);
        }
        Matcher m3 = POSIX_FILENAME_REPLACEMENT_PATTERN.matcher(s2);
        String normalized = m3.find() ? m3.replaceAll(NAMESPACE_DELIMITER) : s2;
        Matcher mm3 = SQUASH_UNDERSCORES_PATTERN.matcher(normalized);
        return mm3.find() ? mm3.replaceAll(NAMESPACE_DELIMITER) : normalized;
    }
}

