/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.markup.asciidoc;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.api.markup.asciidoc.AsciiDoc;
import org.forgerock.api.markup.asciidoc.AsciiDocException;
import org.forgerock.api.markup.asciidoc.AsciiDocSymbols;
import org.forgerock.api.markup.asciidoc.AsciiDocTableColumnStyles;
import org.forgerock.api.util.ValidationUtil;
import org.forgerock.util.Reject;

public class AsciiDocTable {
    public static final int COLUMN_WIDTH_SMALL = 1;
    public static final int COLUMN_WIDTH_MEDIUM = 2;
    private static final Pattern TABLE_CELL_SYMBOL_PATTERN = Pattern.compile("\\|");
    private final AsciiDoc asciiDoc;
    private final StringBuilder builder;
    private final List<String> cells;
    private int[] columnWidths;
    private Integer columnsPerRow;
    private String title;
    private boolean hasHeader;

    AsciiDocTable(AsciiDoc asciiDoc, StringBuilder builder) {
        this.asciiDoc = Reject.checkNotNull(asciiDoc);
        this.builder = Reject.checkNotNull(builder);
        this.cells = new ArrayList<String>();
    }

    public AsciiDocTable title(String title) {
        if (ValidationUtil.isEmpty(title)) {
            throw new AsciiDocException("title required");
        }
        if (this.title != null) {
            throw new AsciiDocException("title already defined");
        }
        this.title = title;
        return this;
    }

    public AsciiDocTable headers(List<String> columnHeaders) {
        return this.headers(columnHeaders.toArray(new String[columnHeaders.size()]));
    }

    public AsciiDocTable headers(String ... columnHeaders) {
        if (ValidationUtil.isEmpty(columnHeaders)) {
            throw new AsciiDocException("columnHeaders required");
        }
        if (this.hasHeader) {
            throw new AsciiDocException("headers already defined");
        }
        if (this.columnsPerRow == null) {
            this.columnsPerRow = columnHeaders.length;
        } else if (this.columnsPerRow != columnHeaders.length) {
            throw new AsciiDocException("columnHeaders.length != columnsPerRow");
        }
        this.hasHeader = true;
        this.cells.add(null);
        for (int i2 = columnHeaders.length - 1; i2 > -1; --i2) {
            this.cells.add(0, (Object)((Object)AsciiDocSymbols.TABLE_CELL) + this.normalizeColumnCell(columnHeaders[i2]));
        }
        return this;
    }

    public AsciiDocTable columnsPerRow(int columnsPerRow) {
        if (this.columnsPerRow != null) {
            throw new AsciiDocException("columnsPerRow already defined");
        }
        if (this.columnsPerRow < 1) {
            throw new AsciiDocException("columnsPerRow < 1");
        }
        this.columnsPerRow = columnsPerRow;
        return this;
    }

    public AsciiDocTable columnWidths(List<Integer> columnWidths) {
        int[] array2 = new int[columnWidths.size()];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            array2[i2] = columnWidths.get(i2);
        }
        return this.columnWidths(array2);
    }

    public AsciiDocTable columnWidths(int ... columnWidths) {
        if (columnWidths == null || columnWidths.length == 0) {
            throw new AsciiDocException("columnWidths required");
        }
        for (int w : columnWidths) {
            if (w >= 1 && w <= 99) continue;
            throw new AsciiDocException("columnWidths values must be within range [1,99]");
        }
        if (this.columnsPerRow != null) {
            if (this.columnsPerRow != columnWidths.length) {
                throw new AsciiDocException("columnWidths.length != columnsPerRow");
            }
        } else {
            this.columnsPerRow = columnWidths.length;
        }
        this.columnWidths = columnWidths;
        return this;
    }

    public AsciiDocTable columnCell(String columnCell) {
        this.cells.add((Object)((Object)AsciiDocSymbols.TABLE_CELL) + this.normalizeColumnCell(columnCell));
        return this;
    }

    public AsciiDocTable columnCell(String columnCell, AsciiDocTableColumnStyles style) {
        this.cells.add(style.toString() + (Object)((Object)AsciiDocSymbols.TABLE_CELL) + this.normalizeColumnCell(columnCell));
        return this;
    }

    public AsciiDocTable rowEnd() {
        this.cells.add(null);
        return this;
    }

    private String normalizeColumnCell(String columnCell) {
        if (ValidationUtil.isEmpty(columnCell)) {
            return "";
        }
        Matcher m3 = TABLE_CELL_SYMBOL_PATTERN.matcher(columnCell);
        return m3.find() ? m3.replaceAll("\\" + (Object)((Object)AsciiDocSymbols.TABLE_CELL)) : columnCell;
    }

    public AsciiDoc tableEnd() {
        if (this.columnsPerRow == null) {
            throw new AsciiDocException("columnsPerRow has not be defined");
        }
        this.builder.append("[cols=\"");
        if (this.columnWidths != null) {
            this.builder.append(this.columnWidths[0]);
            for (int i2 = 1; i2 < this.columnWidths.length; ++i2) {
                this.builder.append(',').append(this.columnWidths[i2]);
            }
        } else {
            this.builder.append(this.columnsPerRow).append("*");
        }
        this.builder.append("\", caption=\"\", options=\"");
        if (this.hasHeader) {
            this.builder.append("header");
        }
        this.builder.append("\"]").append((Object)AsciiDocSymbols.NEWLINE);
        if (this.title != null) {
            this.builder.append(".").append(this.title).append((Object)AsciiDocSymbols.NEWLINE);
        }
        this.builder.append((Object)AsciiDocSymbols.TABLE).append((Object)AsciiDocSymbols.NEWLINE);
        if (this.cells.get(this.cells.size() - 1) == null) {
            this.cells.remove(this.cells.size() - 1);
        }
        for (String item : this.cells) {
            if (item != null) {
                this.builder.append(item);
            }
            this.builder.append((Object)AsciiDocSymbols.NEWLINE);
        }
        this.builder.append((Object)AsciiDocSymbols.TABLE).append((Object)AsciiDocSymbols.NEWLINE);
        return this.asciiDoc;
    }
}

