/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import java.util.Objects;
import org.forgerock.api.ApiValidationException;
import org.forgerock.api.enums.ParameterSource;
import org.forgerock.api.util.ValidationUtil;
import org.forgerock.util.i18n.LocalizableString;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class Parameter {
    private final String name;
    private final String type;
    private final String defaultValue;
    private final LocalizableString description;
    private final ParameterSource source;
    private final Boolean required;
    private final String[] enumValues;
    private final String[] enumTitles;

    private Parameter(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.defaultValue = builder.defaultValue;
        this.description = builder.description;
        this.source = builder.source;
        this.required = builder.required;
        this.enumValues = builder.enumValues;
        this.enumTitles = builder.enumTitles;
        if (ValidationUtil.isEmpty(this.name) || ValidationUtil.isEmpty(this.type) || this.source == null) {
            throw new ApiValidationException("name, type, and source are required");
        }
        if (this.enumTitles != null) {
            if (this.enumValues == null) {
                throw new ApiValidationException("enum[] required when enum_values[] is defined");
            }
            if (this.enumTitles.length != this.enumValues.length) {
                throw new ApiValidationException("enum[] and enum_values[] must be the same length");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public LocalizableString getDescription() {
        return this.description;
    }

    public ParameterSource getSource() {
        return this.source;
    }

    public Boolean isRequired() {
        return this.required;
    }

    @JsonProperty(value="enum")
    public String[] getEnumValues() {
        return this.enumValues;
    }

    @JsonProperty(value="options/enum_titles")
    public String[] getEnumTitles() {
        return this.enumTitles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        return this.required == parameter.required && Objects.equals(this.name, parameter.name) && Objects.equals(this.type, parameter.type) && Objects.equals(this.defaultValue, parameter.defaultValue) && Objects.equals(this.description, parameter.description) && this.source == parameter.source && Arrays.equals(this.enumValues, parameter.enumValues) && Arrays.equals(this.enumTitles, parameter.enumTitles);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.defaultValue, this.description, this.source, this.required, this.enumValues, this.enumTitles});
    }

    public static Builder parameter() {
        return new Builder();
    }

    public static Parameter fromAnnotation(Class<?> type2, org.forgerock.api.annotations.Parameter parameter) {
        return Parameter.parameter().description(new LocalizableString(parameter.description(), type2)).defaultValue(parameter.defaultValue()).enumValues(parameter.enumValues()).enumTitles(parameter.enumTitles()).required(parameter.required()).name(parameter.name()).source(parameter.source()).type(parameter.type()).build();
    }

    public static final class Builder {
        private String name;
        private String type;
        private String defaultValue;
        private LocalizableString description;
        private ParameterSource source;
        private Boolean required;
        private String[] enumValues;
        private String[] enumTitles;

        private Builder() {
        }

        @JsonProperty(value="name")
        public Builder name(String name2) {
            this.name = name2;
            return this;
        }

        @JsonProperty(value="enum")
        public Builder enumValues(String ... enumValues) {
            this.enumValues = enumValues;
            return this;
        }

        @JsonProperty(value="options/enum_titles")
        public Builder enumTitles(String ... enumTitles) {
            this.enumTitles = enumTitles;
            return this;
        }

        @JsonProperty(value="type")
        public Builder type(String type2) {
            this.type = type2;
            return this;
        }

        @JsonProperty(value="defaultValue")
        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder description(LocalizableString description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="description")
        public Builder description(String description) {
            this.description = new LocalizableString(description);
            return this;
        }

        @JsonProperty(value="source")
        public Builder source(ParameterSource source2) {
            this.source = source2;
            return this;
        }

        @JsonProperty(value="required")
        public Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public Parameter build() {
            return new Parameter(this);
        }
    }
}

