/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.forgerock.api.jackson.JacksonUtils;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.Reference;
import org.forgerock.api.models.TranslateJsonSchema;
import org.forgerock.util.Reject;

@JsonDeserialize(builder=Builder.class)
public abstract class Schema {
    private Schema() {
    }

    public abstract Reference getReference();

    public abstract org.forgerock.json.JsonValue getSchema();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema schema1 = (Schema)o;
        return Objects.equals(this.getReference(), schema1.getReference()) && this.isSchemaPropertyMatches(schema1);
    }

    private boolean isSchemaPropertyMatches(Schema schema1) {
        return this.getSchema() != null && schema1.getSchema() != null ? this.getSchema().isEqualTo(schema1.getSchema()) : schema1.getSchema() == this.getSchema();
    }

    public int hashCode() {
        return Objects.hash(this.getReference(), this.getSchema());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder schema() {
        return Schema.newBuilder();
    }

    public static Schema fromAnnotation(org.forgerock.api.annotations.Schema schema, ApiDescription descriptor, Class<?> relativeType) {
        Class<?> type2 = schema.fromType();
        if (type2.equals(Void.class) && Strings.isNullOrEmpty(schema.schemaResource())) {
            return null;
        }
        Builder builder = Schema.schema();
        String id2 = schema.id();
        if (!type2.equals(Void.class)) {
            org.forgerock.api.annotations.Schema typeSchema;
            builder.type(type2);
            if (Strings.isNullOrEmpty(id2) && (typeSchema = type2.getAnnotation(org.forgerock.api.annotations.Schema.class)) != null && !Strings.isNullOrEmpty(typeSchema.id())) {
                id2 = typeSchema.id();
            }
        } else {
            InputStream resource2 = relativeType.getResourceAsStream(schema.schemaResource());
            try {
                org.forgerock.json.JsonValue json = org.forgerock.json.JsonValue.json(JacksonUtils.OBJECT_MAPPER.readValue(resource2, Object.class)).as(new TranslateJsonSchema(relativeType.getClassLoader()));
                builder.schema(json);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read declared resource " + schema.schemaResource(), e);
            }
        }
        if (!Strings.isNullOrEmpty(id2)) {
            descriptor.addDefinition(id2, builder.build());
            return Schema.schema().reference(Reference.reference().value("#/definitions/" + id2).build()).build();
        }
        return builder.build();
    }

    private static final class SchemaSchema
    extends Schema {
        private final org.forgerock.json.JsonValue schema;

        private SchemaSchema(org.forgerock.json.JsonValue schema) {
            this.schema = schema;
        }

        @Override
        @JsonIgnore
        public Reference getReference() {
            return null;
        }

        @Override
        @JsonValue
        public org.forgerock.json.JsonValue getSchema() {
            return this.schema;
        }
    }

    private static final class ReferenceSchema
    extends Schema {
        private final Reference reference;

        private ReferenceSchema(Reference reference2) {
            this.reference = reference2;
        }

        @Override
        @JsonProperty(value="$ref")
        public Reference getReference() {
            return this.reference;
        }

        @Override
        @JsonIgnore
        public org.forgerock.json.JsonValue getSchema() {
            return null;
        }
    }

    public static final class Builder {
        private org.forgerock.json.JsonValue schema;
        private Reference reference;
        private Map<String, Object> jsonValueObject = new HashMap<String, Object>();

        private Builder() {
        }

        @JsonProperty(value="$ref")
        public Builder reference(Reference reference2) {
            Reject.ifNull(reference2);
            this.reference = reference2;
            return this;
        }

        public Builder schema(org.forgerock.json.JsonValue schema) {
            Reject.ifNull(schema);
            this.schema = schema;
            return this;
        }

        @JsonAnySetter
        public Builder schema(String key2, Object value2) {
            this.jsonValueObject.put(key2, value2);
            return this;
        }

        public Builder type(Class<?> type2) {
            Reject.ifNull(type2);
            try {
                JsonSchema jsonSchema = JacksonUtils.schemaFor(type2);
                String schemaString = JacksonUtils.OBJECT_MAPPER.writer().writeValueAsString(jsonSchema);
                this.schema = org.forgerock.json.JsonValue.json(JacksonUtils.OBJECT_MAPPER.readValue(schemaString, Object.class)).as(new TranslateJsonSchema(type2.getClassLoader()));
            }
            catch (JsonMappingException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                throw new IllegalStateException("Jackson cannot read its own JSON", e);
            }
            return this;
        }

        public Schema build() {
            if (!this.jsonValueObject.isEmpty()) {
                this.schema(org.forgerock.json.JsonValue.json(this.jsonValueObject));
            }
            return this.reference == null ? new SchemaSchema(this.schema) : new ReferenceSchema(this.reference);
        }
    }
}

