/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import java.util.Map;
import org.forgerock.json.JsonValue;
import org.forgerock.util.Function;
import org.forgerock.util.i18n.LocalizableString;
import org.forgerock.util.promise.NeverThrowsException;

public class TranslateJsonSchema
implements Function<JsonValue, JsonValue, NeverThrowsException> {
    private final ClassLoader loader;

    public TranslateJsonSchema(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public JsonValue apply(JsonValue value2) {
        JsonValue returnValue = value2;
        if (value2.isCollection()) {
            JsonValue transformedValue = JsonValue.json(JsonValue.array(new Object[0]));
            for (JsonValue item : value2) {
                transformedValue.add(item.as(this).getObject());
            }
            returnValue = transformedValue;
        } else if (value2.isMap()) {
            JsonValue transformedValue = JsonValue.json(JsonValue.object(new Map.Entry[0]));
            for (String key2 : value2.keys()) {
                transformedValue.put(key2, value2.get(key2).as(this).getObject());
            }
            returnValue = transformedValue;
        } else if (value2.isString() && value2.asString().startsWith("i18n:")) {
            returnValue = JsonValue.json(new LocalizableString(value2.asString(), this.loader));
        }
        return returnValue;
    }
}

