/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.transform;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.models.Operation;
import java.util.ArrayList;
import java.util.List;
import org.forgerock.api.transform.LocalizableDescription;
import org.forgerock.util.i18n.LocalizableString;

public class LocalizableOperation
extends Operation
implements LocalizableDescription<Operation> {
    private LocalizableString description;
    private List<LocalizableString> tags;

    @Override
    public LocalizableOperation description(LocalizableString desc) {
        this.description = desc;
        return this;
    }

    @Override
    public LocalizableOperation description(String description) {
        this.setDescription(description);
        return this;
    }

    @Override
    public void setDescription(String description) {
        super.setDescription(description);
        this.description = new LocalizableString(description);
    }

    @Override
    public LocalizableString getLocalizableDescription() {
        return this.description;
    }

    @Override
    public void addTag(String tag2) {
        super.addTag(tag2);
        this.addTag(new LocalizableString(tag2));
    }

    public void addTag(LocalizableString tag2) {
        if (this.tags == null) {
            this.tags = new ArrayList<LocalizableString>();
        }
        this.tags.add(tag2);
    }

    @Override
    public void setTags(List<String> tags) {
        super.setTags(tags);
        tags = new ArrayList<String>();
        for (String tag2 : tags) {
            this.addTag(tag2);
        }
    }

    @JsonProperty(value="tags")
    public List<LocalizableString> getLocalizableTags() {
        return this.tags;
    }

    @Override
    @JsonIgnore
    public List<String> getTags() {
        return super.getTags();
    }
}

