/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.transform;

import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.RefParameter;

public final class OpenApiHelper {
    private OpenApiHelper() {
    }

    public static void addHeaderToAllOperations(HeaderParameter header, Swagger swagger) {
        String headerKey = header.getName() + "_header";
        if (swagger.getParameter(headerKey) != null) {
            throw new IllegalStateException("Header already exists with name: " + header.getName());
        }
        swagger.addParameter(headerKey, header);
        RefParameter refParameter = new RefParameter(headerKey);
        for (Path path2 : swagger.getPaths().values()) {
            for (Operation operation : path2.getOperations()) {
                operation.addParameter(refParameter);
            }
        }
    }

    public static void visitAllOperations(OperationVisitor visitor, Swagger swagger) {
        for (Path path2 : swagger.getPaths().values()) {
            for (Operation operation : path2.getOperations()) {
                visitor.visit(operation);
            }
        }
    }

    public static interface OperationVisitor {
        public void visit(Operation var1);
    }
}

