/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.transform;

import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.RefParameter;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.forgerock.api.enums.CountPolicy;
import org.forgerock.api.enums.PagingMode;
import org.forgerock.api.enums.PatchOperation;
import org.forgerock.api.enums.QueryType;
import org.forgerock.api.enums.Stability;
import org.forgerock.api.markup.asciidoc.AsciiDoc;
import org.forgerock.api.models.Action;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.ApiError;
import org.forgerock.api.models.Create;
import org.forgerock.api.models.Definitions;
import org.forgerock.api.models.Delete;
import org.forgerock.api.models.Items;
import org.forgerock.api.models.Operation;
import org.forgerock.api.models.Patch;
import org.forgerock.api.models.Paths;
import org.forgerock.api.models.Query;
import org.forgerock.api.models.Read;
import org.forgerock.api.models.Reference;
import org.forgerock.api.models.Resource;
import org.forgerock.api.models.Schema;
import org.forgerock.api.models.SubResources;
import org.forgerock.api.models.Update;
import org.forgerock.api.models.VersionedPath;
import org.forgerock.api.transform.LocalizableArrayModel;
import org.forgerock.api.transform.LocalizableArrayProperty;
import org.forgerock.api.transform.LocalizableBinaryProperty;
import org.forgerock.api.transform.LocalizableBodyParameter;
import org.forgerock.api.transform.LocalizableBooleanProperty;
import org.forgerock.api.transform.LocalizableByteArrayProperty;
import org.forgerock.api.transform.LocalizableComposedModel;
import org.forgerock.api.transform.LocalizableDateProperty;
import org.forgerock.api.transform.LocalizableDateTimeProperty;
import org.forgerock.api.transform.LocalizableDoubleProperty;
import org.forgerock.api.transform.LocalizableFloatProperty;
import org.forgerock.api.transform.LocalizableHeaderParameter;
import org.forgerock.api.transform.LocalizableInfo;
import org.forgerock.api.transform.LocalizableIntegerProperty;
import org.forgerock.api.transform.LocalizableLongProperty;
import org.forgerock.api.transform.LocalizableModelImpl;
import org.forgerock.api.transform.LocalizableObjectProperty;
import org.forgerock.api.transform.LocalizableOperation;
import org.forgerock.api.transform.LocalizablePasswordProperty;
import org.forgerock.api.transform.LocalizablePathParameter;
import org.forgerock.api.transform.LocalizableProperty;
import org.forgerock.api.transform.LocalizableQueryParameter;
import org.forgerock.api.transform.LocalizableRefModel;
import org.forgerock.api.transform.LocalizableResponse;
import org.forgerock.api.transform.LocalizableStringProperty;
import org.forgerock.api.transform.LocalizableTag;
import org.forgerock.api.transform.LocalizableTitleAndDescription;
import org.forgerock.api.transform.LocalizableUUIDProperty;
import org.forgerock.api.transform.TransformerException;
import org.forgerock.api.util.PathUtil;
import org.forgerock.api.util.ReferenceResolver;
import org.forgerock.api.util.ValidationUtil;
import org.forgerock.http.routing.Version;
import org.forgerock.http.swagger.SwaggerExtended;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;
import org.forgerock.json.JsonValueFunctions;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.annotations.VisibleForTesting;
import org.forgerock.util.i18n.LocalizableString;
import org.forgerock.util.i18n.PreferredLocales;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiTransformer {
    private static final Logger logger = LoggerFactory.getLogger(OpenApiTransformer.class);
    private static final String EMPTY_STRING = "";
    private static final String PARAMETER_FIELDS = "_fields";
    private static final String PARAMETER_PRETTY_PRINT = "_prettyPrint";
    private static final String PARAMETER_MIME_TYPE = "_mimeType";
    private static final String PARAMETER_IF_MATCH = "If-Match";
    private static final String PARAMETER_IF_NONE_MATCH = "If-None-Match";
    private static final String PARAMETER_IF_NONE_MATCH_ANY_ONLY = "If-None-Match: *";
    private static final String PARAMETER_IF_NONE_MATCH_REV_ONLY = "If-None-Match: <rev>";
    private static final String PARAMETER_LOCATION = "Location";
    static final String DEFINITIONS_REF = "#/definitions/";
    private static final String I18N_PREFIX = "i18n:ApiDescription#";
    private static final String FIELDS_PARAMETER_DESCRIPTION = "i18n:ApiDescription#common.parameters.fields";
    private static final String PRETTYPRINT_PARAMETER_DESCRIPTION = "i18n:ApiDescription#common.parameters.prettyprint";
    private static final String MIMETYPE_PARAMETER_DESCRIPTION = "i18n:ApiDescription#common.parameters.mimetype";
    private static final String LOCATION_PARAMETER_DESCRIPTION = "i18n:ApiDescription#common.parameters.location";
    @VisibleForTesting
    final Swagger swagger;
    private final ReferenceResolver referenceResolver;
    private final ApiDescription apiDescription;
    private final Map<String, Model> definitionMap = new HashMap<String, Model>();
    private final LocalizableStringProperty locationProperty = new LocalizableStringProperty().description(new LocalizableString("i18n:ApiDescription#common.parameters.location", this.getClass().getClassLoader()));

    @VisibleForTesting
    OpenApiTransformer() {
        this.swagger = null;
        this.referenceResolver = null;
        this.apiDescription = null;
    }

    @VisibleForTesting
    OpenApiTransformer(LocalizableString title, String host, String basePath, boolean secure, ApiDescription apiDescription, ApiDescription ... externalApiDescriptions) {
        this.apiDescription = Reject.checkNotNull(apiDescription, "apiDescription required");
        this.swagger = new SwaggerExtended().scheme(secure ? Scheme.HTTPS : Scheme.HTTP).host(host).consumes("application/json").consumes("text/plain").consumes("multipart/form-data").produces("application/json").info(this.buildInfo(title));
        if (!ValidationUtil.isEmpty(basePath)) {
            this.swagger.basePath(PathUtil.buildPath(basePath, new String[0]));
        }
        this.referenceResolver = new ReferenceResolver(apiDescription);
        if (externalApiDescriptions != null) {
            this.referenceResolver.registerAll(externalApiDescriptions);
        }
    }

    public static Swagger execute(LocalizableString title, String host, String basePath, boolean secure, ApiDescription apiDescription, ApiDescription ... externalApiDescriptions) {
        OpenApiTransformer transformer = new OpenApiTransformer(title, host, basePath, secure, apiDescription, externalApiDescriptions);
        return transformer.doExecute();
    }

    public static Swagger execute(ApiDescription apiDescription, ApiDescription ... externalApiDescriptions) {
        OpenApiTransformer transformer = new OpenApiTransformer(null, null, null, false, apiDescription, externalApiDescriptions);
        return transformer.doExecute();
    }

    private Swagger doExecute() {
        this.buildParameters();
        this.buildPaths();
        this.buildDefinitions();
        return this.swagger;
    }

    private void buildParameters() {
        ClassLoader loader = this.getClass().getClassLoader();
        LocalizableQueryParameter fieldsParameter = new LocalizableQueryParameter();
        fieldsParameter.setName(PARAMETER_FIELDS);
        fieldsParameter.setType("string");
        fieldsParameter.setCollectionFormat("csv");
        fieldsParameter.description(new LocalizableString(FIELDS_PARAMETER_DESCRIPTION, loader));
        this.swagger.addParameter(fieldsParameter.getName(), fieldsParameter);
        LocalizableQueryParameter prettyPrintParameter = new LocalizableQueryParameter();
        prettyPrintParameter.setName(PARAMETER_PRETTY_PRINT);
        prettyPrintParameter.setType("boolean");
        prettyPrintParameter.description(new LocalizableString(PRETTYPRINT_PARAMETER_DESCRIPTION, loader));
        this.swagger.addParameter(prettyPrintParameter.getName(), prettyPrintParameter);
        LocalizableQueryParameter mimeTypeParameter = new LocalizableQueryParameter();
        mimeTypeParameter.setName(PARAMETER_MIME_TYPE);
        mimeTypeParameter.setType("string");
        mimeTypeParameter.description(new LocalizableString(MIMETYPE_PARAMETER_DESCRIPTION, loader));
        this.swagger.addParameter(mimeTypeParameter.getName(), mimeTypeParameter);
        LocalizableHeaderParameter putIfNoneMatchParameter = new LocalizableHeaderParameter();
        putIfNoneMatchParameter.setName(PARAMETER_IF_NONE_MATCH);
        putIfNoneMatchParameter.setType("string");
        putIfNoneMatchParameter.required(true);
        putIfNoneMatchParameter.setEnum(Arrays.asList("*"));
        this.swagger.addParameter(PARAMETER_IF_NONE_MATCH_ANY_ONLY, putIfNoneMatchParameter);
        LocalizableHeaderParameter readIfNoneMatchParameter = new LocalizableHeaderParameter();
        readIfNoneMatchParameter.setName(PARAMETER_IF_NONE_MATCH);
        readIfNoneMatchParameter.setType("string");
        this.swagger.addParameter(PARAMETER_IF_NONE_MATCH_REV_ONLY, readIfNoneMatchParameter);
        LocalizableHeaderParameter ifMatchParameter = new LocalizableHeaderParameter();
        ifMatchParameter.setName(PARAMETER_IF_MATCH);
        ifMatchParameter.setType("string");
        ifMatchParameter.setDefault("*");
        this.swagger.addParameter(ifMatchParameter.getName(), ifMatchParameter);
    }

    private void buildPaths() {
        Paths paths = this.apiDescription.getPaths();
        if (paths != null) {
            LinkedHashMap<String, Path> pathMap = new LinkedHashMap<String, Path>();
            ArrayList<String> pathNames = new ArrayList<String>(paths.getNames());
            Collections.sort(pathNames);
            for (String pathName : pathNames) {
                VersionedPath versionedPath = paths.get(pathName);
                ArrayList<Version> versions = new ArrayList<Version>(versionedPath.getVersions());
                Collections.sort(versions);
                for (Version version : versions) {
                    String versionName = VersionedPath.UNVERSIONED.equals(version) ? EMPTY_STRING : version.toString();
                    Resource resource2 = this.resolveResourceReference(versionedPath.get(version));
                    String normalizedPathName = pathName.isEmpty() ? "/" : PathUtil.buildPath(pathName, new String[0]);
                    this.buildResourcePaths(resource2, normalizedPathName, null, versionName, Collections.emptyList(), pathMap);
                }
            }
            this.swagger.setPaths(pathMap);
        }
    }

    private Resource resolveResourceReference(Resource resource2) {
        Reference resourceReference = resource2.getReference();
        if (resourceReference != null && (resource2 = this.referenceResolver.getService(resourceReference)) == null) {
            throw new TransformerException("Unresolvable reference: " + resourceReference.getValue());
        }
        return resource2;
    }

    private void buildResourcePaths(Resource resource2, final String pathName, LocalizableString parentTag, final String resourceVersion, List<org.forgerock.api.models.Parameter> parameters2, Map<String, Path> pathMap) {
        final boolean hasResourceVersion = !ValidationUtil.isEmpty(resourceVersion);
        String pathNamespace = hasResourceVersion ? AsciiDoc.normalizeName(pathName, resourceVersion) : AsciiDoc.normalizeName(pathName);
        LocalizableString tag2 = parentTag;
        if (tag2 == null || ValidationUtil.isEmpty(tag2.toString())) {
            final LocalizableString title = resource2.getTitle();
            final String titleString = title.toString();
            tag2 = new LocalizableString(hasResourceVersion ? titleString + " v" + resourceVersion : titleString){

                @Override
                public String toTranslatedString(PreferredLocales locales) {
                    String tag2;
                    String string2 = tag2 = !ValidationUtil.isEmpty(titleString) ? title.toTranslatedString(locales) : pathName;
                    if (hasResourceVersion) {
                        tag2 = tag2 + " v" + resourceVersion;
                    }
                    return tag2;
                }
            };
            this.swagger.addTag(new LocalizableTag().name(tag2));
        }
        Schema resourceSchema = null;
        if (resource2.getResourceSchema() != null) {
            resourceSchema = resource2.getResourceSchema();
        }
        List<org.forgerock.api.models.Parameter> operationParameters = Collections.unmodifiableList(PathUtil.mergeParameters(new ArrayList<org.forgerock.api.models.Parameter>(parameters2), resource2.getParameters()));
        this.buildCreate(resource2, pathName, pathNamespace, tag2, resourceVersion, resourceSchema, operationParameters, pathMap);
        this.buildRead(resource2, pathName, pathNamespace, tag2, resourceVersion, resourceSchema, operationParameters, pathMap);
        this.buildUpdate(resource2, pathName, pathNamespace, tag2, resourceVersion, resourceSchema, operationParameters, pathMap);
        this.buildDelete(resource2, pathName, pathNamespace, tag2, resourceVersion, resourceSchema, operationParameters, pathMap);
        this.buildPatch(resource2, pathName, pathNamespace, tag2, resourceVersion, resourceSchema, operationParameters, pathMap);
        this.buildActions(resource2, pathName, pathNamespace, tag2, resourceVersion, operationParameters, pathMap);
        this.buildQueries(resource2, pathName, pathNamespace, tag2, resourceVersion, resourceSchema, operationParameters, pathMap);
        this.buildItems(resource2, pathName, tag2, resourceVersion, parameters2, pathMap);
        this.buildSubResources(resource2.getSubresources(), pathName, resourceVersion, parameters2, pathMap);
    }

    private void buildItems(Resource resource2, String pathName, LocalizableString parentTag, String resourceVersion, List<org.forgerock.api.models.Parameter> parameters2, Map<String, Path> pathMap) {
        if (resource2.getItems() != null) {
            Items items = resource2.getItems();
            Resource itemsResource = items.asResource(resource2.isMvccSupported(), resource2.getResourceSchema(), resource2.getTitle(), resource2.getDescription());
            org.forgerock.api.models.Parameter pathParameter = items.getPathParameter();
            List<org.forgerock.api.models.Parameter> itemsParameters = Collections.unmodifiableList(PathUtil.mergeParameters(PathUtil.mergeParameters(new ArrayList<org.forgerock.api.models.Parameter>(parameters2), resource2.getParameters()), pathParameter));
            String itemsPath = PathUtil.buildPath(pathName, "/{" + pathParameter.getName() + "}");
            this.buildSubResources(items.getSubresources(), itemsPath, resourceVersion, itemsParameters, pathMap);
            this.buildResourcePaths(itemsResource, itemsPath, parentTag, resourceVersion, itemsParameters, pathMap);
        }
    }

    private void buildSubResources(SubResources subResources, String pathName, String resourceVersion, List<org.forgerock.api.models.Parameter> parameters2, Map<String, Path> pathMap) {
        if (subResources != null) {
            ArrayList<String> subPathNames = new ArrayList<String>(subResources.getNames());
            Collections.sort(subPathNames);
            for (String name2 : subPathNames) {
                List<org.forgerock.api.models.Parameter> subresourcesParameters = PathUtil.mergeParameters(new ArrayList<org.forgerock.api.models.Parameter>(parameters2), PathUtil.buildPathParameters(name2));
                String subPathName = PathUtil.buildPath(pathName, name2);
                Resource subResource = this.resolveResourceReference(subResources.get(name2));
                this.buildResourcePaths(subResource, subPathName, null, resourceVersion, Collections.unmodifiableList(subresourcesParameters), pathMap);
            }
        }
    }

    private void buildCreate(Resource resource2, String pathName, String pathNamespace, LocalizableString tag2, String resourceVersion, Schema resourceSchema, List<org.forgerock.api.models.Parameter> parameters2, Map<String, Path> pathMap) {
        if (resource2.getCreate() != null) {
            Create create2 = resource2.getCreate();
            switch (create2.getMode()) {
                case ID_FROM_CLIENT: {
                    String createPutNamespace = AsciiDoc.normalizeName(pathNamespace, "create", "put");
                    String createPutPathFragment = AsciiDoc.normalizeName(resourceVersion, "create", "put");
                    LocalizableOperation putOperation = this.buildOperation(create2, createPutNamespace, resourceSchema, resourceSchema, parameters2);
                    putOperation.setSummary("Create with Client-Assigned ID");
                    if (resource2.isMvccSupported().booleanValue()) {
                        putOperation.addParameter(new RefParameter(PARAMETER_IF_NONE_MATCH_ANY_ONLY));
                    }
                    this.addOperation(putOperation, "put", pathName, createPutPathFragment, resourceVersion, tag2, pathMap);
                    break;
                }
                case ID_FROM_SERVER: {
                    String createPostNamespace = AsciiDoc.normalizeName(pathNamespace, "create", "post");
                    String createPostPathFragment = AsciiDoc.normalizeName(resourceVersion, "create", "post");
                    LocalizableOperation postOperation = this.buildOperation(create2, createPostNamespace, resourceSchema, resourceSchema, parameters2);
                    postOperation.setSummary("Create with Server-Assigned ID");
                    this.addOperation(postOperation, "post", pathName, createPostPathFragment, resourceVersion, tag2, pathMap);
                    break;
                }
                default: {
                    throw new TransformerException("Unsupported CreateMode: " + (Object)((Object)create2.getMode()));
                }
            }
        }
    }

    private void buildRead(Resource resource2, String pathName, String pathNamespace, LocalizableString tag2, String resourceVersion, Schema resourceSchema, List<org.forgerock.api.models.Parameter> parameters2, Map<String, Path> pathMap) {
        if (resource2.getRead() != null) {
            String operationNamespace = AsciiDoc.normalizeName(pathNamespace, "read");
            String operationPathFragment = AsciiDoc.normalizeName(resourceVersion, "read");
            Read read2 = resource2.getRead();
            LocalizableOperation operation = this.buildOperation(read2, operationNamespace, null, resourceSchema, parameters2);
            operation.setSummary("Read");
            operation.addParameter(new RefParameter(PARAMETER_MIME_TYPE));
            if (resource2.isMvccSupported().booleanValue()) {
                operation.addParameter(new RefParameter(PARAMETER_IF_NONE_MATCH_REV_ONLY));
            }
            this.addOperation(operation, "get", pathName, operationPathFragment, resourceVersion, tag2, pathMap);
        }
    }

    private void buildUpdate(Resource resource2, String pathName, String pathNamespace, LocalizableString tag2, String resourceVersion, Schema resourceSchema, List<org.forgerock.api.models.Parameter> parameters2, Map<String, Path> pathMap) {
        if (resource2.getUpdate() != null) {
            String operationNamespace = AsciiDoc.normalizeName(pathNamespace, "update");
            String operationPathFragment = AsciiDoc.normalizeName(resourceVersion, "update");
            Update update2 = resource2.getUpdate();
            LocalizableOperation operation = this.buildOperation(update2, operationNamespace, resourceSchema, resourceSchema, parameters2);
            operation.setSummary("Update");
            if (resource2.isMvccSupported().booleanValue()) {
                operation.addParameter(new RefParameter(PARAMETER_IF_MATCH));
            }
            this.addOperation(operation, "put", pathName, operationPathFragment, resourceVersion, tag2, pathMap);
        }
    }

    private void buildDelete(Resource resource2, String pathName, String pathNamespace, LocalizableString tag2, String resourceVersion, Schema resourceSchema, List<org.forgerock.api.models.Parameter> parameters2, Map<String, Path> pathMap) {
        if (resource2.getDelete() != null) {
            String operationNamespace = AsciiDoc.normalizeName(pathNamespace, "delete");
            String operationPathFragment = AsciiDoc.normalizeName(resourceVersion, "delete");
            Delete delete2 = resource2.getDelete();
            LocalizableOperation operation = this.buildOperation(delete2, operationNamespace, null, resourceSchema, parameters2);
            operation.setSummary("Delete");
            if (resource2.isMvccSupported().booleanValue()) {
                operation.addParameter(new RefParameter(PARAMETER_IF_MATCH));
            }
            this.addOperation(operation, "delete", pathName, operationPathFragment, resourceVersion, tag2, pathMap);
        }
    }

    private void buildPatch(Resource resource2, String pathName, String pathNamespace, LocalizableString tag2, String resourceVersion, Schema resourceSchema, List<org.forgerock.api.models.Parameter> parameters2, Map<String, Path> pathMap) {
        if (resource2.getPatch() != null) {
            String operationNamespace = AsciiDoc.normalizeName(pathNamespace, "patch");
            String operationPathFragment = AsciiDoc.normalizeName(resourceVersion, "patch");
            Patch patch = resource2.getPatch();
            Schema requestSchema = this.buildPatchRequestPayload(patch.getOperations());
            LocalizableOperation operation = this.buildOperation(patch, operationNamespace, requestSchema, resourceSchema, parameters2);
            operation.setSummary("Update via Patch Operations");
            if (resource2.isMvccSupported().booleanValue()) {
                operation.addParameter(new RefParameter(PARAMETER_IF_MATCH));
            }
            this.addOperation(operation, "patch", pathName, operationPathFragment, resourceVersion, tag2, pathMap);
        }
    }

    private void buildActions(Resource resource2, String pathName, String pathNamespace, LocalizableString tag2, String resourceVersion, List<org.forgerock.api.models.Parameter> parameters2, Map<String, Path> pathMap) {
        if (!ValidationUtil.isEmpty(resource2.getActions())) {
            String operationNamespace = AsciiDoc.normalizeName(pathNamespace, "action");
            String operationPathFragment = AsciiDoc.normalizeName(resourceVersion, "action");
            for (Action action : resource2.getActions()) {
                String actionNamespace = AsciiDoc.normalizeName(operationNamespace, action.getName());
                String actionPathFragment = AsciiDoc.normalizeName(operationPathFragment, action.getName());
                LocalizableOperation operation = this.buildOperation(action, actionNamespace, action.getRequest(), action.getResponse(), parameters2);
                operation.setSummary("Action: " + action.getName());
                LocalizableQueryParameter actionParameter = new LocalizableQueryParameter();
                actionParameter.setName("_action");
                actionParameter.setType("string");
                actionParameter.setEnum(Arrays.asList(action.getName()));
                actionParameter.setRequired(true);
                operation.addParameter(actionParameter);
                this.addOperation(operation, "post", pathName, actionPathFragment, resourceVersion, tag2, pathMap);
            }
        }
    }

    private void buildQueries(Resource resource2, String pathName, String pathNamespace, LocalizableString tag2, String resourceVersion, Schema resourceSchema, List<org.forgerock.api.models.Parameter> parameters2, Map<String, Path> pathMap) {
        if (!ValidationUtil.isEmpty(resource2.getQueries())) {
            String operationNamespace = AsciiDoc.normalizeName(pathNamespace, "query");
            String operationPathFragment = AsciiDoc.normalizeName(resourceVersion, "query");
            for (Query query : resource2.getQueries()) {
                LocalizableQueryParameter queryParameter;
                String summary;
                String queryPathFragment;
                String queryNamespace;
                switch (query.getType()) {
                    case ID: {
                        queryNamespace = AsciiDoc.normalizeName(operationNamespace, "id", query.getQueryId());
                        queryPathFragment = AsciiDoc.normalizeName(operationPathFragment, "id", query.getQueryId());
                        summary = "Query by ID: " + query.getQueryId();
                        queryParameter = new LocalizableQueryParameter();
                        queryParameter.setName("_queryId");
                        queryParameter.setType("string");
                        queryParameter.setEnum(Arrays.asList(query.getQueryId()));
                        queryParameter.setRequired(true);
                        break;
                    }
                    case FILTER: {
                        queryNamespace = AsciiDoc.normalizeName(operationNamespace, "filter");
                        queryPathFragment = AsciiDoc.normalizeName(operationPathFragment, "filter");
                        summary = "Query by Filter";
                        queryParameter = new LocalizableQueryParameter();
                        queryParameter.setName("_queryFilter");
                        queryParameter.setType("string");
                        queryParameter.setRequired(true);
                        break;
                    }
                    case EXPRESSION: {
                        queryNamespace = AsciiDoc.normalizeName(operationNamespace, "expression");
                        queryPathFragment = AsciiDoc.normalizeName(operationPathFragment, "expression");
                        summary = "Query by Expression";
                        queryParameter = new LocalizableQueryParameter();
                        queryParameter.setName("_queryExpression");
                        queryParameter.setType("string");
                        queryParameter.setRequired(true);
                        break;
                    }
                    default: {
                        throw new TransformerException("Unsupported QueryType: " + (Object)((Object)query.getType()));
                    }
                }
                Schema responsePayload = resourceSchema.getSchema() != null && !"array".equals(resourceSchema.getSchema().get("type").asString()) ? Schema.schema().schema(JsonValue.json(JsonValue.object(JsonValue.field("type", "array"), JsonValue.field("items", resourceSchema.getSchema())))).build() : resourceSchema;
                LocalizableOperation operation = this.buildOperation(query, queryNamespace, null, responsePayload, parameters2);
                operation.setSummary(summary);
                operation.addParameter(queryParameter);
                LocalizableQueryParameter pageSizeParamter = new LocalizableQueryParameter();
                pageSizeParamter.setName("_pageSize");
                pageSizeParamter.setType("integer");
                operation.addParameter(pageSizeParamter);
                if (query.getPagingModes() != null) {
                    for (PagingMode pagingMode : query.getPagingModes()) {
                        LocalizableQueryParameter parameter = new LocalizableQueryParameter();
                        switch (pagingMode) {
                            case COOKIE: {
                                parameter.setName("_pagedResultsCookie");
                                parameter.setType("string");
                                break;
                            }
                            case OFFSET: {
                                parameter.setName("_pagedResultsOffset");
                                parameter.setType("integer");
                                break;
                            }
                            default: {
                                throw new TransformerException("Unsupported PagingMode: " + (Object)((Object)pagingMode));
                            }
                        }
                        operation.addParameter(parameter);
                    }
                }
                LocalizableQueryParameter totalPagedResultsPolicyParameter = new LocalizableQueryParameter();
                totalPagedResultsPolicyParameter.setName("_totalPagedResultsPolicy");
                totalPagedResultsPolicyParameter.setType("string");
                ArrayList<String> totalPagedResultsPolicyValues = new ArrayList<String>();
                if (query.getCountPolicies() == null || query.getCountPolicies().length == 0) {
                    totalPagedResultsPolicyValues.add(CountPolicy.NONE.name());
                } else {
                    for (CountPolicy countPolicy : query.getCountPolicies()) {
                        totalPagedResultsPolicyValues.add(countPolicy.name());
                    }
                }
                totalPagedResultsPolicyParameter._enum(totalPagedResultsPolicyValues);
                operation.addParameter(totalPagedResultsPolicyParameter);
                if (query.getType() != QueryType.ID) {
                    LocalizableQueryParameter sortKeysParameter = new LocalizableQueryParameter();
                    sortKeysParameter.setName("_sortKeys");
                    sortKeysParameter.setType("string");
                    if (!ValidationUtil.isEmpty(query.getSupportedSortKeys())) {
                        sortKeysParameter.setEnum(Arrays.asList(query.getSupportedSortKeys()));
                    }
                    operation.addParameter(sortKeysParameter);
                }
                this.addOperation(operation, "get", pathName, queryPathFragment, resourceVersion, tag2, pathMap);
            }
        }
    }

    private LocalizableOperation buildOperation(Operation operationModel, String operationNamespace, Schema requestPayload, Schema responsePayload, List<org.forgerock.api.models.Parameter> parameters2) {
        LocalizableOperation operation = new LocalizableOperation();
        operation.setOperationId(operationNamespace);
        operation.description(operationModel.getDescription());
        this.applyOperationStability(operationModel.getStability(), operation);
        this.applyOperationParameters(PathUtil.mergeParameters(new ArrayList<org.forgerock.api.models.Parameter>(parameters2), operationModel.getParameters()), operation);
        this.applyOperationRequestPayload(requestPayload, operation);
        this.applyOperationResponsePayloads(responsePayload, operationModel.getApiErrors(), operationModel, operation);
        return operation;
    }

    private void addOperation(LocalizableOperation operation, String method2, String pathName, String pathFragment, String resourceVersion, LocalizableString tag2, Map<String, Path> pathMap) {
        Path operationPath;
        boolean showPathFragment = false;
        if (!ValidationUtil.isEmpty(resourceVersion)) {
            showPathFragment = true;
            operation.setVendorExtension("x-resourceVersion", resourceVersion);
            operation.addParameter((Parameter)((HeaderParameter)((HeaderParameter)((HeaderParameter)new HeaderParameter().name("Accept-API-Version")).type("string")).required(true))._enum(Collections.singletonList("resource=" + resourceVersion)));
        }
        if (!ValidationUtil.isEmpty(tag2.toString())) {
            operation.addTag(tag2);
        }
        if ((operationPath = pathMap.get(pathName)) == null) {
            operationPath = new Path();
        } else if (!showPathFragment) {
            switch (method2) {
                case "get": {
                    showPathFragment = operationPath.getGet() != null;
                    break;
                }
                case "post": {
                    showPathFragment = operationPath.getPost() != null;
                    break;
                }
                case "put": {
                    showPathFragment = operationPath.getPut() != null;
                    break;
                }
                case "delete": {
                    showPathFragment = operationPath.getDelete() != null;
                    break;
                }
                case "patch": {
                    showPathFragment = operationPath.getPatch() != null;
                    break;
                }
                default: {
                    throw new TransformerException("Unsupported method: " + method2);
                }
            }
        }
        if (showPathFragment) {
            if (pathName.indexOf(35) != -1) {
                throw new TransformerException("pathName cannot contain # character");
            }
            String uniquePath = pathName + '#' + pathFragment;
            if (pathMap.containsKey(uniquePath)) {
                throw new TransformerException("pathFragment is not unique for given pathName");
            }
            operationPath = new Path();
            pathMap.put(uniquePath, operationPath);
        } else {
            pathMap.put(pathName, operationPath);
        }
        if (operationPath.set(method2, operation) == null) {
            throw new TransformerException("Unsupported method: " + method2);
        }
    }

    private void applyOperationStability(Stability stability, io.swagger.models.Operation operation) {
        if (stability == Stability.DEPRECATED || stability == Stability.REMOVED) {
            operation.setDeprecated(Boolean.TRUE);
        }
    }

    private void applyOperationParameters(List<org.forgerock.api.models.Parameter> parameters2, io.swagger.models.Operation operation) {
        if (!parameters2.isEmpty()) {
            for (org.forgerock.api.models.Parameter parameter : parameters2) {
                AbstractSerializableParameter operationParameter;
                switch (parameter.getSource()) {
                    case PATH: {
                        operationParameter = new LocalizablePathParameter();
                        break;
                    }
                    case ADDITIONAL: {
                        operationParameter = new LocalizableQueryParameter();
                        break;
                    }
                    default: {
                        throw new TransformerException("Unsupported ParameterSource: " + (Object)((Object)parameter.getSource()));
                    }
                }
                operationParameter.setName(parameter.getName());
                operationParameter.setType(parameter.getType());
                operationParameter.description(parameter.getDescription());
                operationParameter.setRequired(ValidationUtil.nullToFalse(parameter.isRequired()));
                if (!ValidationUtil.isEmpty(parameter.getEnumValues())) {
                    operationParameter.setEnum(Arrays.asList(parameter.getEnumValues()));
                    if (!ValidationUtil.isEmpty(parameter.getEnumTitles())) {
                        operationParameter.getVendorExtensions().put("x-enum_titles", Arrays.asList(parameter.getEnumTitles()));
                    }
                }
                operation.addParameter(operationParameter);
            }
        }
        operation.addParameter(new RefParameter(PARAMETER_FIELDS));
        operation.addParameter(new RefParameter(PARAMETER_PRETTY_PRINT));
    }

    private void applyOperationRequestPayload(Schema schema, io.swagger.models.Operation operation) {
        if (schema != null) {
            Model model;
            if (schema.getSchema() != null) {
                model = this.buildModel(schema.getSchema());
            } else {
                String ref = this.getDefinitionsReference(schema.getReference());
                if (ref == null) {
                    throw new TransformerException("Invalid JSON ref");
                }
                model = new RefModel(ref);
            }
            LocalizableBodyParameter parameter = new LocalizableBodyParameter();
            parameter.setName("requestPayload");
            parameter.setSchema(model);
            parameter.setRequired(true);
            operation.addParameter(parameter);
        }
    }

    private void applyOperationResponsePayloads(Schema schema, ApiError[] apiErrorResponses, Operation operationModel, io.swagger.models.Operation operation) {
        HashMap<String, Response> responses = new HashMap<String, Response>();
        if (schema != null) {
            Response response = new Response();
            response.description("Success");
            if (schema.getSchema() != null) {
                Model model = this.buildModel(schema.getSchema());
                String name2 = UUID.randomUUID() + "-response";
                this.definitionMap.put(name2, model);
                response.schema(new RefProperty(name2));
            } else {
                String string2 = this.getDefinitionsReference(schema.getReference());
                if (string2 == null) {
                    throw new TransformerException("Invalid JSON ref");
                }
                response.schema(new RefProperty(string2));
            }
            if (operationModel instanceof Create) {
                response.addHeader(PARAMETER_LOCATION, this.locationProperty);
                responses.put("201", response);
            } else {
                responses.put("200", response);
            }
        }
        if (!ValidationUtil.isEmpty(apiErrorResponses)) {
            ArrayList<ApiError> resolvedErrors = new ArrayList<ApiError>(apiErrorResponses.length);
            for (ApiError error2 : apiErrorResponses) {
                resolvedErrors.add(this.resolveErrorReference(error2));
            }
            Collections.sort(resolvedErrors, ApiError.ERROR_COMPARATOR);
            int n = resolvedErrors.size();
            for (int i2 = 0; i2 < n; ++i2) {
                ApiError apiError = (ApiError)resolvedErrors.get(i2);
                int code = apiError.getCode();
                final ArrayList<LocalizableString> descriptions = new ArrayList<LocalizableString>();
                if (apiError.getDescription() != null) {
                    descriptions.add(apiError.getDescription());
                }
                for (int k = i2 + 1; k < n; ++k) {
                    ApiError error3 = (ApiError)resolvedErrors.get(k);
                    if (error3.getCode() != code) continue;
                    if (error3.getDescription() != null) {
                        descriptions.add(error3.getDescription());
                    }
                    ++i2;
                }
                JsonValue errorCause = null;
                if (apiError.getSchema() != null && apiError.getSchema().getSchema() != null) {
                    errorCause = apiError.getSchema().getSchema();
                }
                JsonValue errorJsonSchema = JsonValue.json(JsonValue.object(JsonValue.field("type", "object"), JsonValue.field("required", JsonValue.array("code", "message")), JsonValue.field("properties", JsonValue.object(JsonValue.field("code", JsonValue.object(JsonValue.field("type", "integer"), JsonValue.field("title", "Code"), JsonValue.field("description", "3-digit apiError code, corresponding to HTTP status codes."))), JsonValue.field("message", JsonValue.object(JsonValue.field("type", "string"), JsonValue.field("title", "Message"), JsonValue.field("description", "ApiError message."))), JsonValue.field("reason", JsonValue.object(JsonValue.field("type", "string"), JsonValue.field("title", "Reason"), JsonValue.field("description", "Short description corresponding to apiError code."))), JsonValue.field("detail", JsonValue.object(JsonValue.field("type", "string"), JsonValue.field("title", "Detail"), JsonValue.field("description", "Detailed apiError message."))), JsonValue.fieldIfNotNull("cause", errorCause)))));
                LocalizableResponse response = new LocalizableResponse();
                if (descriptions.size() == 1) {
                    response.description((LocalizableString)descriptions.get(0));
                } else if (!descriptions.isEmpty()) {
                    response.description(new LocalizableString("Aggregated bullet description list"){

                        @Override
                        public String toTranslatedString(PreferredLocales locales) {
                            AsciiDoc bulletedList = AsciiDoc.asciiDoc();
                            for (LocalizableString listItem : descriptions) {
                                bulletedList.unorderedList1(listItem.toTranslatedString(locales));
                            }
                            return bulletedList.toString();
                        }
                    });
                }
                Model model = this.buildModel(errorJsonSchema);
                String name3 = UUID.randomUUID() + "-error";
                this.definitionMap.put(name3, model);
                response.schema(new RefProperty(name3));
                responses.put(String.valueOf(code), response);
            }
        }
        operation.setResponses(responses);
    }

    private ApiError resolveErrorReference(ApiError apiError) {
        if (apiError.getReference() != null && (apiError = this.referenceResolver.getError(apiError.getReference())) == null) {
            throw new TransformerException("Error reference not found in global error definitions");
        }
        return apiError;
    }

    @VisibleForTesting
    Schema buildPatchRequestPayload(PatchOperation[] patchOperations) {
        ArrayList<String> enumArray = new ArrayList<String>(patchOperations.length);
        for (PatchOperation op : patchOperations) {
            enumArray.add(op.name().toLowerCase(Locale.ROOT));
        }
        JsonValue schemaValue = JsonValue.json(JsonValue.object(JsonValue.field("type", "array"), JsonValue.field("items", JsonValue.object(JsonValue.field("type", "object"), JsonValue.field("properties", JsonValue.object(JsonValue.field("operation", JsonValue.object(JsonValue.field("type", "string"), JsonValue.field("enum", enumArray), JsonValue.field("required", true))), JsonValue.field("field", JsonValue.object(JsonValue.field("type", "string"))), JsonValue.field("from", JsonValue.object(JsonValue.field("type", "string"))), JsonValue.field("value", JsonValue.object(JsonValue.field("type", "string")))))))));
        return Schema.schema().schema(schemaValue).build();
    }

    @VisibleForTesting
    Info buildInfo(LocalizableString title) {
        return new LocalizableInfo().title(title != null ? title : new LocalizableString(this.apiDescription.getId())).description(this.apiDescription.getDescription()).version(this.apiDescription.getVersion());
    }

    @VisibleForTesting
    void buildDefinitions() {
        Definitions definitions = this.apiDescription.getDefinitions();
        if (definitions != null) {
            Set<String> definitionNames = definitions.getNames();
            for (String name2 : definitionNames) {
                Schema schema = definitions.get(name2);
                if (schema.getSchema() == null) continue;
                this.definitionMap.put(name2, this.buildModel(schema.getSchema()));
            }
        }
        if (!this.definitionMap.isEmpty()) {
            this.swagger.setDefinitions(this.definitionMap);
        }
    }

    @VisibleForTesting
    Model buildModel(JsonValue schema) {
        String type2 = schema.get("type").asString();
        if (type2 == null) {
            if (schema.isDefined("allOf")) {
                return this.buildAllOfModel(schema);
            }
            if (schema.isDefined("$ref")) {
                return this.buildReferenceModel(schema);
            }
            throw new TransformerException(this.unsupportedJsonSchema(schema));
        }
        switch (type2) {
            case "object": {
                return this.buildObjectModel(schema);
            }
            case "array": {
                return this.buildArrayModel(schema);
            }
            case "null": {
                return new ModelImpl().type(type2);
            }
            case "boolean": 
            case "integer": 
            case "number": 
            case "string": {
                return this.buildScalarModel(schema, type2);
            }
        }
        throw new TransformerException("Unsupported JSON Schema type '" + type2 + "' in schema " + schema);
    }

    private Model buildAllOfModel(JsonValue schema) {
        List<Model> allOf = schema.get("allOf").as(JsonValueFunctions.listOf(this.model()));
        if (allOf == null || allOf.isEmpty()) {
            throw new TransformerException(this.unsupportedJsonSchema(schema));
        }
        LocalizableComposedModel model = new LocalizableComposedModel();
        this.setTitleAndDescriptionFromSchema(model, schema);
        model.setAllOf(allOf);
        return model;
    }

    private String unsupportedJsonSchema(JsonValue schema) {
        return "Unsupported JSON schema: expected 'type', '$ref' or non-empty 'allOf' property in: '" + schema + "'";
    }

    private Model buildReferenceModel(JsonValue schema) {
        LocalizableRefModel model = new LocalizableRefModel();
        this.setTitleAndDescriptionFromSchema(model, schema);
        model.setReference(schema.get("$ref").asString());
        model.setProperties(this.buildProperties(schema));
        return model;
    }

    private Function<JsonValue, Model, JsonValueException> model() {
        return new Function<JsonValue, Model, JsonValueException>(){

            @Override
            public Model apply(JsonValue value2) throws JsonValueException {
                return OpenApiTransformer.this.buildModel(value2);
            }
        };
    }

    private Model buildObjectModel(JsonValue schema) {
        LocalizableModelImpl model = new LocalizableModelImpl();
        model.type("object");
        model.setDiscriminator(schema.get("discriminator").asString());
        model.setProperties(this.buildProperties(schema));
        List<String> required = this.getArrayOfJsonString("required", schema);
        if (!required.isEmpty()) {
            model.setRequired(required);
        }
        model.setAdditionalProperties(this.buildProperty(schema.get("additionalProperties")));
        this.setTitleAndDescriptionFromSchema(model, schema);
        return model;
    }

    private LocalizableModelImpl buildScalarModel(JsonValue schema, String type2) {
        List<String> enumValues;
        LocalizableModelImpl model = new LocalizableModelImpl();
        model.type(type2);
        this.setTitleAndDescriptionFromSchema(model, schema);
        if (schema.get("default").isNotNull()) {
            model.setDefaultValue(schema.get("default").asString());
        }
        if (!(enumValues = this.getArrayOfJsonString("enum", schema)).isEmpty()) {
            List<String> enumTitles;
            model.setEnum(enumValues);
            JsonValue options2 = schema.get("options");
            if (options2.isNotNull() && !(enumTitles = this.getArrayOfJsonString("enum_titles", options2)).isEmpty()) {
                model.setVendorExtension("x-enum_titles", enumTitles);
            }
        }
        if (schema.get("format").isNotNull()) {
            model.setFormat(schema.get("format").asString());
            if ("full-date".equals(model.getFormat()) && "string".equals(type2)) {
                model.setFormat("date");
            }
        }
        return model;
    }

    private Model buildArrayModel(JsonValue schema) {
        LocalizableArrayModel model = new LocalizableArrayModel();
        this.setTitleAndDescriptionFromSchema(model, schema);
        model.setProperties(this.buildProperties(schema));
        model.setItems(this.buildProperty(schema.get("items")));
        return model;
    }

    @VisibleForTesting
    Map<String, Property> buildProperties(JsonValue schema) {
        JsonValue properties;
        if (schema != null && schema.isNotNull() && (properties = schema.get("properties")).isNotNull()) {
            Map<String, Object> propertiesMap = properties.asMap();
            LinkedHashMap<String, Property> resultMap = new LinkedHashMap<String, Property>(propertiesMap.size() * 2);
            boolean sortByPropertyOrder = false;
            for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
                Property property;
                try {
                    property = this.buildProperty(JsonValue.json(entry.getValue()));
                }
                catch (RuntimeException runtimeException) {
                    logger.info("Json schema error: " + entry.getValue() + "\n" + runtimeException.getMessage(), runtimeException.fillInStackTrace());
                    throw runtimeException;
                }
                if (!sortByPropertyOrder && property.getVendorExtensions().containsKey("x-propertyOrder")) {
                    sortByPropertyOrder = true;
                }
                resultMap.put(entry.getKey(), property);
            }
            if (sortByPropertyOrder && resultMap.size() > 1) {
                ArrayList entries2 = new ArrayList(resultMap.entrySet());
                Collections.sort(entries2, new Comparator<Map.Entry<String, Property>>(){

                    @Override
                    public int compare(Map.Entry<String, Property> o1, Map.Entry<String, Property> o2) {
                        Integer v1 = (Integer)o1.getValue().getVendorExtensions().get("x-propertyOrder");
                        Integer v2 = (Integer)o2.getValue().getVendorExtensions().get("x-propertyOrder");
                        if (v1 != null) {
                            if (v2 != null) {
                                return v1.compareTo(v2);
                            }
                            return -1;
                        }
                        if (v2 != null) {
                            return 1;
                        }
                        return 0;
                    }
                });
                LinkedHashMap<String, Property> sortedMap = new LinkedHashMap<String, Property>(propertiesMap.size() * 2);
                for (Map.Entry entry : entries2) {
                    sortedMap.put((String)entry.getKey(), (Property)entry.getValue());
                }
                return sortedMap;
            }
            return resultMap;
        }
        return null;
    }

    @VisibleForTesting
    Property buildProperty(JsonValue schema) {
        Boolean readOnly;
        if (schema == null || schema.isNull()) {
            return null;
        }
        if (schema.get("$ref").isNotNull()) {
            String ref = this.getDefinitionsReference(schema.get("$ref").asString());
            if (ref == null) {
                throw new TransformerException("Invalid JSON ref: " + schema.get("$ref").asString());
            }
            return new RefProperty(ref);
        }
        String format = schema.get("format").asString();
        LocalizableProperty abstractProperty = this.toLocalizableProperty(schema, format);
        if (abstractProperty == null) {
            return null;
        }
        if (!ValidationUtil.isEmpty(format)) {
            abstractProperty.setFormat(format);
        }
        if (!(abstractProperty instanceof LocalizableObjectProperty) && !(abstractProperty instanceof LocalizableArrayProperty) && schema.get("default").isNotNull()) {
            abstractProperty.setDefault(schema.get("default").getObject().toString());
        }
        this.setTitleAndDescriptionFromSchema(abstractProperty, schema);
        String readPolicy = schema.get("readPolicy").asString();
        if (!ValidationUtil.isEmpty(readPolicy)) {
            abstractProperty.setVendorExtension("x-readPolicy", readPolicy);
        }
        if (schema.get("returnOnDemand").isNotNull()) {
            abstractProperty.setVendorExtension("x-returnOnDemand", schema.get("returnOnDemand").asBoolean());
        }
        if (Boolean.TRUE.equals(readOnly = schema.get("readOnly").asBoolean())) {
            abstractProperty.setReadOnly(Boolean.TRUE);
        } else {
            String writePolicy = schema.get("writePolicy").asString();
            if (!ValidationUtil.isEmpty(writePolicy)) {
                abstractProperty.setVendorExtension("x-writePolicy", writePolicy);
                if (schema.get("errorOnWritePolicyFailure").isNotNull()) {
                    abstractProperty.setVendorExtension("x-errorOnWritePolicyFailure", schema.get("errorOnWritePolicyFailure").asBoolean());
                }
            }
        }
        Integer propertyOrder = schema.get("propertyOrder").asInteger();
        if (propertyOrder != null) {
            abstractProperty.setVendorExtension("x-propertyOrder", propertyOrder);
        }
        return abstractProperty;
    }

    private LocalizableProperty toLocalizableProperty(JsonValue schema, String format) {
        String type2;
        switch (type2 = schema.get("type").asString()) {
            case "object": {
                LocalizableObjectProperty property = new LocalizableObjectProperty();
                property.setProperties(this.buildProperties(schema));
                property.setRequiredProperties(this.getArrayOfJsonString("required", schema));
                if (schema.get("default").isNotNull()) {
                    property.setDefault(schema.get("default").getObject());
                }
                return property;
            }
            case "array": {
                LocalizableArrayProperty property = new LocalizableArrayProperty();
                property.setItems(this.buildProperty(schema.get("items")));
                property.setMinItems(schema.get("minItems").asInteger());
                property.setMaxItems(schema.get("maxItems").asInteger());
                property.setUniqueItems(schema.get("uniqueItems").asBoolean());
                if (schema.get("default").isNotNull()) {
                    property.setDefault(schema.get("default").asList());
                }
                return property;
            }
            case "boolean": {
                return new LocalizableBooleanProperty();
            }
            case "integer": {
                BaseIntegerProperty property = "int64".equals(format) ? new LocalizableLongProperty() : new LocalizableIntegerProperty();
                property.setMinimum(schema.get("minimum").asBigDecimal());
                property.setMaximum(schema.get("maximum").asBigDecimal());
                property.setExclusiveMinimum(schema.get("exclusiveMinimum").asBoolean());
                property.setExclusiveMaximum(schema.get("exclusiveMaximum").asBoolean());
                return (LocalizableProperty)((Object)property);
            }
            case "number": {
                AbstractNumericProperty property;
                if (ValidationUtil.isEmpty(format)) {
                    property = new LocalizableDoubleProperty();
                } else {
                    switch (format) {
                        case "int32": {
                            property = new LocalizableIntegerProperty();
                            break;
                        }
                        case "int64": {
                            property = new LocalizableLongProperty();
                            break;
                        }
                        case "float": {
                            property = new LocalizableFloatProperty();
                            break;
                        }
                        default: {
                            property = new LocalizableDoubleProperty();
                        }
                    }
                }
                property.setMinimum(schema.get("minimum").asBigDecimal());
                property.setMaximum(schema.get("maximum").asBigDecimal());
                property.setExclusiveMinimum(schema.get("exclusiveMinimum").asBoolean());
                property.setExclusiveMaximum(schema.get("exclusiveMaximum").asBoolean());
                return (LocalizableProperty)((Object)property);
            }
            case "null": {
                return null;
            }
            case "string": {
                if (ValidationUtil.isEmpty(format)) {
                    LocalizableStringProperty property = new LocalizableStringProperty();
                    property.setMinLength(schema.get("minLength").asInteger());
                    property.setMaxLength(schema.get("maxLength").asInteger());
                    property.setPattern(schema.get("pattern").asString());
                    return property;
                }
                switch (format) {
                    case "byte": {
                        return new LocalizableByteArrayProperty();
                    }
                    case "binary": {
                        LocalizableBinaryProperty property = new LocalizableBinaryProperty();
                        property.setMinLength(schema.get("minLength").asInteger());
                        property.setMaxLength(schema.get("maxLength").asInteger());
                        property.setPattern(schema.get("pattern").asString());
                        return property;
                    }
                    case "date": 
                    case "full-date": {
                        return new LocalizableDateProperty();
                    }
                    case "date-time": {
                        return new LocalizableDateTimeProperty();
                    }
                    case "password": {
                        LocalizablePasswordProperty property = new LocalizablePasswordProperty();
                        property.setMinLength(schema.get("minLength").asInteger());
                        property.setMaxLength(schema.get("maxLength").asInteger());
                        property.setPattern(schema.get("pattern").asString());
                        return property;
                    }
                    case "uuid": {
                        LocalizableUUIDProperty property = new LocalizableUUIDProperty();
                        property.setMinLength(schema.get("minLength").asInteger());
                        property.setMaxLength(schema.get("maxLength").asInteger());
                        property.setPattern(schema.get("pattern").asString());
                        return property;
                    }
                }
                LocalizableStringProperty property = new LocalizableStringProperty();
                property.setMinLength(schema.get("minLength").asInteger());
                property.setMaxLength(schema.get("maxLength").asInteger());
                property.setPattern(schema.get("pattern").asString());
                return property;
            }
        }
        throw new TransformerException("Unsupported JSON schema type: " + type2);
    }

    private List<String> getArrayOfJsonString(String field2, JsonValue schema) {
        JsonValue value2 = schema.get(field2);
        if (value2.isNotNull() && value2.isCollection()) {
            return value2.asList(String.class);
        }
        return Collections.emptyList();
    }

    @VisibleForTesting
    String getDefinitionsReference(Reference reference2) {
        if (reference2 != null) {
            return this.getDefinitionsReference(reference2.getValue());
        }
        return null;
    }

    @VisibleForTesting
    String getDefinitionsReference(String reference2) {
        String s2;
        int start2;
        if (!ValidationUtil.isEmpty(reference2) && (start2 = reference2.indexOf(DEFINITIONS_REF)) != -1 && !(s2 = reference2.substring(start2 + DEFINITIONS_REF.length())).isEmpty()) {
            return s2;
        }
        return null;
    }

    private void setTitleAndDescriptionFromSchema(LocalizableTitleAndDescription<?> model, JsonValue schema) {
        OpenApiTransformer.setTitleFromJsonValue(model, schema.get("title"));
        OpenApiTransformer.setDescriptionFromJsonValue(model, schema.get("description"));
    }

    static void setTitleFromJsonValue(LocalizableTitleAndDescription<?> model, JsonValue source2) {
        if (source2.isString()) {
            model.title(source2.asString());
        } else {
            model.title((LocalizableString)source2.getObject());
        }
    }

    static void setDescriptionFromJsonValue(LocalizableTitleAndDescription<?> model, JsonValue source2) {
        if (source2.isString()) {
            model.description(source2.asString());
        } else {
            model.description((LocalizableString)source2.getObject());
        }
    }
}

