/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.api.enums.ParameterSource;
import org.forgerock.api.models.Parameter;
import org.forgerock.api.util.ValidationUtil;

public final class PathUtil {
    private static final Pattern SQUASH_FORWARD_SLASHES_PATTERN = Pattern.compile("[/]{2,}");
    private static final Pattern TRAILING_SLASHES_PATTERN = Pattern.compile("[/]+$");
    private static final Pattern PATH_VARIABLE_PATTERN = Pattern.compile("\\{([^{}]+)\\}");

    private PathUtil() {
    }

    public static String buildPath(String segment, String ... moreSegments) {
        Matcher m3;
        if (ValidationUtil.isEmpty(segment)) {
            throw new IllegalArgumentException("segment argument required");
        }
        StringBuilder path2 = new StringBuilder().append('/').append(segment);
        if (moreSegments != null) {
            for (String s2 : moreSegments) {
                path2.append('/').append(s2);
            }
        }
        String normalized = (m3 = SQUASH_FORWARD_SLASHES_PATTERN.matcher(path2)).find() ? m3.replaceAll("/") : path2.toString();
        return TRAILING_SLASHES_PATTERN.matcher(normalized).replaceAll("");
    }

    public static Parameter[] buildPathParameters(String pathSegment) {
        Matcher m3;
        if (!ValidationUtil.isEmpty(pathSegment) && (m3 = PATH_VARIABLE_PATTERN.matcher(pathSegment)).find()) {
            ArrayList<Parameter> parameters2 = new ArrayList<Parameter>();
            int start2 = 0;
            while (m3.find(start2)) {
                parameters2.add(Parameter.parameter().name(m3.group(1)).type("string").source(ParameterSource.PATH).required(true).build());
                start2 = m3.end();
            }
            return parameters2.toArray(new Parameter[parameters2.size()]);
        }
        return null;
    }

    public static List<Parameter> mergeParameters(List<Parameter> parameterList, Parameter ... parameters2) {
        if (parameters2 != null) {
            for (Parameter parameter : parameters2) {
                int replaceIndex = -1;
                for (int i2 = 0; i2 < parameterList.size(); ++i2) {
                    if (!parameterList.get(i2).getName().equals(parameter.getName())) continue;
                    replaceIndex = i2;
                    break;
                }
                if (replaceIndex != -1) {
                    parameterList.set(replaceIndex, parameter);
                    continue;
                }
                parameterList.add(parameter);
            }
        }
        return parameterList;
    }
}

