/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.ApiError;
import org.forgerock.api.models.Reference;
import org.forgerock.api.models.Resource;
import org.forgerock.api.models.Schema;
import org.forgerock.util.Reject;

public class ReferenceResolver {
    private static final String DEFINITIONS_REF = "#/definitions/";
    private static final String ERRORS_REF = "#/errors/";
    private static final String SERVICES_REF = "#/services/";
    private final ApiDescription local;
    private final Map<String, ApiDescription> map;

    public ReferenceResolver(ApiDescription local2) {
        this.local = Reject.checkNotNull(local2);
        this.map = new HashMap<String, ApiDescription>();
        this.register(local2);
    }

    public ReferenceResolver register(ApiDescription apiDescription) {
        if (this.map.containsKey(apiDescription.getId())) {
            throw new IllegalStateException("Already registered ID = " + apiDescription.getId());
        }
        this.map.put(apiDescription.getId(), apiDescription);
        return this;
    }

    public ReferenceResolver registerAll(ApiDescription ... apiDescriptions) {
        for (ApiDescription item : apiDescriptions) {
            this.register(item);
        }
        return this;
    }

    public Schema getDefinition(Reference reference2) {
        return this.resolveDefinition(reference2, new HashSet<String>());
    }

    private Schema resolveDefinition(Reference reference2, Set<String> visitedRefs) {
        String name2;
        int nameStart = reference2.getValue().indexOf(DEFINITIONS_REF);
        if (nameStart != -1 && !(name2 = reference2.getValue().substring(nameStart + DEFINITIONS_REF.length())).isEmpty()) {
            if (!visitedRefs.add(reference2.getValue())) {
                throw new IllegalStateException("Reference loop detected: " + reference2.getValue());
            }
            if (nameStart == 0) {
                if (this.local.getDefinitions() != null) {
                    Schema schema = this.local.getDefinitions().get(name2);
                    if (schema != null && schema.getReference() != null) {
                        return this.resolveDefinition(schema.getReference(), visitedRefs);
                    }
                    return schema;
                }
            } else {
                String namespace = reference2.getValue().substring(0, nameStart);
                ApiDescription apiDescription = this.map.get(namespace);
                if (apiDescription != null && apiDescription.getDefinitions() != null) {
                    Schema schema = apiDescription.getDefinitions().get(name2);
                    if (schema != null && schema.getReference() != null) {
                        return this.resolveDefinition(schema.getReference(), visitedRefs);
                    }
                    return schema;
                }
            }
        }
        return null;
    }

    public ApiError getError(Reference reference2) {
        return this.resolveError(reference2, new HashSet<String>());
    }

    private ApiError resolveError(Reference reference2, Set<String> visitedRefs) {
        String name2;
        int nameStart = reference2.getValue().indexOf(ERRORS_REF);
        if (nameStart != -1 && !(name2 = reference2.getValue().substring(nameStart + ERRORS_REF.length())).isEmpty()) {
            if (!visitedRefs.add(reference2.getValue())) {
                throw new IllegalStateException("Reference loop detected: " + reference2.getValue());
            }
            if (nameStart == 0) {
                if (this.local.getErrors() != null) {
                    ApiError error2 = this.local.getErrors().get(name2);
                    if (error2 != null && error2.getReference() != null) {
                        return this.resolveError(error2.getReference(), visitedRefs);
                    }
                    return error2;
                }
            } else {
                String namespace = reference2.getValue().substring(0, nameStart);
                ApiDescription apiDescription = this.map.get(namespace);
                if (apiDescription != null && apiDescription.getErrors() != null) {
                    ApiError error3 = apiDescription.getErrors().get(name2);
                    if (error3 != null && error3.getReference() != null) {
                        return this.resolveError(error3.getReference(), visitedRefs);
                    }
                    return error3;
                }
            }
        }
        return null;
    }

    public Resource getService(Reference reference2) {
        return this.resolveService(reference2, new HashSet<String>());
    }

    private Resource resolveService(Reference reference2, Set<String> visitedRefs) {
        String name2;
        int nameStart = reference2.getValue().indexOf(SERVICES_REF);
        if (nameStart != -1 && !(name2 = reference2.getValue().substring(nameStart + SERVICES_REF.length())).isEmpty()) {
            if (!visitedRefs.add(reference2.getValue())) {
                throw new IllegalStateException("Reference loop detected: " + reference2.getValue());
            }
            if (nameStart == 0) {
                if (this.local.getServices() != null) {
                    Resource service = this.local.getServices().get(name2);
                    if (service != null && service.getReference() != null) {
                        return this.resolveService(service.getReference(), visitedRefs);
                    }
                    return service;
                }
            } else {
                String namespace = reference2.getValue().substring(0, nameStart);
                ApiDescription apiDescription = this.map.get(namespace);
                if (apiDescription != null && apiDescription.getServices() != null) {
                    Resource service = apiDescription.getServices().get(name2);
                    if (service != null && service.getReference() != null) {
                        return this.resolveService(service.getReference(), visitedRefs);
                    }
                    return service;
                }
            }
        }
        return null;
    }
}

