/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.forgerock.http.util.Paths;
import org.forgerock.http.util.Uris;

public final class MutableUri
implements Comparable<MutableUri> {
    private URI uri;
    private List<String> pathElements;

    public static MutableUri uri(String uri) throws URISyntaxException {
        return new MutableUri(uri);
    }

    public MutableUri(URI uri) {
        this.uri = uri;
        this.setPathElements(uri.getRawPath());
    }

    public MutableUri(MutableUri mutableUri) {
        this(mutableUri.asURI());
    }

    public MutableUri(String uri) throws URISyntaxException {
        this(new URI(uri));
    }

    public MutableUri(String scheme, String userInfo, String host, int port, String path2, String query, String fragment) throws URISyntaxException {
        this(new URI(scheme, userInfo, host, port, path2, query, fragment));
    }

    public URI asURI() {
        return this.uri;
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public void setScheme(String scheme) throws URISyntaxException {
        this.uri = Uris.create(scheme, this.uri.getRawUserInfo(), this.uri.getHost(), this.uri.getPort(), this.uri.getRawPath(), this.uri.getRawQuery(), this.uri.getRawFragment());
    }

    public String getUserInfo() {
        return this.uri.getUserInfo();
    }

    public String getRawUserInfo() {
        return this.uri.getRawUserInfo();
    }

    public void setUserInfo(String userInfo) throws URISyntaxException {
        URI other = new URI(null, userInfo, "ignored", -1, null, null, null);
        this.setRawUserInfo(other.getRawUserInfo());
    }

    public void setRawUserInfo(String rawUserInfo) throws URISyntaxException {
        this.uri = Uris.create(this.uri.getScheme(), rawUserInfo, this.uri.getHost(), this.uri.getPort(), this.uri.getRawPath(), this.uri.getRawQuery(), this.uri.getRawFragment());
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public void setHost(String host) throws URISyntaxException {
        this.uri = Uris.create(this.uri.getScheme(), this.uri.getRawUserInfo(), host, this.uri.getPort(), this.uri.getRawPath(), this.uri.getRawQuery(), this.uri.getRawFragment());
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public void setPort(int port) throws URISyntaxException {
        this.uri = Uris.create(this.uri.getScheme(), this.uri.getRawUserInfo(), this.uri.getHost(), port, this.uri.getRawPath(), this.uri.getRawQuery(), this.uri.getRawFragment());
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public String getRawPath() {
        return this.uri.getRawPath();
    }

    public void setPath(String path2) throws URISyntaxException {
        URI other = new URI(null, null, "ignored", -1, path2, null, null);
        this.setRawPath(other.getRawPath());
    }

    public void setRawPath(String rawPath) throws URISyntaxException {
        this.uri = Uris.create(this.uri.getScheme(), this.uri.getRawUserInfo(), this.uri.getHost(), this.uri.getPort(), rawPath, this.uri.getRawQuery(), this.uri.getRawFragment());
        this.setPathElements(this.uri.getRawPath());
    }

    public String getQuery() {
        return this.uri.getQuery();
    }

    public String getRawQuery() {
        return this.uri.getRawQuery();
    }

    public void setQuery(String query) throws URISyntaxException {
        URI other = new URI(null, null, "ignored", -1, null, query, null);
        this.setRawQuery(other.getRawQuery());
    }

    public void setRawQuery(String rawQuery) throws URISyntaxException {
        this.uri = Uris.create(this.uri.getScheme(), this.uri.getRawUserInfo(), this.uri.getHost(), this.uri.getPort(), this.uri.getRawPath(), rawQuery, this.uri.getRawFragment());
    }

    public String getFragment() {
        return this.uri.getFragment();
    }

    public String getRawFragment() {
        return this.uri.getRawFragment();
    }

    public void setFragment(String fragment) throws URISyntaxException {
        URI other = new URI(null, null, "ignored", -1, null, null, fragment);
        this.setRawFragment(other.getRawFragment());
    }

    public void setRawFragment(String rawFragment) throws URISyntaxException {
        this.uri = Uris.create(this.uri.getScheme(), this.uri.getRawUserInfo(), this.uri.getHost(), this.uri.getPort(), this.uri.getRawPath(), this.uri.getRawQuery(), rawFragment);
    }

    public String getAuthority() {
        return this.uri.getAuthority();
    }

    public String getRawAuthority() {
        return this.uri.getRawAuthority();
    }

    private void setPathElements(String rawPath) {
        this.pathElements = new ArrayList<String>(Paths.getPathElements(rawPath)){

            @Override
            public String toString() {
                return Paths.joinPath(this);
            }
        };
    }

    public List<String> getPathElements() {
        return Collections.unmodifiableList(this.pathElements);
    }

    public MutableUri rebase(MutableUri base) {
        if (base == null) {
            return this;
        }
        String scheme = base.getScheme();
        String host = base.getHost();
        int port = base.getPort();
        if (scheme == null || host == null) {
            return this;
        }
        try {
            this.setScheme(scheme);
            this.setHost(host);
            this.setPort(port);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    public MutableUri rebase(URI base) {
        return this.rebase(new MutableUri(base));
    }

    @Override
    public int compareTo(MutableUri o) {
        return this.asURI().compareTo(o.asURI());
    }

    public MutableUri relativize(MutableUri uri) {
        this.uri = this.uri.relativize(uri.asURI());
        this.setPathElements(this.uri.getRawPath());
        return this;
    }

    public MutableUri resolve(MutableUri uri) {
        this.uri = this.uri.resolve(uri.asURI());
        this.setPathElements(this.uri.getRawPath());
        return this;
    }

    public String toString() {
        return this.uri.toString();
    }

    public String toASCIIString() {
        return this.uri.toASCIIString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof MutableUri)) {
            return false;
        }
        MutableUri that = (MutableUri)o;
        return this.uri.equals(that.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }
}

