/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.example;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.swagger.models.Swagger;
import io.swagger.util.DeserializationModule;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.forgerock.http.ApiProducer;
import org.forgerock.http.Handler;
import org.forgerock.http.handler.DescribableHandler;
import org.forgerock.http.header.LocationHeader;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Status;
import org.forgerock.http.routing.RouteMatchers;
import org.forgerock.http.routing.Router;
import org.forgerock.http.routing.RoutingMode;
import org.forgerock.json.JsonValue;
import org.forgerock.services.context.Context;
import org.forgerock.services.descriptor.Describable;
import org.forgerock.util.encode.Base64;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public class DescribedOauth2Endpoint
implements DescribableHandler {
    private static final Swagger DESCRIPTOR;
    private final Map<String, JsonValue> userCodes = new HashMap<String, JsonValue>();
    private final Map<String, String> userTokens = new HashMap<String, String>();
    private final Router router = new Router();
    private Swagger descriptor;

    public DescribedOauth2Endpoint() {
        this.router.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.EQUALS, "authorize"), new Handler(){

            @Override
            public Promise<Response, NeverThrowsException> handle(Context context, Request request) {
                if (!"GET".equals(request.getMethod())) {
                    return Promises.newResultPromise(new Response(Status.METHOD_NOT_ALLOWED));
                }
                String redirectUri = (String)request.getForm().getFirst("redirect_uri");
                if (redirectUri == null) {
                    return Promises.newResultPromise(new Response(Status.BAD_REQUEST));
                }
                String state2 = (String)request.getForm().getFirst("state");
                if (!"code".equals(request.getForm().getFirst("response_type"))) {
                    return this.error(redirectUri, "unsupported_response_type", state2);
                }
                if (!"myclient".equals(request.getForm().getFirst("client_id"))) {
                    return this.error(redirectUri, "unauthorized_client", state2);
                }
                String user = (String)request.getForm().getFirst("user");
                if (user != null) {
                    String code = UUID.randomUUID().toString();
                    DescribedOauth2Endpoint.this.userCodes.put(code, JsonValue.json(JsonValue.object(JsonValue.field("user", user), JsonValue.field("redirect_uri", redirectUri))));
                    return this.code(redirectUri, code, state2);
                }
                Response response = new Response(Status.FOUND);
                response.getHeaders().add(new LocationHeader("login?" + request.getForm().toQueryString()));
                return Promises.newResultPromise(response);
            }

            private Promise<Response, NeverThrowsException> error(String redirectUri, String error2, String state2) {
                return this.redirect(redirectUri, state2, "error=" + error2);
            }

            private Promise<Response, NeverThrowsException> code(String redirectUri, String code, String state2) {
                return this.redirect(redirectUri, state2, "code=" + code);
            }

            private Promise<Response, NeverThrowsException> redirect(String redirectUri, String state2, String suffix) {
                Response response = new Response(Status.FOUND);
                String uri = redirectUri + (redirectUri.contains("?") ? "&" : "?");
                if (state2 != null) {
                    uri = uri + "state=" + state2 + "&";
                }
                response.getHeaders().add(new LocationHeader(uri + suffix));
                return Promises.newResultPromise(response);
            }
        });
        this.router.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.EQUALS, "login"), new Handler(){

            @Override
            public Promise<Response, NeverThrowsException> handle(Context context, Request request) {
                String[] creds;
                String authValue = DescribedOauth2Endpoint.this.getAuthorizationHeader(request);
                if (authValue != null && authValue.startsWith("Basic ") && (creds = new String(Base64.decode(authValue.substring(6))).split(":"))[0].equals(creds[1])) {
                    Response response = new Response(Status.FOUND);
                    response.getHeaders().add(new LocationHeader("authorize?user=" + creds[0] + "&" + request.getForm().toQueryString()));
                    return Promises.newResultPromise(response);
                }
                Response response = new Response(Status.UNAUTHORIZED);
                response.getHeaders().add("WWW-Authenticate", "Basic realm=\"Really Secure OAuth2\"");
                return Promises.newResultPromise(response);
            }
        });
        this.router.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.EQUALS, "token"), new Handler(){

            @Override
            public Promise<Response, NeverThrowsException> handle(Context context, Request request) {
                if (!"POST".equals(request.getMethod())) {
                    return Promises.newResultPromise(new Response(Status.METHOD_NOT_ALLOWED));
                }
                if (!"myclient".equals(request.getForm().getFirst("client_id")) || !"password".equals(request.getForm().getFirst("client_secret"))) {
                    return this.error("invalid_client");
                }
                if (!"authorization_code".equals(request.getForm().getFirst("grant_type"))) {
                    return this.error("unsupported_grant_type");
                }
                String code = (String)request.getForm().getFirst("code");
                if (code == null) {
                    return this.error("invalid_request");
                }
                JsonValue codeDetails = (JsonValue)DescribedOauth2Endpoint.this.userCodes.remove(code);
                if (codeDetails == null) {
                    return this.error("invalid_grant");
                }
                if (!codeDetails.get("redirect_uri").asString().equals(request.getForm().getFirst("redirect_uri"))) {
                    return this.error("invalid_request");
                }
                String token = UUID.randomUUID().toString();
                DescribedOauth2Endpoint.this.userTokens.put(token, codeDetails.get("user").asString());
                return Promises.newResultPromise(new Response(Status.OK).setEntity(JsonValue.json(JsonValue.object(JsonValue.field("access_token", token), JsonValue.field("token_type", "bearer")))));
            }

            private Promise<Response, NeverThrowsException> error(String error2) {
                return Promises.newResultPromise(new Response(Status.BAD_REQUEST).setEntity(JsonValue.json(JsonValue.object(JsonValue.field("error", error2)))));
            }
        });
        this.router.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.EQUALS, "api"), new Handler(){

            @Override
            public Promise<Response, NeverThrowsException> handle(Context context, Request request) {
                String user;
                if (!"GET".equals(request.getMethod())) {
                    return Promises.newResultPromise(new Response(Status.METHOD_NOT_ALLOWED));
                }
                String authValue = DescribedOauth2Endpoint.this.getAuthorizationHeader(request);
                if (authValue != null && authValue.startsWith("Bearer ") && (user = (String)DescribedOauth2Endpoint.this.userTokens.get(authValue.substring(7))) != null) {
                    return Promises.newResultPromise(new Response(Status.OK).setEntity(JsonValue.json(JsonValue.object(JsonValue.field("user", user)))));
                }
                return Promises.newResultPromise(new Response(Status.UNAUTHORIZED));
            }
        });
    }

    private String getAuthorizationHeader(Request request) {
        Header authHeader = request.getHeaders().get("Authorization");
        String authValue = null;
        if (authHeader != null) {
            authValue = authHeader.getFirstValue();
        }
        return authValue;
    }

    @Override
    public Promise<Response, NeverThrowsException> handle(Context context, Request request) {
        return this.router.handle(context, request);
    }

    @Override
    public Swagger api(ApiProducer<Swagger> producer) {
        this.descriptor = producer.addApiInfo(DESCRIPTOR);
        return this.descriptor;
    }

    @Override
    public Swagger handleApiRequest(Context context, Request request) {
        return this.descriptor;
    }

    @Override
    public void addDescriptorListener(Describable.Listener listener) {
    }

    @Override
    public void removeDescriptorListener(Describable.Listener listener) {
    }

    static {
        try {
            DESCRIPTOR = new ObjectMapper(new YAMLFactory()).registerModule(new DeserializationModule()).readValue(DescribedOauth2Endpoint.class.getResourceAsStream("DescribedOAuth2Endpoint.openapi.yaml"), Swagger.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

