/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.filter;

import java.util.Arrays;
import java.util.List;
import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.filter.OptionsFilter;
import org.forgerock.http.filter.SessionFilter;
import org.forgerock.http.handler.Handlers;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.session.SessionManager;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;

public final class Filters {
    private static final Filter EMPTY_FILTER = new Filter(){

        @Override
        public Promise<Response, NeverThrowsException> filter(Context context, Request request, Handler next2) {
            return next2.handle(context, request);
        }
    };

    private Filters() {
    }

    public static Filter newOptionsFilter(String ... allowedMethods) {
        return new OptionsFilter(allowedMethods);
    }

    public static Filter newSessionFilter(SessionManager sessionManager) {
        return new SessionFilter(sessionManager);
    }

    public static Filter chainOf(Filter ... filters) {
        return Filters.chainOf(Arrays.asList(filters));
    }

    public static Filter chainOf(List<Filter> filters) {
        if (filters.isEmpty()) {
            return EMPTY_FILTER;
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        return Filters.combine(filters.get(0), Filters.chainOf(filters.subList(1, filters.size())));
    }

    private static Filter combine(final Filter first2, final Filter second2) {
        return new Filter(){

            @Override
            public Promise<Response, NeverThrowsException> filter(Context context, Request request, Handler next2) {
                return first2.filter(context, request, Handlers.filtered(next2, second2));
            }
        };
    }
}

