/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.filter;

import java.util.Arrays;
import java.util.List;
import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Status;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public final class OptionsFilter
implements Filter {
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_PATCH = "PATCH";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_TRACE = "TRACE";
    private final List<String> allowedMethods;

    OptionsFilter(String ... allowedMethods) {
        this.allowedMethods = Arrays.asList(allowedMethods);
    }

    @Override
    public Promise<Response, NeverThrowsException> filter(Context context, Request request, Handler next2) {
        switch (request.getMethod()) {
            case "OPTIONS": {
                Response response = new Response(Status.OK);
                response.getHeaders().put("Allow", (Object)this.allowedMethods);
                return Promises.newResultPromise(response);
            }
        }
        return next2.handle(context, request);
    }
}

