/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.filter;

import java.io.IOException;
import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.session.Session;
import org.forgerock.http.session.SessionContext;
import org.forgerock.http.session.SessionManager;
import org.forgerock.services.context.Context;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.ResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(SessionFilter.class);
    private final SessionManager sessionManager;

    SessionFilter(SessionManager sessionManager) {
        Reject.ifNull(sessionManager, "sessionManager must not be null");
        this.sessionManager = sessionManager;
    }

    @Override
    public Promise<Response, NeverThrowsException> filter(Context context, Request request, Handler next2) {
        final SessionContext sessionContext = context.asContext(SessionContext.class);
        final Session oldSession = sessionContext.getSession();
        sessionContext.setSession(this.sessionManager.load(request));
        return next2.handle(context, request).thenOnResult(new ResultHandler<Response>(){

            @Override
            public void handleResult(Response response) {
                try {
                    SessionFilter.this.sessionManager.save(sessionContext.getSession(), response);
                }
                catch (IOException e) {
                    logger.error("Failed to save session", e);
                }
                finally {
                    sessionContext.setSession(oldSession);
                }
            }
        });
    }
}

