/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.filter;

import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.header.MalformedHeaderException;
import org.forgerock.http.header.TransactionIdHeader;
import org.forgerock.http.protocol.Headers;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.services.TransactionId;
import org.forgerock.services.context.Context;
import org.forgerock.services.context.TransactionIdContext;
import org.forgerock.util.annotations.VisibleForTesting;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionIdInboundFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(TransactionIdInboundFilter.class);
    public static final String SYSPROP_TRUST_TRANSACTION_HEADER = "org.forgerock.http.TrustTransactionHeader";
    private final boolean trustTransactionIdHeader = Boolean.getBoolean("org.forgerock.http.TrustTransactionHeader");

    @Override
    public Promise<Response, NeverThrowsException> filter(Context context, Request request, Handler next2) {
        if (context.containsContext(TransactionIdContext.class)) {
            logger.trace("A TransactionIdContext already exists in the context's chain.");
        }
        TransactionId transactionId = this.trustTransactionIdHeader ? TransactionIdInboundFilter.createTransactionId(request.getHeaders()) : new TransactionId();
        TransactionIdContext newContext = new TransactionIdContext(context, transactionId);
        return next2.handle(newContext, request);
    }

    @VisibleForTesting
    static TransactionId createTransactionId(Headers headers) {
        try {
            TransactionIdHeader txHeader = headers.get(TransactionIdHeader.class);
            return txHeader == null ? new TransactionId() : txHeader.getTransactionId();
        }
        catch (MalformedHeaderException ex) {
            logger.trace("The TransactionId header is malformed.", ex);
            return new TransactionId();
        }
    }
}

