/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.forgerock.http.header.HeaderFactory;
import org.forgerock.http.header.HeaderUtil;
import org.forgerock.http.protocol.Header;
import org.forgerock.util.Pair;
import org.forgerock.util.i18n.PreferredLocales;

public final class AcceptLanguageHeader
extends Header {
    public static final String NAME = "Accept-Language";
    private static final Comparator<Pair<Locale, BigDecimal>> LOCALES_QUALITY_COMPARATOR = new Comparator<Pair<Locale, BigDecimal>>(){

        @Override
        public int compare(Pair<Locale, BigDecimal> o1, Pair<Locale, BigDecimal> o2) {
            return o2.getSecond().compareTo(o1.getSecond());
        }
    };
    private final PreferredLocales locales;

    public static AcceptLanguageHeader valueOf(PreferredLocales locales) {
        return new AcceptLanguageHeader(locales);
    }

    public static AcceptLanguageHeader valueOf(List<Locale> locales) {
        return AcceptLanguageHeader.valueOf(new PreferredLocales(locales));
    }

    public static AcceptLanguageHeader valueOf(String ... languageTags) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String languageTag : languageTags) {
            locales.add(Locale.forLanguageTag(languageTag));
        }
        return AcceptLanguageHeader.valueOf(new PreferredLocales(locales));
    }

    public static AcceptLanguageHeader valueOf(Set<String> headerValues) {
        if (headerValues == null || headerValues.isEmpty()) {
            return null;
        }
        ArrayList<Pair<Locale, BigDecimal>> localeWeightings = new ArrayList<Pair<Locale, BigDecimal>>();
        for (String language : HeaderUtil.split(HeaderUtil.join(headerValues, ','), ',')) {
            List<String> list2 = HeaderUtil.split(language, ';');
            BigDecimal quality = BigDecimal.ONE;
            if (list2.size() == 2) {
                String[] parameter = HeaderUtil.parseParameter(list2.get(1).trim());
                if (!"q".equals(parameter[0])) {
                    throw new IllegalArgumentException("Unrecognised parameter: " + parameter[0]);
                }
                quality = new BigDecimal(parameter[1].trim());
            } else if (list2.size() != 1) {
                throw new IllegalArgumentException("Unrecognised parameter(s): " + language);
            }
            localeWeightings.add(Pair.of(Locale.forLanguageTag(list2.get(0).trim()), quality));
        }
        Collections.sort(localeWeightings, LOCALES_QUALITY_COMPARATOR);
        ArrayList<Locale> locales = new ArrayList<Locale>(localeWeightings.size());
        for (Pair pair : localeWeightings) {
            locales.add((Locale)pair.getFirst());
        }
        return new AcceptLanguageHeader(new PreferredLocales(locales));
    }

    private AcceptLanguageHeader(PreferredLocales locales) {
        this.locales = locales;
    }

    public PreferredLocales getLocales() {
        return this.locales;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getValues() {
        StringBuilder valueString = new StringBuilder();
        List<Locale> locales = this.locales.getLocales();
        BigDecimal qualityStep = AcceptLanguageHeader.getQualityStep(locales.size());
        BigDecimal quality = BigDecimal.ONE;
        for (Locale locale : locales) {
            if (valueString.length() != 0) {
                valueString.append(",");
            }
            valueString.append(locale.equals(Locale.ROOT) ? "*" : locale.toLanguageTag()).append(";q=").append(quality.toString());
            quality = quality.subtract(qualityStep);
        }
        return Collections.singletonList(valueString.toString());
    }

    static BigDecimal getQualityStep(int numberLocales) {
        if (numberLocales <= 1) {
            return BigDecimal.ONE;
        }
        int nextPowerOfTen = (int)Math.ceil(Math.log10(numberLocales));
        return BigDecimal.ONE.divide(BigDecimal.TEN.pow(nextPowerOfTen));
    }

    static class Factory
    extends HeaderFactory<AcceptLanguageHeader> {
        Factory() {
        }

        @Override
        public AcceptLanguageHeader parse(String value2) {
            return AcceptLanguageHeader.valueOf(Collections.singleton(value2));
        }

        @Override
        public AcceptLanguageHeader parse(List<String> values2) {
            return AcceptLanguageHeader.valueOf(new LinkedHashSet<String>(values2));
        }
    }
}

