/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.forgerock.http.decoder.Decoder;
import org.forgerock.http.header.HeaderFactory;
import org.forgerock.http.header.HeaderUtil;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Message;

public class ContentEncodingHeader
extends Header {
    public static final String NAME = "Content-Encoding";
    private final List<String> codings;

    public ContentEncodingHeader() {
        this(new ArrayList<String>(1));
    }

    public ContentEncodingHeader(List<String> codings) {
        this.codings = codings;
    }

    public static ContentEncodingHeader valueOf(Message message2) {
        return new ContentEncodingHeader(HeaderUtil.parseMultiValuedHeader(message2, NAME));
    }

    public static ContentEncodingHeader valueOf(String string2) {
        return new ContentEncodingHeader(HeaderUtil.parseMultiValuedHeader(string2));
    }

    public InputStream decode(InputStream in) throws IOException {
        ListIterator<String> i2 = this.codings.listIterator(this.codings.size());
        while (i2.hasPrevious()) {
            String name2 = i2.previous();
            Decoder decoder = Decoder.SERVICES.get(name2);
            if (decoder == null) {
                throw new UnsupportedEncodingException(name2);
            }
            in = decoder.decode(in);
        }
        return in;
    }

    public List<String> getCodings() {
        return this.codings;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getValues() {
        String joined = HeaderUtil.join(this.codings, ',');
        return joined == null ? Collections.emptyList() : Collections.singletonList(joined);
    }

    static class Factory
    extends HeaderFactory<ContentEncodingHeader> {
        Factory() {
        }

        @Override
        public ContentEncodingHeader parse(String value2) {
            return ContentEncodingHeader.valueOf(value2);
        }

        @Override
        public ContentEncodingHeader parse(List<String> values2) {
            return ContentEncodingHeader.valueOf(HeaderUtil.join(values2, ','));
        }
    }
}

