/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.util.Collections;
import java.util.List;
import org.forgerock.http.header.AbstractSingleValuedHeaderFactory;
import org.forgerock.http.header.HeaderUtil;
import org.forgerock.http.header.MalformedHeaderException;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Message;

public class ContentLengthHeader
extends Header {
    public static final String NAME = "Content-Length";
    private long length;

    public static ContentLengthHeader valueOf(Message message2) {
        return ContentLengthHeader.valueOf(HeaderUtil.parseSingleValuedHeader(message2, NAME));
    }

    public static ContentLengthHeader valueOf(String string2) {
        long length2 = -1L;
        if (string2 != null) {
            try {
                length2 = Long.parseLong(string2);
                length2 = length2 >= 0L ? length2 : -1L;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new ContentLengthHeader(length2);
    }

    public ContentLengthHeader() {
        this(-1L);
    }

    public ContentLengthHeader(long length2) {
        this.length = length2;
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getValues() {
        return this.length >= 0L ? Collections.singletonList(Long.toString(this.length)) : Collections.emptyList();
    }

    static class Factory
    extends AbstractSingleValuedHeaderFactory<ContentLengthHeader> {
        Factory() {
        }

        @Override
        public ContentLengthHeader parse(String value2) {
            return ContentLengthHeader.valueOf(value2);
        }

        @Override
        public ContentLengthHeader parse(Object value2) throws MalformedHeaderException {
            if (value2 instanceof Number) {
                return new ContentLengthHeader(((Number)value2).longValue());
            }
            return (ContentLengthHeader)super.parse(value2);
        }
    }
}

