/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.forgerock.http.header.AbstractSingleValuedHeaderFactory;
import org.forgerock.http.header.HeaderUtil;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Message;
import org.forgerock.util.Reject;

public class ContentTypeHeader
extends Header {
    public static final String NAME = "Content-Type";
    private final String type;
    private final String charset;
    private final String boundary;
    private final Map<String, String> additionalParameters;

    public static ContentTypeHeader valueOf(Message message2) {
        return ContentTypeHeader.valueOf(HeaderUtil.parseSingleValuedHeader(message2, NAME));
    }

    public static ContentTypeHeader valueOf(String string2) {
        List<String> parts = HeaderUtil.split(string2, ';');
        if (parts.size() > 0) {
            String type2 = parts.remove(0);
            Map<String, String> parameters2 = HeaderUtil.parseParameters(parts);
            String charset = parameters2.remove("charset");
            String boundary = parameters2.remove("boundary");
            return new ContentTypeHeader(type2, charset, boundary, parameters2);
        }
        return new ContentTypeHeader(null, null, null);
    }

    public ContentTypeHeader() {
        this(null, null, null);
    }

    public ContentTypeHeader(String type2, String charset, String boundary) {
        this(type2, charset, boundary, Collections.emptyMap());
    }

    public ContentTypeHeader(String type2, String charset, String boundary, Map<String, String> additionalParameters) {
        this.type = type2;
        this.charset = charset;
        this.boundary = boundary;
        this.additionalParameters = Reject.checkNotNull(additionalParameters);
    }

    public String getType() {
        return this.type;
    }

    public Charset getCharset() {
        return this.charset != null ? Charset.forName(this.charset) : null;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public Map<String, String> getAdditionalParameters() {
        return this.additionalParameters;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getValues() {
        if (this.type == null || this.type.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.type);
        if (this.charset != null) {
            sb.append("; charset=").append(this.charset);
        }
        if (this.boundary != null) {
            sb.append("; boundary=").append(this.boundary);
        }
        for (String key2 : this.additionalParameters.keySet()) {
            sb.append("; ").append(key2);
            String value2 = this.additionalParameters.get(key2);
            if (value2 == null) continue;
            sb.append("=").append(value2);
        }
        return sb.length() > 0 ? Collections.singletonList(sb.toString()) : Collections.emptyList();
    }

    static class Factory
    extends AbstractSingleValuedHeaderFactory<ContentTypeHeader> {
        Factory() {
        }

        @Override
        public ContentTypeHeader parse(String value2) {
            return ContentTypeHeader.valueOf(value2);
        }
    }
}

